/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LDAPUserPageList;
import org.exoplatform.services.organization.ldap.UserDAOImpl;

public class ADUserDAOImpl
extends UserDAOImpl {
    int UF_ACCOUNTDISABLE = 2;
    int UF_PASSWD_NOTREQD = 32;
    int UF_NORMAL_ACCOUNT = 512;
    int UF_PASSWORD_EXPIRED = 0x800000;

    public ADUserDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService) throws Exception {
        super(ldapAttrMapping, ldapService);
        LDAPUserPageList.SEARCH_CONTROL = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(User user, boolean broadcast) throws Exception {
        String userDN = this.ldapAttrMapping.userDNKey + "=" + user.getUserName() + "," + this.ldapAttrMapping.userURL;
        Attributes attrs = this.ldapAttrMapping.userToAttributes(user);
        attrs.put("userAccountControl", Integer.toString(this.UF_NORMAL_ACCOUNT + this.UF_PASSWD_NOTREQD + this.UF_PASSWORD_EXPIRED + this.UF_ACCOUNTDISABLE));
        attrs.remove(this.ldapAttrMapping.userPassword);
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    if (broadcast) {
                        this.preSave(user, true);
                    }
                    ctx.createSubcontext(userDN, attrs);
                    if (broadcast) {
                        this.postSave(user, true);
                    }
                }
                catch (NamingException e) {
                    if (!ADUserDAOImpl.isConnectionError(e) || err >= ADUserDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
        this.saveUserPassword(user, userDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveUserPassword(User user, String userDN) throws Exception {
        Object v = this.ldapService.getLdapContext().getEnvironment().get("java.naming.security.protocol");
        if (v == null) {
            return;
        }
        String security = String.valueOf(v);
        if (!security.equalsIgnoreCase("ssl")) {
            return;
        }
        String newQuotedPassword = "\"" + user.getPassword() + "\"";
        byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.userPassword, newUnicodePassword)), new ModificationItem(2, new BasicAttribute("userAccountControl", Integer.toString(this.UF_NORMAL_ACCOUNT + this.UF_PASSWORD_EXPIRED)))};
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    ctx.modifyAttributes(userDN, mods);
                }
                catch (NamingException e) {
                    if (!ADUserDAOImpl.isConnectionError(e) || err >= ADUserDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }
}

