/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.MoveType;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.html.parser.ParserService;

final class NodeCloser {
    NodeCloser() {
    }

    void close(NodeConfig config) {
        if (config.only()) {
            return;
        }
        if (config.parent().length > 0) {
            NodeImpl parent = ParserService.getNodeCreator().getOpenParent(config, false);
            if (parent == null) {
                return;
            }
            List<HTMLNode> children = parent.getChildrenNode();
            for (int j = children.size() - 1; j > -1; --j) {
                if (!((NodeImpl)children.get(j)).isOpen()) continue;
                this.close((NodeImpl)children.get(j));
                break;
            }
            return;
        }
        List<NodeImpl> opens = ParserService.getNodeCreator().getOpens();
        for (int i = opens.size() - 1; i > -1; --i) {
            if (opens.get(i).getConfig().name() != config.name()) {
                if (!opens.get(i).getConfig().block()) continue;
                break;
            }
            this.close(opens.get(i));
            break;
        }
    }

    void close(NodeImpl node) {
        if (!node.isOpen()) {
            return;
        }
        node.setIsOpen(false);
        ParserService.getNodeCreator().getOpens().remove(node);
        List<HTMLNode> children = node.getChildrenNode();
        for (HTMLNode ele : children) {
            this.close((NodeImpl)ele);
        }
        NodeConfig config = node.getConfig();
        if (config.children().length > 0 || config.children_types().length > 0) {
            Iterator<HTMLNode> iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                HTMLNode child = iter.next();
                if (HTML.isChild(node, child.getConfig())) continue;
                iter.remove();
                if (config.move() != MoveType.INSERT) continue;
                this.insert(node, child);
            }
        }
        if (config.move() != MoveType.HEADER) {
            return;
        }
        HTMLNode header = null;
        if (ParserService.getRootNode().getChildren().size() > 0) {
            header = ParserService.getRootNode().getChildren().get(0);
        }
        if (header == null || !header.isNode(Name.HEAD)) {
            header = ParserService.createHeader();
        }
        node.getParent().getChildren().remove(node);
        header.addChild(node);
        node.setParent(header);
    }

    private void insert(HTMLNode node, HTMLNode element) {
        HTMLNode parent = node.getParent();
        List<HTMLNode> children = parent.getChildren();
        int i = children.indexOf(node);
        if (i < 0) {
            return;
        }
        children.add(i, element);
        element.setParent(parent);
    }
}

