/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

public class XMLChar {
    public static boolean isSupplemental(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    public static int supplemental(char h, char l) {
        return (h - 55296) * 1024 + (l - 56320) + 65536;
    }

    public static char highSurrogate(int ch) {
        return (char)((ch - 65536 >> 10) + 55296);
    }

    public static char lowSurrogate(int ch) {
        return (char)((ch - 65536 & 0x3FF) + 56320);
    }

    public static boolean isHighSurrogate(int ch) {
        return 55296 <= ch && ch <= 56319;
    }

    public static boolean isLowSurrogate(int ch) {
        return 56320 <= ch && ch <= 57343;
    }

    public static boolean isMarkup(int c) {
        return c == 60 || c == 38 || c == 37;
    }

    public static boolean isChar(int ch) {
        return 9 == ch || 10 == ch || 13 == ch || 32 <= ch && ch <= 55295 || 57344 <= ch && ch <= 65533 || 65536 <= ch && ch <= 0x10FFFF;
    }

    public static boolean isValid(int ch) {
        return XMLChar.isChar(ch);
    }

    public static boolean isInvalid(int ch) {
        return !XMLChar.isValid(ch);
    }

    public static boolean isSpace(int ch) {
        return 32 == ch || 9 == ch || 13 == ch || 10 == ch;
    }

    public static boolean isDigit(int ch) {
        return 48 <= ch && ch <= 57 || 1632 <= ch && ch <= 1641 || 1776 <= ch && ch <= 1785 || 2406 <= ch && ch <= 2415 || 2534 <= ch && ch <= 2543 || 2662 <= ch && ch <= 2671 || 2790 <= ch && ch <= 2799 || 2918 <= ch && ch <= 2927 || 3047 <= ch && ch <= 3055 || 3174 <= ch && ch <= 3183 || 3302 <= ch && ch <= 3311 || 3430 <= ch && ch <= 3439 || 3664 <= ch && ch <= 3673 || 3792 <= ch && ch <= 3801 || 3872 <= ch && ch <= 3881;
    }

    public static boolean isBaseChar(int ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 255 || 256 <= ch && ch <= 305 || 308 <= ch && ch <= 318 || 321 <= ch && ch <= 328 || 330 <= ch && ch <= 382 || 384 <= ch && ch <= 451 || 461 <= ch && ch <= 496 || 500 <= ch && ch <= 501 || 506 <= ch && ch <= 535 || 592 <= ch && ch <= 680 || 699 <= ch && ch <= 705 || 902 == ch || 904 <= ch && ch <= 906 || 908 == ch || 910 <= ch && ch <= 929 || 931 <= ch && ch <= 974 || 976 <= ch && ch <= 982 || 986 == ch || 988 == ch || 990 == ch || 992 == ch || 994 <= ch && ch <= 1011 || 1025 <= ch && ch <= 1036 || 1038 <= ch && ch <= 1103 || 1105 <= ch && ch <= 1116 || 1118 <= ch && ch <= 1153 || 1168 <= ch && ch <= 1220 || 1223 <= ch && ch <= 1224 || 1227 <= ch && ch <= 1228 || 1232 <= ch && ch <= 1259 || 1262 <= ch && ch <= 1269 || 1272 <= ch && ch <= 1273 || 1329 <= ch && ch <= 1366 || 1369 == ch || 1377 <= ch && ch <= 1414 || 1488 <= ch && ch <= 1514 || 1520 <= ch && ch <= 1522 || 1569 <= ch && ch <= 1594 || 1601 <= ch && ch <= 1610 || 1649 <= ch && ch <= 1719 || 1722 <= ch && ch <= 1726 || 1728 <= ch && ch <= 1742 || 1744 <= ch && ch <= 1747 || 1749 == ch || 1765 <= ch && ch <= 1766 || 2309 <= ch && ch <= 2361 || 2365 == ch || 2392 <= ch && ch <= 2401 || 2437 <= ch && ch <= 2444 || 2447 <= ch && ch <= 2448 || 2451 <= ch && ch <= 2472 || 2474 <= ch && ch <= 2480 || 2482 == ch || 2486 <= ch && ch <= 2489 || 2524 <= ch && ch <= 2525 || 2527 <= ch && ch <= 2529 || 2544 <= ch && ch <= 2545 || 2565 <= ch && ch <= 2570 || 2575 <= ch && ch <= 2576 || 2579 <= ch && ch <= 2600 || 2602 <= ch && ch <= 2608 || 2610 <= ch && ch <= 2611 || 2613 <= ch && ch <= 2614 || 2616 <= ch && ch <= 2617 || 2649 <= ch && ch <= 2652 || 2654 == ch || 2674 <= ch && ch <= 2676 || 2693 <= ch && ch <= 2699 || 2701 == ch || 2703 <= ch && ch <= 2705 || 2707 <= ch && ch <= 2728 || 2730 <= ch && ch <= 2736 || 2738 <= ch && ch <= 2739 || 2741 <= ch && ch <= 2745 || 2749 == ch || 2784 == ch || 2821 <= ch && ch <= 2828 || 2831 <= ch && ch <= 2832 || 2835 <= ch && ch <= 2856 || 2858 <= ch && ch <= 2864 || 2866 <= ch && ch <= 2867 || 2870 <= ch && ch <= 2873 || 2877 == ch || 2908 <= ch && ch <= 2909 || 2911 <= ch && ch <= 2913 || 2949 <= ch && ch <= 2954 || 2958 <= ch && ch <= 2960 || 2962 <= ch && ch <= 2965 || 2969 <= ch && ch <= 2970 || 2972 == ch || 2974 <= ch && ch <= 2975 || 2979 <= ch && ch <= 2980 || 2984 <= ch && ch <= 2986 || 2990 <= ch && ch <= 2997 || 2999 <= ch && ch <= 3001 || 3077 <= ch && ch <= 3084 || 3086 <= ch && ch <= 3088 || 3090 <= ch && ch <= 3112 || 3114 <= ch && ch <= 3123 || 3125 <= ch && ch <= 3129 || 3168 <= ch && ch <= 3169 || 3205 <= ch && ch <= 3212 || 3214 <= ch && ch <= 3216 || 3218 <= ch && ch <= 3240 || 3242 <= ch && ch <= 3251 || 3253 <= ch && ch <= 3257 || 3294 == ch || 3296 <= ch && ch <= 3297 || 3333 <= ch && ch <= 3340 || 3342 <= ch && ch <= 3344 || 3346 <= ch && ch <= 3368 || 3370 <= ch && ch <= 3385 || 3424 <= ch && ch <= 3425 || 3585 <= ch && ch <= 3630 || 3632 == ch || 3634 <= ch && ch <= 3635 || 3648 <= ch && ch <= 3653 || 3713 <= ch && ch <= 3714 || 3716 == ch || 3719 <= ch && ch <= 3720 || 3722 == ch || 3725 == ch || 3732 <= ch && ch <= 3735 || 3737 <= ch && ch <= 3743 || 3745 <= ch && ch <= 3747 || 3749 == ch || 3751 == ch || 3754 <= ch && ch <= 3755 || 3757 <= ch && ch <= 3758 || 3760 == ch || 3762 <= ch && ch <= 3763 || 3773 == ch || 3776 <= ch && ch <= 3780 || 3904 <= ch && ch <= 3911 || 3913 <= ch && ch <= 3945 || 4256 <= ch && ch <= 4293 || 4304 <= ch && ch <= 4342 || 4352 == ch || 4354 <= ch && ch <= 4355 || 4357 <= ch && ch <= 4359 || 4361 == ch || 4363 <= ch && ch <= 4364 || 4366 <= ch && ch <= 4370 || 4412 == ch || 4414 == ch || 4416 == ch || 4428 == ch || 4430 == ch || 4432 == ch || 4436 <= ch && ch <= 4437 || 4441 == ch || 4447 <= ch && ch <= 4449 || 4451 == ch || 4453 == ch || 4455 == ch || 4457 == ch || 4461 <= ch && ch <= 4462 || 4466 <= ch && ch <= 4467 || 4469 == ch || 4510 == ch || 4520 == ch || 4523 == ch || 4526 <= ch && ch <= 4527 || 4535 <= ch && ch <= 4536 || 4538 == ch || 4540 <= ch && ch <= 4546 || 4587 == ch || 4592 == ch || 4601 == ch || 7680 <= ch && ch <= 7835 || 7840 <= ch && ch <= 7929 || 7936 <= ch && ch <= 7957 || 7960 <= ch && ch <= 7965 || 7968 <= ch && ch <= 8005 || 8008 <= ch && ch <= 8013 || 8016 <= ch && ch <= 8023 || 8025 == ch || 8027 == ch || 8029 == ch || 8031 <= ch && ch <= 8061 || 8064 <= ch && ch <= 8116 || 8118 <= ch && ch <= 8124 || 8126 == ch || 8130 <= ch && ch <= 8132 || 8134 <= ch && ch <= 8140 || 8144 <= ch && ch <= 8147 || 8150 <= ch && ch <= 8155 || 8160 <= ch && ch <= 8172 || 8178 <= ch && ch <= 8180 || 8182 <= ch && ch <= 8188 || 8486 == ch || 8490 <= ch && ch <= 8491 || 8494 == ch || 8576 <= ch && ch <= 8578 || 12353 <= ch && ch <= 12436 || 12449 <= ch && ch <= 12538 || 12549 <= ch && ch <= 12588 || 44032 <= ch && ch <= 55203;
    }

    public static boolean isIdeographic(int ch) {
        return 19968 <= ch && ch <= 40869 || 12295 == ch || 12321 <= ch && ch <= 12329;
    }

    public static boolean isLetter(int ch) {
        return XMLChar.isBaseChar(ch) || XMLChar.isIdeographic(ch);
    }

    public static boolean isCombiningChar(int ch) {
        return 768 <= ch && ch <= 837 || 864 <= ch && ch <= 865 || 1155 <= ch && ch <= 1158 || 1425 <= ch && ch <= 1441 || 1443 <= ch && ch <= 1465 || 1467 <= ch && ch <= 1469 || 1471 == ch || 1473 <= ch && ch <= 1474 || 1476 == ch || 1611 <= ch && ch <= 1618 || 1648 == ch || 1750 <= ch && ch <= 1756 || 1757 <= ch && ch <= 1759 || 1760 <= ch && ch <= 1764 || 1767 <= ch && ch <= 1768 || 1770 <= ch && ch <= 1773 || 2305 <= ch && ch <= 2307 || 2364 == ch || 2366 <= ch && ch <= 2380 || 2381 == ch || 2385 <= ch && ch <= 2388 || 2402 <= ch && ch <= 2403 || 2433 <= ch && ch <= 2435 || 2492 == ch || 2494 == ch || 2495 == ch || 2496 <= ch && ch <= 2500 || 2503 <= ch && ch <= 2504 || 2507 <= ch && ch <= 2509 || 2519 == ch || 2530 <= ch && ch <= 2531 || 2562 == ch || 2620 == ch || 2622 == ch || 2623 == ch || 2624 <= ch && ch <= 2626 || 2631 <= ch && ch <= 2632 || 2635 <= ch && ch <= 2637 || 2672 <= ch && ch <= 2673 || 2689 <= ch && ch <= 2691 || 2748 == ch || 2750 <= ch && ch <= 2757 || 2759 <= ch && ch <= 2761 || 2763 <= ch && ch <= 2765 || 2817 <= ch && ch <= 2819 || 2876 == ch || 2878 <= ch && ch <= 2883 || 2887 <= ch && ch <= 2888 || 2891 <= ch && ch <= 2893 || 2902 <= ch && ch <= 2903 || 2946 <= ch && ch <= 2947 || 3006 <= ch && ch <= 3010 || 3014 <= ch && ch <= 3016 || 3018 <= ch && ch <= 3021 || 3031 == ch || 3073 <= ch && ch <= 3075 || 3134 <= ch && ch <= 3140 || 3142 <= ch && ch <= 3144 || 3146 <= ch && ch <= 3149 || 3157 <= ch && ch <= 3158 || 3202 <= ch && ch <= 3203 || 3262 <= ch && ch <= 3268 || 3270 <= ch && ch <= 3272 || 3274 <= ch && ch <= 3277 || 3285 <= ch && ch <= 3286 || 3330 <= ch && ch <= 3331 || 3390 <= ch && ch <= 3395 || 3398 <= ch && ch <= 3400 || 3402 <= ch && ch <= 3405 || 3415 == ch || 3633 == ch || 3636 <= ch && ch <= 3642 || 3655 <= ch && ch <= 3662 || 3761 == ch || 3764 <= ch && ch <= 3769 || 3771 <= ch && ch <= 3772 || 3784 <= ch && ch <= 3789 || 3864 <= ch && ch <= 3865 || 3893 == ch || 3895 == ch || 3897 == ch || 3902 == ch || 3903 == ch || 3953 <= ch && ch <= 3972 || 3974 <= ch && ch <= 3979 || 3984 <= ch && ch <= 3989 || 3991 == ch || 3993 <= ch && ch <= 4013 || 4017 <= ch && ch <= 4023 || 4025 == ch || 8400 <= ch && ch <= 8412 || 8417 == ch || 12330 <= ch && ch <= 12335 || 12441 == ch || 12442 == ch;
    }

    public static boolean isExtender(int ch) {
        return 183 == ch || 720 == ch || 721 == ch || 903 == ch || 1600 == ch || 3654 == ch || 3782 == ch || 12293 == ch || 12337 <= ch && ch <= 12341 || 12445 <= ch && ch <= 12446 || 12540 <= ch && ch <= 12542;
    }

    public static boolean isName(int ch) {
        return XMLChar.isLetter(ch) || XMLChar.isDigit(ch) || 46 == ch || 45 == ch || 95 == ch || 58 == ch || XMLChar.isCombiningChar(ch) || XMLChar.isExtender(ch);
    }

    public static boolean isNameStart(int ch) {
        return XMLChar.isLetter(ch) || 95 == ch || 58 == ch;
    }

    public static boolean isValidName(String name) {
        if (name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!XMLChar.isNameStart(ch)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (XMLChar.isName(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNameStart(int ch) {
        return XMLChar.isLetter(ch) || 95 == ch;
    }

    public static boolean isNCName(int ch) {
        return XMLChar.isName(ch) && 58 != ch;
    }

    public static boolean isValidNCName(String ncName) {
        if (ncName.length() == 0) {
            return false;
        }
        char ch = ncName.charAt(0);
        if (!XMLChar.isNCNameStart(ch)) {
            return false;
        }
        for (int i = 1; i < ncName.length(); ++i) {
            ch = ncName.charAt(i);
            if (XMLChar.isNCName(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPubid(int ch) {
        return 9 == ch || 10 == ch || 13 == ch || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || 45 == ch || 39 == ch || 40 == ch || 41 == ch || 43 == ch || 44 == ch || 46 == ch || 47 == ch || 58 == ch || 61 == ch || 63 == ch || 59 == ch || 33 == ch || 42 == ch || 35 == ch || 36 == ch || 64 == ch || 95 == ch || 37 == ch;
    }

    public static boolean isValidNmtoken(String nmtoken) {
        if (nmtoken.length() == 0) {
            return false;
        }
        for (int i = 0; i < nmtoken.length(); ++i) {
            char ch = nmtoken.charAt(i);
            if (XMLChar.isName(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIANAEncoding(String ianaEncoding) {
        char c;
        int length;
        if (ianaEncoding != null && (length = ianaEncoding.length()) > 0 && ((c = ianaEncoding.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            for (int i = 1; i < length; ++i) {
                c = ianaEncoding.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidJavaEncoding(String javaEncoding) {
        int length;
        if (javaEncoding != null && (length = javaEncoding.length()) > 0) {
            for (int i = 1; i < length; ++i) {
                char c = javaEncoding.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

