/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryControl;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryFormContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryValueSelect;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizardContainer;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.picocontainer.PicoIntrospectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(listeners={AddWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ShowHiddenActionListener.class}), @EventConfig(listeners={RemoveWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditWorkspaceActionListener.class})})
public class UIRepositoryForm
extends UIForm
implements UIPopupComponent {
    private ConfigurationManager configurationManager;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIRepositoryForm");
    public static final String ST_ADD = "AddRepoPopup";
    public static final String ST_EDIT = "EditRepoPopup";
    public static final String POPUP_WORKSPACE = "PopupWorkspace";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WSINPUTSET = "wsInputSet";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_ISDEFAULT = "isDefault";
    public static final String FIELD_ACCESSCONTROL = "accessControl";
    public static final String FIELD_AUTHINPUTSET = "authInputSet";
    public static final String FIELD_AUTHENTICATION = "authenticationPolicy";
    public static final String FIELD_SCURITY = "securityDomain";
    public static final String FIELD_SESSIONTIME = "sessionTime";
    public static final String FIELD_REPCHANNEL = "channelConfig";
    public static final String FIELD_REPENABLE = "enableReplication";
    public static final String FIELD_REPMODE = "repMode";
    public static final String FIELD_REPTESTMODE = "repTestMode";
    public static final String FIELD_BSEPATH = "directoryPath";
    public static final String FIELD_BSEMAXBUFFER = "maxBufferSize";
    public static final String KEY_AUTHENTICATIONPOLICY = "org.exoplatform.services.jcr.impl.core.access.JAASAuthenticator";
    protected boolean isAddnew_ = true;
    protected String defaulWorkspace_ = null;
    protected String dmsSystemWorkspace_ = null;
    protected String repoName_ = null;
    protected Map<String, WorkspaceEntry> workspaceMap_ = new HashMap<String, WorkspaceEntry>();
    protected Map<String, String> workspaceMapNodeType_ = new HashMap<String, String>();
    protected Map<String, String> workspaceMapPermission_ = new HashMap<String, String>();
    protected Map<String, String> defaulWorkspaceMap = new HashMap<String, String>();

    public UIRepositoryForm() throws Exception {
        this.configurationManager = (ConfigurationManager)this.getApplicationComponent(ConfigurationManager.class);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction workspaceField = new UIFormInputSetWithAction(FIELD_WSINPUTSET);
        workspaceField.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_WORKSPACE, FIELD_WORKSPACE, null));
        workspaceField.setActionInfo(FIELD_WORKSPACE, new String[]{"EditWorkspace", "RemoveWorkspace"});
        this.addUIComponentInput((UIComponent)workspaceField);
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_ISDEFAULT, FIELD_ISDEFAULT, null).setEditable(false));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_ACCESSCONTROL, FIELD_ACCESSCONTROL, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction autField = new UIFormInputSetWithAction(FIELD_AUTHINPUTSET);
        autField.addChild((UIComponent)new UIFormStringInput(FIELD_AUTHENTICATION, FIELD_AUTHENTICATION, null).addValidator(MandatoryValidator.class, new Object[0]));
        autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        this.addChild((UIComponent)autField);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SCURITY, FIELD_SCURITY, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SESSIONTIME, FIELD_SESSIONTIME, null));
    }

    public void refresh(RepositoryEntry repo) throws Exception {
        this.reset();
        this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        this.workspaceMap_.clear();
        if (repo != null) {
            if (this.isAddnew_) {
                this.repoName_ = null;
                this.defaulWorkspace_ = null;
                this.dmsSystemWorkspace_ = null;
                this.refreshWorkspaceList();
                this.getUIStringInput(FIELD_NAME).setEditable(true);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                this.setActions(new String[]{"Save", "AddWorkspace", "Reset", "Close"});
            } else {
                this.repoName_ = repo.getName();
                this.defaulWorkspace_ = repo.getDefaultWorkspaceName();
                this.dmsSystemWorkspace_ = repo.getSystemWorkspaceName();
                for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                    this.workspaceMap_.put(ws.getName(), ws);
                }
                this.getUIStringInput(FIELD_NAME).setEditable(false);
                this.getUIStringInput(FIELD_NAME).setValue((Object)repo.getName());
                this.refreshWorkspaceList();
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(this.isDefaultRepo(repo.getName()));
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                autField.setActionInfo(FIELD_AUTHENTICATION, null);
                this.setActions(new String[]{"AddWorkspace", "Close"});
            }
            this.getUIStringInput(FIELD_ACCESSCONTROL).setValue((Object)repo.getAccessControl());
            autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)repo.getAuthenticationPolicy());
            this.getUIStringInput(FIELD_SCURITY).setValue((Object)repo.getSecurityDomain());
            this.getUIStringInput(FIELD_SESSIONTIME).setValue((Object)String.valueOf(repo.getSessionTimeOut()));
        }
    }

    protected void lockForm(boolean isLock) throws Exception {
        boolean editable = !isLock;
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        if (isLock) {
            autField.setActionInfo(FIELD_AUTHENTICATION, null);
        } else {
            autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        }
        this.getUIStringInput(FIELD_ACCESSCONTROL).setEditable(editable);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setEditable(editable);
        this.getUIStringInput(FIELD_SCURITY).setEditable(editable);
        this.getUIStringInput(FIELD_SESSIONTIME).setEditable(editable);
    }

    protected boolean isDefaultWorkspace(String workspaceName) {
        return workspaceName.equals(this.defaulWorkspace_);
    }

    protected boolean isDmsSystemWorkspace(String workspaceName) {
        return workspaceName.equals(this.dmsSystemWorkspace_);
    }

    protected boolean isExistWorkspace(String workspaceName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        for (RepositoryEntry repo : rservice.getConfig().getRepositoryConfigurations()) {
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                if (!ws.getName().equals(workspaceName)) continue;
                return true;
            }
        }
        return false;
    }

    protected WorkspaceEntry getWorkspace(String workspaceName) {
        return this.workspaceMap_.get(workspaceName);
    }

    protected Map<String, WorkspaceEntry> getWorkspaceMap() {
        return this.workspaceMap_;
    }

    protected String getWorkspaceMapNodeType(String workspaceName) {
        return this.workspaceMapNodeType_.get(workspaceName);
    }

    protected Map<String, String> getWorkspaceMapNodeType() {
        return this.workspaceMapNodeType_;
    }

    protected String getWorkspaceMapPermission(String workspaceName) {
        return this.workspaceMapPermission_.get(workspaceName);
    }

    protected Map<String, String> getWorkspaceMapPermission() {
        return this.workspaceMapPermission_;
    }

    protected void refreshWorkspaceList() {
        StringBuilder labels = new StringBuilder();
        for (String wsName : this.workspaceMap_.keySet()) {
            if (labels.length() > 0) {
                labels.append(",");
            }
            labels.append(wsName);
        }
        UIFormInputSetWithAction workspaceField = (UIFormInputSetWithAction)this.getChildById(FIELD_WSINPUTSET);
        workspaceField.setInfoField(FIELD_WORKSPACE, labels.toString());
    }

    protected boolean isDefaultRepo(String repoName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rservice.getConfig().getDefaultRepositoryName().equals(repoName);
    }

    protected void saveRepo(RepositoryEntry repositoryEntry) throws Exception {
        InitialContextInitializer ic = (InitialContextInitializer)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(InitialContextInitializer.class);
        RegistryService registryService = (RegistryService)this.getApplicationComponent(RegistryService.class);
        if (ic != null) {
            ic.recall();
        }
        RepositoryService rService = (RepositoryService)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(RepositoryService.class);
        if (this.isAddnew_) {
            try {
                rService.createRepository(repositoryEntry);
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (!ws.getName().equals(repositoryEntry.getSystemWorkspaceName())) continue;
                    registryService.addRegistryLocation(repositoryEntry.getName(), ws.getName());
                }
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (rService.getRepository(repositoryEntry.getName()).isWorkspaceInitialized(ws.getName())) continue;
                    rService.getRepository(repositoryEntry.getName()).configWorkspace(ws);
                    rService.getRepository(repositoryEntry.getName()).createWorkspace(ws.getName());
                }
            }
            catch (RepositoryConfigurationException repositoryConfigurationException) {
                return;
            }
            catch (PicoIntrospectionException picoIntrospectionException) {
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                return;
            }
            this.initServices(repositoryEntry.getName());
            if (rService.getConfig().isRetainable()) {
                rService.getConfig().retain();
            }
        }
    }

    private void initServices(String repository) throws Exception {
        try {
            RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            InputStream xml = this.configurationManager.getURL("classpath:/conf/portal/registry-nodetypes.xml").openStream();
            rService.getRepository(repository).getNodeTypeManager().registerNodeTypes(xml, 0);
            xml.close();
            ((RegistryService)this.getApplicationComponent(RegistryService.class)).initStorage(false);
            ((NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class)).init(repository);
            ((TaxonomyService)this.getApplicationComponent(TaxonomyService.class)).init(repository);
            ((ManageDriveService)this.getApplicationComponent(ManageDriveService.class)).init(repository);
            ((NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class)).init(repository);
            ((MetadataService)this.getApplicationComponent(MetadataService.class)).init(repository);
            ((QueryService)this.getApplicationComponent(QueryService.class)).init(repository);
            ((RelationsService)this.getApplicationComponent(RelationsService.class)).init(repository);
            ((ScriptService)this.getApplicationComponent(ScriptService.class)).initRepo(repository);
            ((TemplateService)this.getApplicationComponent(TemplateService.class)).init(repository);
            ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).init(repository);
            ((ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class)).init(repository);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (ItemExistsException itemExistsException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return;
        }
    }

    protected void ShowHidden() {
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.repoName_ = null;
    }

    private void addConfiguration(String fileConfiguration) throws Exception {
        block4: {
            SAXBuilder builder1 = new SAXBuilder();
            Document docConfiguration = null;
            Element rootConfiguration = null;
            boolean isExist = false;
            try {
                docConfiguration = builder1.build(fileConfiguration);
                rootConfiguration = docConfiguration.getRootElement();
                List listImportElement = rootConfiguration.getChildren("import");
                for (int i = 0; i < listImportElement.size(); ++i) {
                    Element element = (Element)listImportElement.get(i);
                    if (!element.getValue().trim().equals("dms-common-extend-configuration.xml")) continue;
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    Element importElement = new Element("import");
                    importElement.addContent("dms-common-extend-configuration.xml");
                    rootConfiguration.addContent((Content)importElement);
                    XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
                    xmlOutputter.output(docConfiguration, (Writer)new FileWriter(fileConfiguration));
                }
            }
            catch (FileNotFoundException e) {
                StringBuilder builder = new StringBuilder();
                PrintWriter outputStream = null;
                builder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                builder.append("<configuration>\n");
                builder.append("  <import>dms-common-extend-configuration.xml</import>\n");
                builder.append("</configuration>\n");
                FileWriter outputFileReader = new FileWriter(fileConfiguration);
                outputStream = new PrintWriter(outputFileReader);
                outputStream.println(builder);
                if (outputStream == null) break block4;
                outputStream.close();
            }
        }
    }

    private void addElement(String fileDmsCommon, String repoName, String systemWs) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        Element root = null;
        int count = 0;
        PrintWriter outputStream = null;
        try {
            doc = builder.build(fileDmsCommon);
        }
        catch (FileNotFoundException e) {
            StringBuilder builderString = new StringBuilder();
            builderString.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            builderString.append("<configuration>\n");
            builderString.append("  <component>\n");
            builderString.append("    <key>org.exoplatform.services.cms.impl.DMSConfiguration</key>\n");
            builderString.append("    <type>org.exoplatform.services.cms.impl.DMSConfiguration</type>\n");
            builderString.append("  </component>\n");
            builderString.append("</configuration>\n");
            FileWriter outputFileReader = new FileWriter(fileDmsCommon);
            outputStream = new PrintWriter(outputFileReader);
            outputStream.println(builderString);
            outputStream.close();
            doc = builder.build(fileDmsCommon);
        }
        root = doc.getRootElement();
        count = root.getChildren("external-component-plugins").size();
        Element externalElement = new Element("external-component-plugins");
        Element targetComponent = new Element("target-component");
        targetComponent.addContent("org.exoplatform.services.cms.impl.DMSConfiguration");
        Element componentPlugin = new Element("component-plugin");
        Element name = new Element(FIELD_NAME);
        name.addContent("dmsconfiguration.plugin" + count);
        Element setMethod = new Element("set-method");
        setMethod.addContent("addPlugin");
        Element type = new Element("type");
        type.addContent("org.exoplatform.services.cms.impl.DMSRepositoryConfiguration");
        Element initParams = new Element("init-params");
        Element valueParam1 = new Element("value-param");
        Element nameRepoParam = new Element(FIELD_NAME);
        nameRepoParam.addContent("repository");
        Element valueRepoParam = new Element("value");
        valueRepoParam.addContent(repoName);
        valueParam1.addContent((Content)nameRepoParam);
        valueParam1.addContent((Content)valueRepoParam);
        Element valueParam2 = new Element("value-param");
        Element nameWsParam = new Element(FIELD_NAME);
        nameWsParam.addContent("systemWorkspace");
        Element valueWsParam = new Element("value");
        valueWsParam.addContent(systemWs);
        valueParam2.addContent((Content)nameWsParam);
        valueParam2.addContent((Content)valueWsParam);
        initParams.addContent((Content)valueParam1);
        initParams.addContent((Content)valueParam2);
        componentPlugin.addContent((Content)name);
        componentPlugin.addContent((Content)setMethod);
        componentPlugin.addContent((Content)type);
        componentPlugin.addContent((Content)initParams);
        externalElement.addContent((Content)targetComponent);
        externalElement.addContent((Content)componentPlugin);
        root.addContent((Content)externalElement);
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(doc, (Writer)new FileWriter(fileDmsCommon));
    }

    private void addNewElement(String repoName, String wsName) throws Exception {
        J2EEServerInfo jServerInfo = new J2EEServerInfo();
        String configDir = jServerInfo.getExoConfigurationDirectory();
        String commonExtPath = configDir + "/dms-common-extend-configuration.xml";
        File configDirFile = new File(configDir);
        if (!configDirFile.exists()) {
            configDirFile.mkdir();
            File gadgets = new File(configDir + "/gadgets");
            gadgets.mkdir();
            new FileWriter(configDir + "/gadgets/key.txt");
        }
        this.addConfiguration(configDir + "/configuration.xml");
        this.addElement(commonExtPath, repoName, wsName);
    }

    public void setAuthentication(String value) {
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveWorkspaceActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiWizardPopup = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            uiWizardPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardPopup);
            String workspaceName = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (!uiForm.isAddnew_) {
                if (uiForm.isDefaultWorkspace(workspaceName)) {
                    Object[] args = new Object[]{workspaceName};
                    uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.cannot-delete-default-workspace", args, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                RepositoryService rService = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
                ManageableRepository manaRepo = rService.getRepository(uiForm.repoName_);
                if (manaRepo.canRemoveWorkspace(workspaceName)) {
                    manaRepo.removeWorkspace(workspaceName);
                    InitialContextInitializer ic = (InitialContextInitializer)((ExoContainer)uiForm.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(InitialContextInitializer.class);
                    if (ic != null) {
                        ic.recall();
                    }
                    if (rService.getConfig().isRetainable()) {
                        rService.getConfig().retain();
                    }
                    uiForm.workspaceMap_.clear();
                    for (WorkspaceEntry ws : manaRepo.getConfiguration().getWorkspaceEntries()) {
                        uiForm.workspaceMap_.put(ws.getName(), ws);
                    }
                    uiForm.refreshWorkspaceList();
                } else {
                    Object[] args = new Object[]{workspaceName};
                    uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.cannot-delete-workspace", args, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                }
            } else {
                uiForm.workspaceMap_.remove(workspaceName);
                uiForm.getWorkspaceMapPermission().remove(workspaceName);
                if (uiForm.isDefaultWorkspace(workspaceName)) {
                    uiForm.defaulWorkspace_ = null;
                }
                if (uiForm.isDmsSystemWorkspace(workspaceName)) {
                    uiForm.dmsSystemWorkspace_ = null;
                }
                uiForm.refreshWorkspaceList();
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIRepositoryFormContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditWorkspaceActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            String workspaceName = event.getRequestContext().getRequestParameter("objectId");
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiPopupAction = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            uiPopupAction.deActivate();
            UIWorkspaceWizardContainer uiWsContainer = (UIWorkspaceWizardContainer)uiPopupAction.activate(UIWorkspaceWizardContainer.class, 600);
            uiWsContainer.initWizard(uiForm.isAddnew_, false, uiForm.getWorkspace(workspaceName), false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupContainer.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiWizardPopup = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            uiWizardPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardPopup);
            uiForm.refresh(null);
            UIPopupContainer uiPopupAction = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddWorkspaceActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            String repoName = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_NAME).getValue();
            String sessionTime = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_SESSIONTIME).getValue();
            RepositoryService rService = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            for (RepositoryEntry repo : rService.getConfig().getRepositoryConfigurations()) {
                if (!repo.getName().equals(repoName) || !uiForm.isAddnew_) continue;
                Object[] args = new Object[]{repo.getName()};
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.repoName-exist", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!Utils.isNameValid((String)repoName, (String[])Utils.SPECIALCHARACTER)) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.repoName-not-alow", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (Utils.isNameEmpty((String)sessionTime)) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.sessionTime-required", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                Long.parseLong(sessionTime.trim());
            }
            catch (NumberFormatException nfe) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.sessionTime-invalid", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiPopupAction = (UIPopupContainer)((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).findFirstComponentOfType(UIPopupContainer.class);
            UIPopupContainer uiWorkspaceAction = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            UIWorkspaceWizardContainer uiWsContainer = (UIWorkspaceWizardContainer)uiWorkspaceAction.activate(UIWorkspaceWizardContainer.class, 700);
            WorkspaceEntry wsdf = null;
            RepositoryEntry repoEntry = rService.getDefaultRepository().getConfiguration();
            for (WorkspaceEntry ws : repoEntry.getWorkspaceEntries()) {
                if (!ws.getName().equals(repoEntry.getDefaultWorkspaceName())) continue;
                wsdf = ws;
                break;
            }
            uiWsContainer.initWizard(uiForm.isAddnew_, true, wsdf, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiWizardPopup = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            uiWizardPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardPopup);
            RepositoryService rService = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
            if (uiForm.isAddnew_) {
                uiForm.refresh(rService.getDefaultRepository().getConfiguration());
            } else {
                uiForm.refresh(rService.getRepository(uiForm.repoName_).getConfiguration());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            UIRepositoryFormContainer uiControl = (UIRepositoryFormContainer)uiForm.getAncestorOfType(UIRepositoryFormContainer.class);
            UIPopupContainer uiWizardPopup = (UIPopupContainer)uiControl.getChild(UIPopupContainer.class);
            uiWizardPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardPopup);
            RepositoryEntry re = new RepositoryEntry();
            String repoName = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_NAME).getValue();
            RepositoryService rService = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            for (RepositoryEntry repo : rService.getConfig().getRepositoryConfigurations()) {
                if (!repo.getName().equals(repoName) || !uiForm.isAddnew_) continue;
                Object[] args = new Object[]{repo.getName()};
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.repoName-exist", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!Utils.isNameValid((String)repoName, (String[])Utils.SPECIALCHARACTER)) {
                Object[] args = new Object[]{repoName};
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.repoName-not-alow", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiForm.getWorkspaceMap().isEmpty()) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.workspace-isrequire", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiForm.defaulWorkspace_ == null) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.workspace-setdefault", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiForm.dmsSystemWorkspace_ == null) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.workspace-setDMSsystem", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String acess = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_ACCESSCONTROL).getValue();
            UIFormInputSetWithAction autField = (UIFormInputSetWithAction)uiForm.getChildById(UIRepositoryForm.FIELD_AUTHINPUTSET);
            String authen = (String)autField.getUIStringInput(UIRepositoryForm.FIELD_AUTHENTICATION).getValue();
            if (Utils.isNameEmpty((String)authen)) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.authen-isrequire", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String security = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_SCURITY).getValue();
            String sessionTimeOut = (String)uiForm.getUIStringInput(UIRepositoryForm.FIELD_SESSIONTIME).getValue();
            if (Utils.isNameEmpty((String)sessionTimeOut)) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.sessionTime-required", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                Long.parseLong(sessionTimeOut);
            }
            catch (NumberFormatException nfe) {
                uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.sessionTime-invalid", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            re.setName(repoName);
            re.setAccessControl(acess);
            re.setAuthenticationPolicy(authen);
            re.setSecurityDomain(security);
            re.setSessionTimeOut(Long.parseLong(sessionTimeOut));
            re.setDefaultWorkspaceName(uiForm.defaulWorkspace_);
            re.setSystemWorkspaceName(uiForm.defaulWorkspace_);
            re.addWorkspace(uiForm.getWorkspace(uiForm.defaulWorkspace_));
            DMSRepositoryConfiguration newDConfiguration = new DMSRepositoryConfiguration();
            newDConfiguration.setRepositoryName(repoName);
            newDConfiguration.setSystemWorkspace(uiForm.dmsSystemWorkspace_);
            DMSConfiguration dmsConfiguration = (DMSConfiguration)uiForm.getApplicationComponent(DMSConfiguration.class);
            dmsConfiguration.initNewRepo(repoName, newDConfiguration);
            uiForm.addNewElement(repoName, uiForm.dmsSystemWorkspace_);
            uiForm.saveRepo(re);
            for (String workSpaceName : uiForm.workspaceMapPermission_.keySet()) {
                String[] items;
                ManageableRepository manageRepository = rService.getRepository(repoName);
                Session systemSession = manageRepository.getSystemSession(workSpaceName);
                String stringPermission = uiForm.workspaceMapPermission_.get(workSpaceName);
                ExtendedNode rootNode = (ExtendedNode)systemSession.getRootNode();
                HashMap<String, List<String>> permission = new HashMap<String, List<String>>();
                for (String item : items = stringPermission.split(";")) {
                    List<String> type;
                    String[] permissionType = item.split(" ");
                    if (permission.containsKey(permissionType[0])) {
                        type = (List)permission.get(permissionType[0]);
                        if (type.contains(permissionType[1])) continue;
                        type.add(permissionType[1]);
                        permission.put(permissionType[0], type);
                        continue;
                    }
                    type = new ArrayList<String>();
                    type.add(permissionType[1]);
                    permission.put(permissionType[0], type);
                }
                Iterator iter = permission.keySet().iterator();
                ArrayList<String> listKey = new ArrayList<String>();
                ArrayList<String> listType = new ArrayList<String>();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    listKey.add(key);
                    List types = (List)permission.get(key);
                    ArrayList<String> listPermission = new ArrayList<String>();
                    if (key.equals("*")) {
                        key = "any";
                    }
                    for (String type : types) {
                        if (key.equals("any") && !listType.contains(type)) {
                            listType.add(type);
                        }
                        if (type.equals("read")) {
                            listPermission.add("read");
                            continue;
                        }
                        if (type.equals("add_node")) {
                            listPermission.add("add_node");
                            continue;
                        }
                        if (type.equals("set_property")) {
                            listPermission.add("set_property");
                            continue;
                        }
                        listPermission.add("remove");
                    }
                    String[] criteria = new String[listPermission.size()];
                    rootNode.setPermission(key, listPermission.toArray(criteria));
                }
                if (!listKey.contains("any")) {
                    if (!listType.contains("add_node")) {
                        rootNode.removePermission("any", "add_node");
                    }
                    if (!listType.contains("set_property")) {
                        rootNode.removePermission("any", "set_property");
                    }
                    if (!listType.contains("remove")) {
                        rootNode.removePermission("any", "remove");
                    }
                }
                try {
                    rootNode.save();
                }
                catch (NullPointerException nullPointerException) {
                    uiApp.addMessage(new ApplicationMessage("UIRepositoryForm.msg.not-complete-repository", null, 1));
                    uiWizardPopup.deActivate();
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardPopup);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                    return;
                }
                systemSession.save();
                systemSession.logout();
            }
            UIRepositoryControl uiRepoControl = (UIRepositoryControl)((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).findFirstComponentOfType(UIRepositoryControl.class);
            uiRepoControl.reloadValue(true, rService);
            UIPopupContainer uiPopupAction = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            uiPopupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRepoControl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowHiddenActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryForm uiForm = (UIRepositoryForm)((Object)event.getSource());
            uiForm.ShowHidden();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIRepositoryForm> {
        public void execute(Event<UIRepositoryForm> event) throws Exception {
            UIRepositoryFormContainer uiRepoContainer = (UIRepositoryFormContainer)((UIRepositoryForm)((Object)event.getSource())).getAncestorOfType(UIRepositoryFormContainer.class);
            UIRepositoryValueSelect uiSelect = (UIRepositoryValueSelect)((UIPopupContainer)uiRepoContainer.getChild(UIPopupContainer.class)).activate(UIRepositoryValueSelect.class, 500);
            uiSelect.isSetAuthentication_ = true;
            ArrayList<UIRepositoryValueSelect.ClassData> datas = new ArrayList<UIRepositoryValueSelect.ClassData>();
            datas.add(new UIRepositoryValueSelect.ClassData(UIRepositoryForm.KEY_AUTHENTICATIONPOLICY));
            uiSelect.updateGrid(datas);
        }
    }
}

