/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ProcessInstanceCreateLog;
import org.jbpm.graph.log.ProcessInstanceEndLog;
import org.jbpm.job.CleanUpProcessJob;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.util.Clock;

public class ProcessInstance
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String key;
    protected Date start;
    protected Date end;
    protected ProcessDefinition processDefinition;
    protected Token rootToken;
    protected Token superProcessToken;
    protected boolean isSuspended;
    protected Map instances;
    protected Map transientInstances;
    protected List runtimeActions;
    protected List cascadeProcessInstances;

    public ProcessInstance() {
    }

    public ProcessInstance(ProcessDefinition processDefinition) {
        this(processDefinition, null, null);
    }

    public ProcessInstance(ProcessDefinition processDefinition, Map variables) {
        this(processDefinition, variables, null);
    }

    public ProcessInstance(ProcessDefinition processDefinition, Map variables, String key) {
        if (processDefinition == null) {
            throw new JbpmException("can't create a process instance when processDefinition is null");
        }
        this.processDefinition = processDefinition;
        this.rootToken = new Token(this);
        this.key = key;
        Services.assignId(this);
        this.addInitialModuleDefinitions(processDefinition);
        this.rootToken.addLog(new ProcessInstanceCreateLog());
        this.addInitialContextVariables(variables);
        Node initialNode = this.rootToken.getNode();
        this.fireStartEvent(initialNode);
    }

    public void addInitialContextVariables(Map variables) {
        ContextInstance contextInstance = this.getContextInstance();
        if (contextInstance != null && variables != null) {
            contextInstance.addVariables(variables);
        }
    }

    public void addInitialModuleDefinitions(ProcessDefinition processDefinition) {
        Map definitions = processDefinition.getDefinitions();
        if (definitions != null) {
            this.instances = new HashMap();
            Iterator i = definitions.values().iterator();
            while (i.hasNext()) {
                ModuleDefinition definition = (ModuleDefinition)i.next();
                ModuleInstance instance = definition.createInstance();
                if (instance == null) continue;
                this.addInstance(instance);
            }
        }
    }

    public void fireStartEvent(Node initialNode) {
        this.start = Clock.getCurrentTime();
        if (initialNode != null) {
            ExecutionContext executionContext = new ExecutionContext(this.rootToken);
            this.processDefinition.fireEvent("process-start", executionContext);
            initialNode.execute(executionContext);
        }
    }

    public ModuleInstance addInstance(ModuleInstance moduleInstance) {
        if (moduleInstance == null) {
            throw new IllegalArgumentException("can't add a null moduleInstance to a process instance");
        }
        if (this.instances == null) {
            this.instances = new HashMap();
        }
        this.instances.put(moduleInstance.getClass().getName(), moduleInstance);
        moduleInstance.setProcessInstance(this);
        return moduleInstance;
    }

    public ModuleInstance removeInstance(ModuleInstance moduleInstance) {
        ModuleInstance removedModuleInstance = null;
        if (moduleInstance == null) {
            throw new IllegalArgumentException("can't remove a null moduleInstance from a process instance");
        }
        if (this.instances != null && (removedModuleInstance = (ModuleInstance)this.instances.remove(moduleInstance.getClass().getName())) != null) {
            moduleInstance.setProcessInstance(null);
        }
        return removedModuleInstance;
    }

    public ModuleInstance getInstance(Class clazz) {
        ModuleInstance moduleInstance = null;
        if (this.instances != null) {
            moduleInstance = (ModuleInstance)this.instances.get(clazz.getName());
        }
        if (moduleInstance == null) {
            if (this.transientInstances == null) {
                this.transientInstances = new HashMap();
            }
            if ((moduleInstance = (ModuleInstance)this.transientInstances.get(clazz.getName())) == null) {
                try {
                    moduleInstance = (ModuleInstance)clazz.newInstance();
                    moduleInstance.setProcessInstance(this);
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't instantiate transient module '" + clazz.getName() + "' with the default constructor");
                }
                this.transientInstances.put(clazz.getName(), moduleInstance);
            }
        }
        return moduleInstance;
    }

    public ContextInstance getContextInstance() {
        return (ContextInstance)this.getInstance(ContextInstance.class);
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return (TaskMgmtInstance)this.getInstance(TaskMgmtInstance.class);
    }

    public LoggingInstance getLoggingInstance() {
        return (LoggingInstance)this.getInstance(LoggingInstance.class);
    }

    public void signal() {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal();
    }

    public void signal(String transitionName) {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal(transitionName);
    }

    public void signal(Transition transition) {
        if (this.hasEnded()) {
            throw new IllegalStateException("couldn't signal token : token has ended");
        }
        this.rootToken.signal(transition);
    }

    public void end() {
        this.rootToken.end();
        if (this.end == null) {
            JbpmContext jbpmContext;
            this.end = Clock.getCurrentTime();
            ExecutionContext executionContext = new ExecutionContext(this.rootToken);
            this.processDefinition.fireEvent("process-end", executionContext);
            this.rootToken.addLog(new ProcessInstanceEndLog());
            if (this.superProcessToken != null && !this.superProcessToken.hasEnded()) {
                this.addCascadeProcessInstance(this.superProcessToken.getProcessInstance());
                ExecutionContext superExecutionContext = new ExecutionContext(this.superProcessToken);
                superExecutionContext.setSubProcessInstance(this);
                this.superProcessToken.signal(superExecutionContext);
            }
            if ((jbpmContext = JbpmContext.getCurrentJbpmContext()) != null) {
                Services services = jbpmContext.getServices();
                MessageService messageService = services.getMessageService();
                PersistenceService persistenceService = services.getPersistenceService();
                if (messageService != null && persistenceService != null && persistenceService.getJobSession().countDeletableJobsForProcessInstance(this) > 0) {
                    CleanUpProcessJob job = new CleanUpProcessJob(this.rootToken);
                    job.setDueDate(new Date());
                    messageService.send(job);
                }
            }
        }
    }

    public void suspend() {
        this.isSuspended = true;
        this.rootToken.suspend();
    }

    public void resume() {
        this.isSuspended = false;
        this.rootToken.resume();
    }

    public RuntimeAction addRuntimeAction(RuntimeAction runtimeAction) {
        if (runtimeAction == null) {
            throw new IllegalArgumentException("can't add a null runtimeAction to a process instance");
        }
        if (this.runtimeActions == null) {
            this.runtimeActions = new ArrayList();
        }
        this.runtimeActions.add(runtimeAction);
        runtimeAction.processInstance = this;
        return runtimeAction;
    }

    public RuntimeAction removeRuntimeAction(RuntimeAction runtimeAction) {
        RuntimeAction removedRuntimeAction = null;
        if (runtimeAction == null) {
            throw new IllegalArgumentException("can't remove a null runtimeAction from an process instance");
        }
        if (this.runtimeActions != null && this.runtimeActions.remove(runtimeAction)) {
            removedRuntimeAction = runtimeAction;
            runtimeAction.processInstance = null;
        }
        return removedRuntimeAction;
    }

    public List getRuntimeActions() {
        return this.runtimeActions;
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public boolean isTerminatedImplicitly() {
        boolean isTerminatedImplicitly = true;
        if (this.end == null) {
            isTerminatedImplicitly = this.rootToken.isTerminatedImplicitly();
        }
        return isTerminatedImplicitly;
    }

    public Token findToken(String tokenPath) {
        return this.rootToken != null ? this.rootToken.findToken(tokenPath) : null;
    }

    public List findAllTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.add(this.rootToken);
        this.rootToken.collectChildrenRecursively(tokens);
        return tokens;
    }

    void addCascadeProcessInstance(ProcessInstance cascadeProcessInstance) {
        if (this.cascadeProcessInstances == null) {
            this.cascadeProcessInstances = new ArrayList();
        }
        this.cascadeProcessInstances.add(cascadeProcessInstance);
    }

    public Collection removeCascadeProcessInstances() {
        List removed = this.cascadeProcessInstances;
        this.cascadeProcessInstances = null;
        return removed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessInstance)) {
            return false;
        }
        ProcessInstance other = (ProcessInstance)o;
        return this.id != 0L ? this.id == other.getId() : (this.key != null ? this.key.equals(other.getKey()) : other.getKey() == null) && this.processDefinition.equals(other.getProcessDefinition());
    }

    public int hashCode() {
        if (this.id != 0L) {
            return (int)(this.id ^ this.id >>> 32);
        }
        int result = 295436291 + (this.key != null ? this.key.hashCode() : 0);
        result = 1367411281 * result + this.processDefinition.hashCode();
        return result;
    }

    public String toString() {
        return "ProcessInstance" + (this.key != null ? '(' + this.key + ')' : (this.id != 0L ? "(" + this.id + ')' : '@' + Integer.toHexString(this.hashCode())));
    }

    public long getId() {
        return this.id;
    }

    public Token getRootToken() {
        return this.rootToken;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public Map getInstances() {
        return this.instances;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public Token getSuperProcessToken() {
        return this.superProcessToken;
    }

    public void setSuperProcessToken(Token superProcessToken) {
        this.superProcessToken = superProcessToken;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public void setRootToken(Token rootToken) {
        this.rootToken = rootToken;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

