/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.mimetype;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.exoplatform.commons.utils.MimeTypeResolver;

public class DMSMimeTypeResolver {
    private Properties dmsmimeTypes = new Properties();
    private static MimeTypeResolver mimeTypes = new MimeTypeResolver();
    private static DMSMimeTypeResolver dmsMimeTypeResolver;

    private DMSMimeTypeResolver() throws IOException {
        this.dmsmimeTypes.load(this.getClass().getResourceAsStream("/conf/mimetype/mimetypes.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DMSMimeTypeResolver getInstance() throws IOException {
        if (dmsMimeTypeResolver != null) return dmsMimeTypeResolver;
        Class<DMSMimeTypeResolver> clazz = DMSMimeTypeResolver.class;
        synchronized (DMSMimeTypeResolver.class) {
            if (dmsMimeTypeResolver != null) return dmsMimeTypeResolver;
            dmsMimeTypeResolver = new DMSMimeTypeResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dmsMimeTypeResolver;
        }
    }

    public String getMimeType(String filename) {
        String mimeType;
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.equals("")) {
            ext = filename;
        }
        if ((mimeType = this.dmsmimeTypes.getProperty(ext.toLowerCase(), mimeTypes.getDefaultMimeType())) == null || mimeType.length() == 0) {
            return mimeTypes.getMimeType(filename);
        }
        return mimeType;
    }

    public String getExtension(String mimeType) {
        if (mimeType.equals("") || mimeType.equals(mimeTypes.getDefaultMimeType())) {
            return "";
        }
        Iterator<Object> iterator = this.dmsmimeTypes.keySet().iterator();
        String ext = "";
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)this.dmsmimeTypes.get(key);
            if (value.equals(mimeType) && mimeType.endsWith(key)) {
                return key;
            }
            if (value.equals(mimeType) && ext.equals("")) {
                ext = new String(key);
                continue;
            }
            if (!value.equals(mimeType) || ext.equals("")) continue;
            return ext;
        }
        return ext;
    }
}

