/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.metadata.web;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.metadata.PageMetadataService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageMetadataRequestFilter
implements Filter {
    private Log log = ExoLogger.getLogger(this.getClass());
    public static final String PCV_PARAMETER_REGX = "(.*)/(.*)/(.*)";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        try {
            boolean check = this.checkAndSetMetadataIfRequestToPCVPortlet(req);
            if (!check) {
                this.setPortalMetadata(req);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error when doFilter: ", (Throwable)e);
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private void setPortalMetadata(HttpServletRequest req) throws Exception {
        SessionProvider sessionProvider;
        String pathInfo = req.getPathInfo();
        PageMetadataService metadataRegistry = this.getService(PageMetadataService.class);
        HashMap<String, String> metadata = metadataRegistry.getPortalMetadata(sessionProvider = WCMCoreUtils.getSystemSessionProvider(), pathInfo);
        if (metadata != null) {
            req.setAttribute(PortalRequestContext.REQUEST_METADATA, metadata);
        }
    }

    private boolean checkAndSetMetadataIfRequestToPCVPortlet(HttpServletRequest req) throws Exception {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        WCMConfigurationService configurationService = this.getService(WCMConfigurationService.class);
        String parameterizedPageURI = configurationService.getRuntimeContextParam("parameterizedPageURI");
        String printPreviewPageURI = configurationService.getRuntimeContextParam("printViewerPage");
        int index = pathInfo.indexOf(parameterizedPageURI);
        String parameter = null;
        if (index < 1 && printPreviewPageURI != null) {
            index = pathInfo.indexOf(printPreviewPageURI);
            if (index < 1) {
                return false;
            }
            parameter = pathInfo.substring(index + printPreviewPageURI.length() + 1);
        } else {
            parameter = pathInfo.substring(index + parameterizedPageURI.length() + 1);
        }
        if (parameter == null) {
            return false;
        }
        if (!parameter.matches(PCV_PARAMETER_REGX)) {
            return false;
        }
        int firstSlash = parameter.indexOf("/");
        int secondSlash = parameter.indexOf("/", firstSlash + 1);
        String workspace = parameter.substring(firstSlash + 1, secondSlash);
        String nodeIdentifier = parameter.substring(secondSlash + 1);
        RepositoryService repositoryService = this.getService(RepositoryService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node node = null;
        try {
            Session session = sessionProvider.getSession(workspace, repositoryService.getCurrentRepository());
            node = nodeIdentifier.indexOf("/") < 0 ? session.getNodeByUUID(nodeIdentifier) : (Node)session.getItem("/" + nodeIdentifier);
        }
        catch (ItemNotFoundException e) {
        }
        catch (PathNotFoundException e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)new ItemNotFoundException());
        }
        catch (AccessControlException e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)e);
        }
        catch (Exception e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)new ItemNotFoundException());
        }
        if (node != null) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", node);
            PageMetadataService pageMetadataService = this.getService(PageMetadataService.class);
            HashMap<String, String> pageMetadata = pageMetadataService.extractMetadata(node);
            String title = (String)pageMetadata.get("pageTitle");
            if (title != null) {
                req.setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)title);
            }
            req.setAttribute(PortalRequestContext.REQUEST_METADATA, pageMetadata);
            if (node.hasProperty("exo:title")) {
                req.setAttribute("WCM.Content.Title", (Object)node.getProperty("exo:title").getValue().getString());
            }
            req.setAttribute("WCM.Content.Title", (Object)node.getName());
            return true;
        }
        return false;
    }

    private <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public void destroy() {
    }
}

