/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CQJDBCStorageConnection
extends JDBCStorageConnection {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CQJDBCStorageConnection");
    protected String FIND_NODES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE;
    protected String FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE;
    protected String FIND_ITEM_QPATH_BY_ID_CQ;
    protected String FIND_PROPERTY_BY_ID;
    protected String DELETE_VALUE_BY_ORDER_NUM;
    protected String UPDATE_VALUE;
    protected PreparedStatement findNodesByParentIdCQ;
    protected PreparedStatement findPropertiesByParentIdCQ;
    protected PreparedStatement findNodeMainPropertiesByParentIdentifierCQ;
    protected PreparedStatement findItemQPathByIdentifierCQ;
    protected PreparedStatement findPropertyById;
    protected PreparedStatement deleteValueDataByOrderNum;
    protected PreparedStatement updateValue;
    protected Statement findPropertiesByParentIdAndComplexPatternCQ;
    protected Statement findNodesByParentIdAndComplexPatternCQ;

    protected CQJDBCStorageConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<NodeData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                PersistedNodeData nodeData;
                resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                JDBCStorageConnection.TempNodeData data = null;
                ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
                while (resultSet.next()) {
                    if (data == null) {
                        data = new JDBCStorageConnection.TempNodeData(this, resultSet);
                    } else if (!resultSet.getString("ID").equals(data.cid)) {
                        nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                        childNodes.add(nodeData);
                        data = new JDBCStorageConnection.TempNodeData(this, resultSet);
                    }
                    Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = data.properties;
                    String key = resultSet.getString("PROP_NAME");
                    SortedSet<JDBCStorageConnection.TempPropertyData> values = properties.get(key);
                    if (values == null) {
                        values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                        properties.put(key, values);
                    }
                    values.add(new JDBCStorageConnection.TempPropertyData(this, resultSet));
                }
                if (data != null) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                }
                arrayList = childNodes;
                Object var9_10 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        ArrayList<NodeData> arrayList;
        this.checkIfOpened();
        if (pattern.isEmpty()) {
            return new ArrayList<NodeData>();
        }
        ResultSet resultSet = null;
        try {
            try {
                PersistedNodeData nodeData;
                resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()), pattern);
                JDBCStorageConnection.TempNodeData data = null;
                ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
                while (resultSet.next()) {
                    if (data == null) {
                        data = new JDBCStorageConnection.TempNodeData(this, resultSet);
                    } else if (!resultSet.getString("ID").equals(data.cid)) {
                        nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                        childNodes.add(nodeData);
                        data = new JDBCStorageConnection.TempNodeData(this, resultSet);
                    }
                    Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = data.properties;
                    String key = resultSet.getString("PROP_NAME");
                    SortedSet<JDBCStorageConnection.TempPropertyData> values = properties.get(key);
                    if (values == null) {
                        values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                        properties.put(key, values);
                    }
                    values.add(new JDBCStorageConnection.TempPropertyData(this, resultSet));
                }
                if (data != null) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                }
                arrayList = childNodes;
                Object var10_11 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        ResultSet rs = null;
        String cid = this.getInternalId(data.getIdentifier());
        rs = this.findPropertyById(cid);
        HashSet<String> storageDescs = new HashSet<String>();
        int totalOldValues = 0;
        int prevType = -1;
        while (rs.next()) {
            if (prevType == -1) {
                prevType = rs.getInt("P_TYPE");
            }
            ++totalOldValues;
            String storageId = rs.getString("STORAGE_DESC");
            if (rs.wasNull()) continue;
            storageDescs.add(storageId);
        }
        if (this.updatePropertyByIdentifier(data.getPersistedVersion(), data.getType(), cid) <= 0) {
            throw new JCRInvalidItemStateException("(update) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
        }
        try {
            if (prevType == 9) {
                this.deleteReference(cid);
            }
            if (data.getType() == 9) {
                this.addReference(data);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Can't update REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
        }
        this.deleteValues(cid, data, storageDescs, totalOldValues);
        this.addOrUpdateValues(cid, data, totalOldValues);
        Object var9_11 = null;
        if (rs == null) return;
        try {
            rs.close();
            return;
        }
        catch (SQLException e2) {
            LOG.error((Object)("Can't close the ResultSet: " + e2));
        }
        return;
        {
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) throw new RepositoryException("Error of Property Value update " + e, (Throwable)e);
                LOG.error((Object)("Property update. IO error: " + e), (Throwable)e);
                throw new RepositoryException("Error of Property Value update " + e, (Throwable)e);
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Property update. Database error: " + e), (Throwable)e);
                }
                this.exceptionHandler.handleUpdateException(e, data);
                Object var9_12 = null;
                if (rs == null) return;
                try {
                    rs.close();
                    return;
                }
                catch (SQLException e2) {
                    LOG.error((Object)("Can't close the ResultSet: " + e2));
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.error((Object)("Can't close the ResultSet: " + e2));
            }
            throw throwable;
        }
    }

    @Override
    protected void addValues(String cid, PropertyData data) throws IOException, SQLException, RepositoryException {
        this.addOrUpdateValues(cid, data, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrUpdateValues(String cid, PropertyData data, int totalOldValues) throws IOException, RepositoryException, SQLException {
        List<ValueData> vdata = data.getValues();
        for (int i = 0; i < vdata.size(); ++i) {
            String storageId;
            int streamLength;
            InputStream stream;
            ValueData vd = vdata.get(i);
            ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel(data, i);
            if (channel == null) {
                if (vd.isByteArray()) {
                    byte[] dataBytes = vd.getAsByteArray();
                    stream = new ByteArrayInputStream(dataBytes);
                    streamLength = dataBytes.length;
                } else {
                    Object var14_15;
                    StreamPersistedValueData streamData = (StreamPersistedValueData)vd;
                    SwapFile swapFile = SwapFile.get(this.swapDirectory, cid + i + "." + data.getPersistedVersion());
                    try {
                        this.writeValueHelper.writeStreamedValue(swapFile, streamData);
                        var14_15 = null;
                        swapFile.spoolDone();
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        swapFile.spoolDone();
                        throw throwable;
                    }
                    long vlen = swapFile.length();
                    if (vlen > Integer.MAX_VALUE) {
                        throw new RepositoryException("Value data large of allowed by JDBC (Integer.MAX_VALUE) " + vlen + ". Property " + data.getQPath().getAsString());
                    }
                    streamLength = (int)vlen;
                    stream = streamData.getAsStream();
                }
                storageId = null;
            } else {
                channel.write(data.getIdentifier(), vd);
                this.valueChanges.add(channel);
                storageId = channel.getStorageId();
                stream = null;
                streamLength = 0;
            }
            if (i < totalOldValues) {
                this.updateValueData(cid, i, stream, streamLength, storageId);
                continue;
            }
            this.addValueData(cid, i, stream, streamLength, storageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(String cid, PropertyData pdata, Set<String> storageDescs, int totalOldValues) throws ValueStorageNotFoundException, IOException, SQLException {
        for (String storageId : storageDescs) {
            Object var9_8;
            ValueIOChannel channel = this.valueStorageProvider.getChannel(storageId);
            try {
                channel.delete(pdata.getIdentifier());
                this.valueChanges.add(channel);
                var9_8 = null;
                channel.close();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                channel.close();
                throw throwable;
            }
        }
        if (pdata.getValues().size() < totalOldValues) {
            this.deleteValueDataByOrderNum(cid, pdata.getValues().size());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                QPath parentPath = parent.getQPath();
                if (resultSet.next()) {
                    boolean isNotLast = true;
                    do {
                        QPath qpath;
                        String cid = resultSet.getString("ID");
                        String identifier = this.getIdentifier(cid);
                        String cname = resultSet.getString("NAME");
                        int cversion = resultSet.getInt("VERSION");
                        String cpid = resultSet.getString("PARENT_ID");
                        int cptype = resultSet.getInt("P_TYPE");
                        boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                        try {
                            qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                        }
                        catch (IllegalNameException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                        ArrayList<ValueData> data = new ArrayList<ValueData>();
                        do {
                            int orderNum = resultSet.getInt("ORDER_NUM");
                            if (resultSet.wasNull()) continue;
                            String storageId = resultSet.getString("STORAGE_DESC");
                            ValueData vdata = resultSet.wasNull() ? this.readValueData(cid, orderNum, cversion, resultSet.getBinaryStream("DATA")) : this.readValueData(identifier, orderNum, storageId);
                            data.add(vdata);
                        } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                        Collections.sort(data, COMPARATOR_VALUE_DATA);
                        PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, data);
                        children.add(pdata);
                    } while (isNotLast);
                }
                arrayList = children;
                Object var19_23 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var19_24 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        ArrayList<PropertyData> arrayList;
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            try {
                resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()), itemDataFilters);
                ArrayList<PropertyData> children = new ArrayList<PropertyData>();
                QPath parentPath = parent.getQPath();
                if (resultSet.next()) {
                    boolean isNotLast = true;
                    do {
                        QPath qpath;
                        String cid = resultSet.getString("ID");
                        String identifier = this.getIdentifier(cid);
                        String cname = resultSet.getString("NAME");
                        int cversion = resultSet.getInt("VERSION");
                        String cpid = resultSet.getString("PARENT_ID");
                        int cptype = resultSet.getInt("P_TYPE");
                        boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                        try {
                            qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                        }
                        catch (IllegalNameException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                        ArrayList<ValueData> data = new ArrayList<ValueData>();
                        do {
                            int orderNum = resultSet.getInt("ORDER_NUM");
                            if (resultSet.wasNull()) continue;
                            String storageId = resultSet.getString("STORAGE_DESC");
                            ValueData vdata = resultSet.wasNull() ? this.readValueData(cid, orderNum, cversion, resultSet.getBinaryStream("DATA")) : this.readValueData(identifier, orderNum, storageId);
                            data.add(vdata);
                        } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                        Collections.sort(data, COMPARATOR_VALUE_DATA);
                        PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, data);
                        children.add(pdata);
                    } while (isNotLast);
                }
                arrayList = children;
                Object var20_24 = null;
                if (resultSet == null) return arrayList;
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
            return arrayList;
        }
        resultSet.close();
        return arrayList;
    }

    protected List<AccessControlEntry> readACLPermisions(String cid, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties) throws SQLException, IllegalACLException, IOException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        Set permValues = properties.get(Constants.EXO_PERMISSIONS.getAsString());
        if (permValues != null) {
            for (JDBCStorageConnection.TempPropertyData value : permValues) {
                StringTokenizer parser = new StringTokenizer(new String(value.data), " ");
                naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
            }
            return naPermissions;
        }
        throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
    }

    protected String readACLOwner(String cid, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties) throws IllegalACLException, IOException {
        SortedSet<JDBCStorageConnection.TempPropertyData> ownerValues = properties.get(Constants.EXO_OWNER.getAsString());
        if (ownerValues != null) {
            return new String(ownerValues.first().data);
        }
        throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        PersistedNodeData persistedNodeData;
        ResultSet ptProp = this.findNodeMainPropertiesByParentIdentifierCQ(cid);
        try {
            try {
                HashMap<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = new HashMap<String, SortedSet<JDBCStorageConnection.TempPropertyData>>();
                while (ptProp.next()) {
                    String key = ptProp.getString("NAME");
                    TreeSet<JDBCStorageConnection.TempPropertyData> values = (TreeSet<JDBCStorageConnection.TempPropertyData>)properties.get(key);
                    if (values == null) {
                        values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                        properties.put(key, values);
                    }
                    values.add(new JDBCStorageConnection.TempPropertyData(this, ptProp));
                }
                persistedNodeData = this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, properties, parentACL);
                Object var14_14 = null;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                ptProp.close();
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.error((Object)("Can't close the ResultSet: " + e2));
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            LOG.error((Object)("Can't close the ResultSet: " + e2));
            return persistedNodeData;
        }
        ptProp.close();
        return persistedNodeData;
    }

    protected PersistedNodeData loadNodeFromTemporaryNodeData(JDBCStorageConnection.TempNodeData tempData, QPath parentPath, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        return this.loadNodeRecord(parentPath, tempData.cname, tempData.cid, tempData.cpid, tempData.cindex, tempData.cversion, tempData.cnordernumb, tempData.properties, parentACL);
    }

    private PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        try {
            InternalQName[] mts;
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex);
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex);
                parentCid = cpid;
            }
            SortedSet<JDBCStorageConnection.TempPropertyData> primaryType = properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
            if (primaryType == null || primaryType.isEmpty()) {
                throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + cid + ", container " + this.containerName, null);
            }
            byte[] data = primaryType.first().data;
            InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
            boolean owneable = false;
            boolean privilegeable = false;
            Set mixTypes = properties.get(Constants.JCR_MIXINTYPES.getAsString());
            if (mixTypes != null) {
                ArrayList<InternalQName> mNames = new ArrayList<InternalQName>();
                for (JDBCStorageConnection.TempPropertyData mxnb : mixTypes) {
                    InternalQName mxn = InternalQName.parse(new String(mxnb.data));
                    mNames.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                }
                mts = new InternalQName[mNames.size()];
                mNames.toArray(mts);
            } else {
                mts = new InternalQName[]{};
            }
            try {
                AccessControlList acl = owneable ? (privilegeable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid, properties), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid, properties), null))) : (privilegeable ? (owneable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid, properties)) : new AccessControlList(null, this.readACLPermisions(cid, properties)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                return new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mts, acl);
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        id = this.getIdentifier(cpid);
        if (id.equals("00exo0jcr0root0uuid0000000000000")) {
            return Constants.ROOT_PATH;
        }
        qrpath = new ArrayList<QPathEntry>();
        caid = cpid;
        isRoot = false;
        do {
            result = null;
            try {
                result = this.findItemQPathByIdentifierCQ(caid);
                if (!result.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                qpe1 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                isChild = caid.equals(result.getString("ID"));
                caid = result.getString("PARENT_ID");
                if (result.next()) {
                    qpe2 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"));
                    if (isChild) {
                        qrpath.add(qpe1);
                        qrpath.add(qpe2);
                        caid = result.getString("PARENT_ID");
                    } else {
                        qrpath.add(qpe2);
                        qrpath.add(qpe1);
                    }
                } else {
                    qrpath.add(qpe1);
                }
                var11_11 = null;
                ** if (result == null) goto lbl-1000
            }
            catch (Throwable var10_13) {
                var11_11 = null;
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        CQJDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                    }
                }
                throw var10_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    CQJDBCStorageConnection.LOG.error((Object)("Can't close the ResultSet: " + e));
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            if (!caid.equals(Constants.ROOT_PARENT_UUID) && !(id = this.getIdentifier(caid)).equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (id.equals("00exo0jcr0root0uuid0000000000000")) {
                qrpath.add(Constants.ROOT_PATH.getEntries()[0]);
            }
            isRoot = true;
        } while (!isRoot);
        qentries = new QPathEntry[qrpath.size()];
        qi = 0;
        for (i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    @Override
    protected void closeStatements() {
        super.closeStatements();
        try {
            if (this.findNodesByParentIdCQ != null) {
                this.findNodesByParentIdCQ.close();
            }
            if (this.findPropertiesByParentIdCQ != null) {
                this.findPropertiesByParentIdCQ.close();
            }
            if (this.findNodeMainPropertiesByParentIdentifierCQ != null) {
                this.findNodeMainPropertiesByParentIdentifierCQ.close();
            }
            if (this.findItemQPathByIdentifierCQ != null) {
                this.findItemQPathByIdentifierCQ.close();
            }
            if (this.findPropertyById != null) {
                this.findPropertyById.close();
            }
            if (this.deleteValueDataByOrderNum != null) {
                this.deleteValueDataByOrderNum.close();
            }
            if (this.updateValue != null) {
                this.updateValue.close();
            }
            if (this.findPropertiesByParentIdAndComplexPatternCQ != null) {
                this.findPropertiesByParentIdAndComplexPatternCQ.close();
            }
            if (this.findNodesByParentIdAndComplexPatternCQ != null) {
                this.findNodesByParentIdAndComplexPatternCQ.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement: " + e));
        }
    }

    protected abstract ResultSet findItemQPathByIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1, List<QPathEntryFilter> var2) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1, List<QPathEntryFilter> var2) throws SQLException;

    protected abstract ResultSet findNodeMainPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findPropertyById(String var1) throws SQLException;

    protected abstract int deleteValueDataByOrderNum(String var1, int var2) throws SQLException;

    protected abstract int updateValueData(String var1, int var2, InputStream var3, int var4, String var5) throws SQLException;
}

