/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jobs.symlink;

import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ClearOrphanSymlinksJob
implements Job {
    private static final Log log = ExoLogger.getLogger(ClearOrphanSymlinksJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.debug((Object)"Start Executing ClearOrphanSymlinksJob");
        String queryString = "SELECT * FROM exo:symlink order by exo:dateCreated DESC";
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        LinkManager linkManager = (LinkManager)exoContainer.getComponentInstanceOfType(LinkManager.class);
        TrashService trashService = (TrashService)exoContainer.getComponentInstanceOfType(TrashService.class);
        SessionProvider sessionProvider = null;
        Session session = null;
        try {
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            sessionProvider = SessionProvider.createSystemProvider();
            String[] workspaces = manageableRepository.getWorkspaceNames();
            HashSet<Session> sessionSet = new HashSet<Session>();
            for (String workspace : workspaces) {
                try {
                    session = sessionProvider.getSession(workspace, manageableRepository);
                    QueryManager queryManager = session.getWorkspace().getQueryManager();
                    Query query = queryManager.createQuery(queryString, "sql");
                    QueryResult queryResult = query.execute();
                    NodeIterator nodeIterator = queryResult.getNodes();
                    ArrayList<Node> deleteNodeList = new ArrayList<Node>();
                    while (nodeIterator.hasNext()) {
                        Node symlinkNode = nodeIterator.nextNode();
                        if (Utils.isInTrash(symlinkNode)) continue;
                        Node targetNode = null;
                        try {
                            targetNode = linkManager.getTarget(symlinkNode, true);
                            if (!Utils.isInTrash(targetNode)) continue;
                            deleteNodeList.add(symlinkNode);
                        }
                        catch (ItemNotFoundException e) {
                            deleteNodeList.add(symlinkNode);
                        }
                        catch (RepositoryException e) {}
                        continue;
                        finally {
                            sessionSet.add(targetNode.getSession());
                        }
                    }
                    for (Node node : deleteNodeList) {
                        try {
                            String nodePath = node.getPath();
                            trashService.moveToTrash(node, sessionProvider);
                            log.info((Object)("ClearOrphanSymlinksJob: move orphan symlink " + nodePath + " to Trash"));
                        }
                        catch (Exception e) {
                            log.error((Object)("ClearOrphanSymlinksJob: Can not move to trash node :" + node.getPath()), (Throwable)e);
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.error((Object)("ClearOrphanSymlinksJob: Error when deleting orphan symlinks in workspace: " + workspace), (Throwable)e);
                }
                finally {
                    if (session != null && session.isLive()) {
                        session.logout();
                    }
                }
            }
            for (Session targetSession : sessionSet) {
                if (targetSession == null || !targetSession.isLive()) continue;
                targetSession.logout();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurs in ClearOrphanSymlinksJob", (Throwable)e);
            sessionProvider.close();
        }
    }
}

