/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/taxonomy/UIFormWithoutAction.gtmpl", events={@EventConfig(listeners={ChangeActionTypeActionListener.class})})
public class UIActionTypeForm
extends UIForm {
    public static final String ACTION_TYPE = "actionType";
    public static final String CHANGE_ACTION = "ChangeActionType";
    private List<SelectItemOption<String>> typeList_;
    public String defaultActionType_;

    public UIActionTypeForm() throws Exception {
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(ACTION_TYPE, ACTION_TYPE, new ArrayList());
        uiSelectBox.setOnChange(CHANGE_ACTION);
        this.addUIFormInput((UIFormInput)uiSelectBox);
    }

    private Iterator getCreatedActionTypes() throws Exception {
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        return actionService.getCreatedActionTypes(repository).iterator();
    }

    public void setDefaultActionType(String actionType) throws Exception {
        this.defaultActionType_ = actionType;
        if (actionType == null) {
            this.defaultActionType_ = "exo:taxonomyAction";
        }
        ArrayList<SelectItemOption> actionTypeList = new ArrayList<SelectItemOption>();
        actionTypeList.add(new SelectItemOption(this.defaultActionType_, (Object)this.defaultActionType_));
        this.getUIFormSelectBox(ACTION_TYPE).setOptions(actionTypeList);
        this.getUIFormSelectBox(ACTION_TYPE).setValue(this.defaultActionType_);
    }

    public void update() throws Exception {
        Iterator actions = this.getCreatedActionTypes();
        if (actions != null && actions.hasNext()) {
            this.typeList_ = new ArrayList<SelectItemOption<String>>();
            while (actions.hasNext()) {
                String action = ((NodeType)actions.next()).getName();
                this.typeList_.add((SelectItemOption<String>)new SelectItemOption(action, (Object)action));
            }
            this.getUIFormSelectBox(ACTION_TYPE).setOptions(this.typeList_);
            this.setDefaultActionType(this.defaultActionType_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionTypeActionListener
    extends EventListener<UIActionTypeForm> {
        public void execute(Event<UIActionTypeForm> event) throws Exception {
            Object[] arg;
            UIActionTypeForm uiActionType = (UIActionTypeForm)((Object)event.getSource());
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiActionType.getAncestorOfType(UITaxonomyTreeContainer.class);
            String actionType = (String)uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).getValue();
            TemplateService templateService = (TemplateService)uiActionType.getApplicationComponent(TemplateService.class);
            UIActionTaxonomyManager uiActionTaxonomyManager = (UIActionTaxonomyManager)uiActionType.getAncestorOfType(UIActionTaxonomyManager.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)uiActionType.getAncestorOfType(UIApplication.class);
            UIActionForm uiActionForm = (UIActionForm)uiActionTaxonomyManager.getChild(UIActionForm.class);
            try {
                String templatePath = templateService.getTemplatePathByUser(true, actionType, userName);
                if (templatePath == null) {
                    arg = new Object[]{actionType};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.access-denied", arg, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    actionType = "exo:taxonomyAction";
                    uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).setValue(actionType);
                }
            }
            catch (PathNotFoundException path) {
                arg = new Object[]{actionType};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.not-support", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                actionType = "exo:taxonomyAction";
                uiActionType.getUIFormSelectBox(UIActionTypeForm.ACTION_TYPE).setValue(actionType);
            }
            TaxonomyTreeData taxoTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            TaxonomyService taxonomyService = (TaxonomyService)uiTaxonomyTreeContainer.getApplicationComponent(TaxonomyService.class);
            Node taxoTreeNode = null;
            try {
                taxoTreeNode = taxonomyService.getTaxonomyTree(taxoTreeData.getTaxoTreeName(), true);
            }
            catch (RepositoryException re) {
                // empty catch block
            }
            uiActionForm.createNewAction(taxoTreeNode, actionType, true);
            uiActionTaxonomyManager.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionTaxonomyManager);
        }
    }
}

