/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.util.ArrayUtil;

public class DeployProcessTask
extends MatchingTask {
    String jbpmCfg;
    File process;
    List fileSets = new ArrayList();
    boolean failOnError = true;

    public void execute() throws BuildException {
        JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration(this.jbpmCfg);
        if (this.process != null) {
            this.handleProcessFile(jbpmConfiguration, this.process);
        }
        Iterator iter = this.fileSets.iterator();
        while (iter.hasNext()) {
            FileSet fileSet = (FileSet)iter.next();
            DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
            File baseDir = dirScanner.getBasedir();
            String[] includedFiles = dirScanner.getIncludedFiles();
            Object[] excludedFiles = dirScanner.getExcludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String fileName = includedFiles[i];
                if (ArrayUtil.contains(excludedFiles, fileName)) continue;
                this.handleProcessFile(jbpmConfiguration, new File(baseDir, fileName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessFile(JbpmConfiguration jbpmConfiguration, File processFile) {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            this.log("parsing process archive " + processFile.getName());
            ProcessDefinition processDefinition = this.parseProcessArchive(processFile);
            this.deployProcessDefinition(processDefinition, jbpmContext);
        }
        catch (IOException e) {
            this.log("error reading process archive " + processFile.getName(), e, 0);
            if (this.failOnError) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessDefinition parseProcessArchive(File processFile) throws IOException {
        ZipInputStream processStream = new ZipInputStream(new FileInputStream(processFile));
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(processStream);
            this.log("parsed process definition " + processDefinition.getName());
            ProcessDefinition processDefinition2 = processDefinition;
            return processDefinition2;
        }
        finally {
            processStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition, JbpmContext jbpmContext) {
        block2: {
            try {
                jbpmContext.deployProcessDefinition(processDefinition);
                this.log("process definition " + processDefinition.getName() + " deployed successfully");
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                this.log("failed to deploy process " + processDefinition.getName(), e, 0);
                if (!this.failOnError) break block2;
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setProcess(File process) {
        this.process = process;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

