/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;

public class BMPOptimizer
extends PNGOptimizer {
    public static BufferedImage readBmp(InputStream is) throws ImageReadException, IOException {
        return Sanselan.getBufferedImage((InputStream)is);
    }

    public BMPOptimizer(OptimizerConfig config, HttpResponseBuilder response) {
        super(config, response);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        this.outputter = new BaseOptimizer.ImageIOOutputter(writer, null);
    }

    protected String getOriginalContentType() {
        return "image/bmp";
    }

    protected String getOriginalFormatName() {
        return "bmp";
    }
}

