/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UIShowAllTrashResult.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}), @EventConfig(listeners={RestoreActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class})})
public class UIShowAllTrashResult
extends UIComponentDecorator {
    public static final int SHOW_ALL_FROM_TRASH = 0;
    public static final int SHOW_ALL_FROM_TRASH_BY_USER = 1;
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.search.UIShowAllTrashResult");
    private static final int FILE_PER_PAGE = 10;
    private static String iconType = "BlueDownArrow";
    private static String iconName = "";
    private long searchTime_ = 0L;
    private List<Node> trashNodes_ = new ArrayList<Node>();
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIShowAllTrashIterator");
    private int showNodeCase;
    private boolean nodeListChange = false;

    public UIShowAllTrashResult() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public void setShowNodeCase(int value) {
        this.showNodeCase = value;
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getAllTrashNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    protected List<Node> getNewTrashNodeList() throws Exception {
        List ret = new ArrayList();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        TrashService trashService = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String trashWorkspace = portletPref.getValue(Utils.TRASH_WORKSPACE, "");
        SessionProvider sessionProvider = uiExplorer.getSessionProvider();
        boolean byUser = uiExplorer.getPreference().isShowItemsByUser();
        ret = !byUser ? trashService.getAllNodeInTrash(trashWorkspace, sessionProvider) : trashService.getAllNodeInTrashByUser(trashWorkspace, sessionProvider, uiExplorer.getSession().getUserID());
        return ret;
    }

    public void updateList() throws Exception {
        List<Node> nodeList = this.getNewTrashNodeList();
        ListAccessImpl newTrashNodeList = new ListAccessImpl(Node.class, nodeList);
        LazyPageList pageList = new LazyPageList((ListAccess)newTrashNodeList, 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        this.trashNodes_ = nodeList;
    }

    private void updateTable(Event<UIShowAllTrashResult> event) throws Exception {
        int currentPage = this.uiPageIterator_.getCurrentPage();
        if (this.nodeListChange) {
            this.updateList();
            this.nodeListChange = false;
        }
        Collections.sort(this.trashNodes_, new SearchComparator());
        ListAccessImpl trashNodeList = new ListAccessImpl(Node.class, this.trashNodes_);
        LazyPageList pageList = new LazyPageList((ListAccess)trashNodeList, 10);
        UIPageIterator uiPageIterator = this.uiPageIterator_;
        uiPageIterator.setPageList((PageList)pageList);
        uiPageIterator.setPageList((PageList)pageList);
        if (uiPageIterator.getAvailablePage() >= currentPage) {
            uiPageIterator.setCurrentPage(currentPage);
        } else {
            uiPageIterator.setCurrentPage(uiPageIterator.getAvailablePage());
        }
        event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchComparator
    implements Comparator<Node> {
        private SearchComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                if (iconType.equals("BlueUpArrow") || iconType.equals("BlueDownArrow")) {
                    String s1 = node1.getProperty("jcr:primaryType").getString();
                    String s2 = node2.getProperty("jcr:primaryType").getString();
                    if (iconType.trim().equals("BlueUpArrow")) {
                        return s2.compareTo(s1);
                    }
                    return s1.compareTo(s2);
                }
                if (iconName.equals("BlueUpArrow") || iconName.equals("BlueDownArrow")) {
                    String name1 = node1.getName();
                    String name2 = node2.getName();
                    if (iconName.trim().equals("BlueUpArrow")) {
                        return name2.compareTo(name1);
                    }
                    return name1.compareTo(name2);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot compare nodes", (Throwable)e);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreActionListener
    extends EventListener<UIShowAllTrashResult> {
        public void execute(Event<UIShowAllTrashResult> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            UIShowAllTrashResult uiShowAllTrashResult = (UIShowAllTrashResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllTrashResult.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiShowAllTrashResult.getAncestorOfType(UIApplication.class);
            ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
            TrashService trashService = (TrashService)myContainer.getComponentInstanceOfType(TrashService.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            String wsName = null;
            Node node = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            try {
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                srcPath = node.getPath();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                if (!PermissionUtil.canRemoveNode((Node)node)) {
                    throw new AccessDeniedException();
                }
                PortletPreferences portletPrefs = uiExplorer.getPortletPreferences();
                String trashWorkspace = portletPrefs.getValue(Utils.TRASH_WORKSPACE, "");
                String trashHomeNodePath = portletPrefs.getValue(Utils.TRASH_HOME_NODE_PATH, "");
                Session trashSession = uiExplorer.getSessionByWorkspace(trashWorkspace);
                Node trashHomeNode = (Node)trashSession.getItem(trashHomeNodePath);
                SessionProvider sessionProvider = uiExplorer.getSessionProvider();
                trashService.restoreFromTrash(trashHomeNode, srcPath, sessionProvider);
                uiShowAllTrashResult.nodeListChange = true;
                uiShowAllTrashResult.updateTable((Event<UIShowAllTrashResult>)event);
            }
            catch (LockException e) {
                LOG.error((Object)("node is locked, can't restore node :" + node.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                uiExplorer.updateAjax(event);
            }
            catch (AccessDeniedException e) {
                LOG.error((Object)("Access denied! No permission for restoring node: " + node.getPath()));
                uiApp.addMessage(new ApplicationMessage("UIShowAllTrashResult.msg.accessDenied", null, 1));
            }
            catch (Exception e) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                uiExplorer.updateAjax(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIShowAllTrashResult> {
        public void execute(Event<UIShowAllTrashResult> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            UIShowAllTrashResult uiShowAllTrashResult = (UIShowAllTrashResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllTrashResult.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiShowAllTrashResult.getAncestorOfType(UIApplication.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            String wsName = null;
            Node node = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            try {
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                session = node.getSession();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            Node parentNode = node.getParent();
            uiExplorer.addLockToken(parentNode);
            try {
                if (PermissionUtil.canRemoveNode((Node)node)) {
                    if (node.isNodeType("rma:record")) {
                        this.removeMixins(node);
                    }
                } else {
                    throw new AccessDeniedException();
                }
                ThumbnailService thumbnailService = (ThumbnailService)uiShowAllTrashResult.getApplicationComponent(ThumbnailService.class);
                thumbnailService.processRemoveThumbnail(node);
                node.remove();
                parentNode.save();
                uiShowAllTrashResult.nodeListChange = true;
                uiShowAllTrashResult.updateTable((Event<UIShowAllTrashResult>)event);
            }
            catch (AccessDeniedException e) {
                LOG.error((Object)("Access denied! No permission for deleting node: " + node.getPath()));
                uiApp.addMessage(new ApplicationMessage("UIShowAllTrashResult.msg.accessDenied", null, 1));
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ReferentialIntegrityException ref) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ConstraintViolationException cons) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (LockException lockException) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }

        private void removeMixins(Node node) throws Exception {
            NodeType[] mixins;
            for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
                node.removeMixin(nodeType.getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDESCActionListener
    extends EventListener<UIShowAllTrashResult> {
        public void execute(Event<UIShowAllTrashResult> event) throws Exception {
            UIShowAllTrashResult uiShowAllTrashResult = (UIShowAllTrashResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueUpArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueUpArrow";
            }
            uiShowAllTrashResult.updateTable((Event<UIShowAllTrashResult>)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortASCActionListener
    extends EventListener<UIShowAllTrashResult> {
        public void execute(Event<UIShowAllTrashResult> event) throws Exception {
            UIShowAllTrashResult uiShowAllTrashResult = (UIShowAllTrashResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueDownArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueDownArrow";
            }
            uiShowAllTrashResult.updateTable((Event<UIShowAllTrashResult>)event);
        }
    }
}

