/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.lang.reflect.Method;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageCreationWizard;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIMainActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditBackgroundActionListener
    extends EventListener<UIWorkingWorkspace> {
        private Log log = ExoLogger.getExoLogger(((Object)((Object)this)).getClass());

        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIWorkingWorkspace workingWorkspace = (UIWorkingWorkspace)((Object)event.getSource());
            UIPage uiPage = (UIPage)workingWorkspace.findFirstComponentOfType(UIPage.class);
            Method showEditBackgroundPopupMethod = null;
            try {
                if (uiPage == null) {
                    return;
                }
                showEditBackgroundPopupMethod = ((Object)((Object)uiPage)).getClass().getDeclaredMethod("showEditBackgroundPopup", WebuiRequestContext.class);
            }
            catch (NoSuchMethodException ex) {
                this.log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            if (showEditBackgroundPopupMethod != null) {
                showEditBackgroundPopupMethod.invoke((Object)uiPage, event.getRequestContext());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreatePortalActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)((UIWorkingWorkspace)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasCreatePortalPermission()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalBrowser.msg.Invalid-createPermission", null));
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm uiNewPortal = uiMaskWS.createUIComponent(UIPortalForm.class, "CreatePortal", "UIPortalForm");
            uiNewPortal.initPortalTemplateTab();
            uiMaskWS.setUIComponent((UIComponent)uiNewPortal);
            uiMaskWS.setShow(true);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInlineActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPortalApplication portalApp = (UIPortalApplication)pcontext.getUIApplication();
            UIPortal currentPortal = portalApp.getCurrentSite();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)((Object)event.getSource());
            UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermissionOnPortal(currentPortal.getSiteType().getName(), currentPortal.getName(), currentPortal.getEditPermission())) {
                portalApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditLayout-Permission", (Object[])new String[]{currentPortal.getName()}));
                return;
            }
            DataStorage dataStorage = (DataStorage)portalApp.getApplicationComponent(DataStorage.class);
            PortalConfig portalConfig = dataStorage.getPortalConfig(pcontext.getSiteType().getName(), pcontext.getSiteName());
            UIPortal transientPortal = (UIPortal)uiWorkingWS.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(transientPortal, portalConfig);
            transientPortal.setNavPath(currentPortal.getNavPath());
            transientPortal.refreshUIPage();
            uiWorkingWS.setBackupUIPortal(currentPortal);
            portalApp.setModeState(1);
            UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
            uiEditWS.setUIComponent((UIComponent)transientPortal);
            UISiteBody siteBody = (UISiteBody)uiWorkingWS.findFirstComponentOfType(UISiteBody.class);
            siteBody.setUIComponent(null);
            UIPortalComposer uiComposer = (UIPortalComposer)uiEditWS.getComposer().setRendered(true);
            uiComposer.setComponentConfig(UIPortalComposer.class, null);
            uiComposer.setShowControl(true);
            uiComposer.setEditted(false);
            uiComposer.setCollapse(false);
            uiComposer.setId("UIPortalComposer");
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageCreationWizardActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UserNodeFilterConfig filterConfig;
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIPortal uiPortal = Util.getUIPortal();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            UserNavigation currNav = uiPortal.getUserNavigation();
            if (currNav == null) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.navigation.deleted", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                return;
            }
            if (!currNav.isModifiable()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-CreatePage-Permission", null));
                return;
            }
            UserNode selectedNode = Util.getUIPortal().getSelectedUserNode();
            UserNode resolvedNode = this.resolveNode(selectedNode, filterConfig = this.createFilterConfig());
            if (resolvedNode == null) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                context.getUIApplication().addMessage(new ApplicationMessage("UIPortalManagement.msg.node.deleted", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                return;
            }
            uiApp.setModeState(1);
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            UIPortalComposer portalComposer = (UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class);
            portalComposer.setRendered(false);
            portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            portalComposer.setId("UIPageEditor");
            portalComposer.setShowControl(true);
            portalComposer.setEditted(true);
            portalComposer.setCollapse(false);
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(false);
            uiToolPanel.setWorkingComponent(UIPageCreationWizard.class, null);
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)uiToolPanel.getUIComponent();
            uiWizard.configure(resolvedNode);
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            uiPageSetInfo.setShowPublicationDate(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        }

        private UserNode resolveNode(UserNode selectedNode, UserNodeFilterConfig filterConfig) throws Exception {
            UserNavigation currNav = selectedNode.getNavigation();
            UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
            if (currNav.getKey().getType().equals((Object)SiteType.USER)) {
                return userPortal.getNode(currNav, Scope.CHILDREN, filterConfig, null);
            }
            return userPortal.resolvePath(currNav, filterConfig, selectedNode.getURI());
        }

        private UserNodeFilterConfig createFilterConfig() {
            UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
            filterConfigBuilder.withReadWriteCheck();
            return filterConfigBuilder.build();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditCurrentPageActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
            UIPage uiPage = (UIPage)pageBody.getUIComponent();
            if (uiPage == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", null));
                return;
            }
            Page page = PortalDataMapper.toPageModel(uiPage);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasEditPermission(page)) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditPage-Permission", null));
                return;
            }
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
            portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            portalComposer.setId("UIPageEditor");
            portalComposer.setShowControl(true);
            portalComposer.setEditted(false);
            portalComposer.setCollapse(false);
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(false);
            uiApp.setModeState(1);
            UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
            UIPage newUIPage = clazz.createUIPage(null);
            PortalDataMapper.toUIPage(newUIPage, page);
            uiToolPanel.setWorkingComponent((UIComponent)newUIPage);
            pageBody.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            Util.getPortalRequestContext().setFullRender(true);
        }
    }
}

