/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.exoplatform.wcm.connector.FileUploadHandler;
import org.exoplatform.wcm.connector.handler.FCKFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wcmDriver/")
public class DriverConnector
extends BaseConnector
implements ResourceContainer {
    public static final String FILE_TYPE_WEBCONTENT = "Web Contents";
    public static final String FILE_TYPE_DMSDOC = "DMS Documents";
    public static final String FILE_TYPE_MEDIAS = "Medias";
    public static final String FILE_TYPE_ALL = "All";
    public static final String FILE_TYPE_IMAGE = "Image";
    public static final String[] MEDIA_MIMETYPE = new String[]{"application", "image", "audio", "video"};
    public static final String[] IMAGE_MIMETYPE = new String[]{"image"};
    private static Log log = ExoLogger.getLogger(DriverConnector.class);
    private int limit;
    private PortalContainer manager;
    private OrganizationService organizationService = null;
    private ResourceBundleService resourceBundleService = null;
    private String[] resourceBundleNames;
    private ResourceBundle sharedResourceBundle = null;
    private Locale lang = Locale.ENGLISH;

    public DriverConnector(InitParams params) {
        this.limit = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        this.manager = PortalContainer.getInstance();
    }

    @GET
    @Path(value="/getDrivers/")
    public Response getDrivers(@QueryParam(value="lang") String lang) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        List<DriveData> listDriver = this.getDriversByUserId(userId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("isUpload", "false");
        rootElement.appendChild(this.appendDrivers(document, this.generalDrivers(listDriver), "General Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.groupDrivers(listDriver, userId), "Group Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.personalDrivers(listDriver, userId), "Personal Drives", lang));
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="filterBy") String filterBy) throws Exception {
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            ManageDriveService manageDriveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
            String driverHomePath = manageDriveService.getDriveByName(Text.escapeIllegalJcrChars((String)driverName)).getHomePath();
            String itemPath = driverHomePath + (currentFolder != null && !"".equals(currentFolder) && !driverHomePath.endsWith("/") ? "/" : "") + currentFolder;
            ConversationState conversationState = ConversationState.getCurrent();
            String userId = conversationState.getIdentity().getUserId();
            itemPath = Utils.getPersonalDrivePath((String)itemPath, (String)userId);
            Node node = (Node)session.getItem(Text.escapeIllegalJcrChars((String)itemPath));
            return this.buildXMLResponseForChildren(node, null, filterBy, session, currentPortal, Text.escapeIllegalJcrChars((String)driverName));
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getFoldersAndFiles: ", (Throwable)e);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    @POST
    @Path(value="/uploadFile/upload/")
    public Response uploadFile(@Context HttpServletRequest servletRequest, @QueryParam(value="uploadId") String uploadId) throws Exception {
        return this.fileUploadHandler.upload(servletRequest, uploadId, this.limit);
    }

    @GET
    @Path(value="/uploadFile/control/")
    public Response processUpload(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String siteName, @QueryParam(value="userId") String userId, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId) throws Exception {
        try {
            if (repositoryName != null && workspaceName != null && driverName != null && currentFolder != null) {
                Node currentFolderNode = this.getParentFolderNode(Text.escapeIllegalJcrChars((String)workspaceName), Text.escapeIllegalJcrChars((String)driverName), Text.escapeIllegalJcrChars((String)currentFolder));
                return this.createProcessUploadResponse(Text.escapeIllegalJcrChars((String)workspaceName), currentFolderNode, siteName, userId, Text.escapeIllegalJcrChars((String)jcrPath), action, language, fileName, uploadId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform processUpload: ", (Throwable)e);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    private List<DriveData> getDriversByUserId(String userId) throws Exception {
        ManageDriveService driveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
        List<String> userRoles = this.getMemberships(userId);
        return driveService.getDriveByUserRoles(userId, userRoles);
    }

    private Element appendDrivers(Document document, List<DriveData> driversList, String groupName, String lang) throws Exception {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", this.resolveDriveLabel(groupName, lang));
        folders.setAttribute("isUpload", "false");
        for (DriveData driver : driversList) {
            String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
            String workspace = driver.getWorkspace();
            String path = driver.getHomePath();
            String name = driver.getName();
            Element folder = document.createElement("Folder");
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, path);
            Node driveNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
            if (driveNode == null) continue;
            folder.setAttribute("name", name);
            folder.setAttribute("label", this.resolveDriveLabel(name, lang));
            folder.setAttribute("url", FCKUtils.createWebdavURL(driveNode));
            folder.setAttribute("folderType", "exo:drive");
            folder.setAttribute("path", path);
            folder.setAttribute("repository", repository);
            folder.setAttribute("workspace", workspace);
            folder.setAttribute("isUpload", "true");
            folders.appendChild(folder);
        }
        return folders;
    }

    private String resolveDriveLabel(String name, String lang) {
        if (this.resourceBundleService == null) {
            this.resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
            this.resourceBundleNames = this.resourceBundleService.getSharedResourceBundleNames();
            this.sharedResourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleNames, this.lang);
        }
        try {
            if (!this.lang.getLanguage().equals(lang)) {
                this.lang = new Locale(lang);
                this.sharedResourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleNames, this.lang);
            }
            return this.sharedResourceBundle.getString("ContentSelector.title." + name.replaceAll(" ", ""));
        }
        catch (MissingResourceException missingResourceException) {
            return name;
        }
    }

    private List<DriveData> personalDrivers(List<DriveData> driveList, String userId) throws Exception {
        ArrayList<DriveData> personalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userId);
        for (DriveData drive : driveList) {
            String driveHomePath = Utils.getPersonalDrivePath((String)drive.getHomePath(), (String)userId);
            if (!driveHomePath.startsWith(userNode.getPath())) continue;
            drive.setHomePath(driveHomePath);
            personalDrivers.add(drive);
        }
        Collections.sort(personalDrivers);
        return personalDrivers;
    }

    private List<DriveData> groupDrivers(List<DriveData> driverList, String userId) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        ArrayList<DriveData> groupDrivers = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List<String> groups = this.getGroups(userId);
        block0: for (DriveData drive : driverList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrivers.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrivers);
        return groupDrivers;
    }

    private List<DriveData> generalDrivers(List<DriveData> driverList) throws Exception {
        ArrayList<DriveData> generalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driverList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrivers.add(drive);
        }
        return generalDrivers;
    }

    private List<String> getMemberships(String userId) throws Exception {
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = DriverConnector.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private static Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    private List<String> getGroups(String userId) throws Exception {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        }
        ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)this.manager);
        ArrayList<String> groupList = new ArrayList<String>();
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(userId);
        Object[] objects = groups.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Group group = (Group)objects[i];
            String groupPath = null;
            groupPath = group.getParentId() == null || group.getParentId().length() == 0 ? "/" + group.getGroupName() : group.getParentId() + "/" + group.getGroupName();
            groupList.add(groupPath);
        }
        return groupList;
    }

    private Response buildXMLResponseForChildren(Node node, String command, String filterBy, Session session, String currentPortal, String nodeDriveName) throws Exception {
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        NodeList nodeList = rootElement.getElementsByTagName("CurrentFolder");
        Element currentFolder = (Element)nodeList.item(0);
        currentFolder.setAttribute("isUpload", "true");
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Folders");
        folders.setAttribute("isUpload", "true");
        Element files = document.createElement("Files");
        files.setAttribute("isUpload", "true");
        Node sourceNode = null;
        Node checkNode = null;
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            String fileType = null;
            if (child.isNodeType(FCKUtils.EXO_HIDDENABLE)) continue;
            sourceNode = child.isNodeType("exo:symlink") && child.hasProperty("exo:uuid") ? session.getNodeByUUID(child.getProperty("exo:uuid").getString()) : child;
            Node node2 = checkNode = sourceNode != null ? sourceNode : child;
            if (this.isFolder(checkNode)) {
                Element folder = this.createFolderElement(document, checkNode, checkNode.getPrimaryNodeType().getName(), child.getName(), nodeDriveName);
                folders.appendChild(folder);
            }
            if (FILE_TYPE_ALL.equals(filterBy) && (checkNode.isNodeType("exo:webContent") || checkNode.isNodeType("exo:article") || !this.isFolder(checkNode))) {
                fileType = FILE_TYPE_ALL;
            }
            if (FILE_TYPE_WEBCONTENT.equals(filterBy) && (checkNode.isNodeType("exo:webContent") || checkNode.isNodeType("exo:article"))) {
                fileType = FILE_TYPE_WEBCONTENT;
            }
            if (FILE_TYPE_MEDIAS.equals(filterBy) && this.isMediaType(checkNode)) {
                fileType = FILE_TYPE_MEDIAS;
            }
            if (FILE_TYPE_DMSDOC.equals(filterBy) && this.isDMSDocument(checkNode)) {
                fileType = FILE_TYPE_DMSDOC;
            }
            if (FILE_TYPE_IMAGE.equals(filterBy) && this.isImageType(checkNode)) {
                fileType = FILE_TYPE_IMAGE;
            }
            if (fileType == null) continue;
            Element file = FCKFileHandler.createFileElement(document, fileType, checkNode, child, currentPortal, this.linkManager);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        try {
            if (this.isDMSDocument(checkNode)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return checkNode.isNodeType("nt:unstructured") || checkNode.isNodeType("nt:folder") || checkNode.isNodeType("exo:taxonomy");
    }

    private boolean isDMSDocument(Node node) throws Exception {
        TemplateService templateService = (TemplateService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TemplateService.class);
        List dmsDocumentListTmp = templateService.getDocumentTemplates();
        ArrayList dmsDocumentList = new ArrayList();
        dmsDocumentList.addAll(dmsDocumentListTmp);
        dmsDocumentList.remove("exo:webContent");
        dmsDocumentList.remove("exo:article");
        for (String documentType : dmsDocumentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType) || this.isMediaType(node) || node.isNodeType("exo:webContent")) continue;
            return true;
        }
        return false;
    }

    private boolean isMediaType(Node node) {
        String mimeType = "";
        try {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            return false;
        }
        for (String type : MEDIA_MIMETYPE) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isImageType(Node node) {
        String mimeType = "";
        try {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            return false;
        }
        for (String type : IMAGE_MIMETYPE) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getImagesFolder(node);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getImagesFolders(node);
        }
    }

    @Deprecated
    protected Response createUploadFileResponse(InputStream inputStream, String repositoryName, String workspaceName, Node currentFolderNode, String runningPortalName, String jcrPath, String uploadId, String language, String contentType, String contentLength, int limit) throws Exception {
        return this.fileUploadHandler.upload(uploadId, contentType, Double.parseDouble(contentLength), inputStream, currentFolderNode, language, limit);
    }

    protected Response createProcessUploadResponse(String workspaceName, Node currentFolderNode, String siteName, String userId, String jcrPath, String action, String language, String fileName, String uploadId) throws Exception {
        if (FileUploadHandler.SAVE_ACTION.equals(action)) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return this.fileUploadHandler.saveAsNTFile(currentFolderNode, uploadId, fileName, language, siteName, userId);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    private Node getParentFolderNode(String workspaceName, String driverName, String currentFolder) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspaceName, manageableRepository);
        ManageDriveService manageDriveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
        try {
            return (Node)session.getItem(manageDriveService.getDriveByName(driverName).getHomePath() + (currentFolder != null && currentFolder.length() != 0 ? "/" : "") + currentFolder);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Element createFolderElement(Document document, Node child, String folderType, String childName, String nodeDriveName) throws Exception {
        Element folder = document.createElement("Folder");
        folder.setAttribute("name", childName);
        folder.setAttribute("title", Utils.getTitle((Node)child));
        folder.setAttribute("url", FCKUtils.createWebdavURL(child));
        folder.setAttribute("folderType", folderType);
        folder.setAttribute("path", child.getPath());
        folder.setAttribute("isUpload", "true");
        if (nodeDriveName != null && nodeDriveName.length() > 0) {
            folder.setAttribute("nodeDriveName", nodeDriveName);
        }
        return folder;
    }
}

