/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UICBScripts
extends UIContainer {
    public static String SCRIPTLIST_NAME = "CBScriptList";
    public static String SCRIPTFORM_NAME = "CBScriptForm";
    public static String SCRIPT_PAGE = "PageIterator";

    public UICBScripts() throws Exception {
        UIScriptList list = (UIScriptList)this.addChild(UIScriptList.class, null, SCRIPTLIST_NAME);
        list.getUIPageIterator().setId(SCRIPTLIST_NAME + SCRIPT_PAGE);
    }

    public void refresh(int currentPage) throws Exception {
        UIScriptList uiScriptList = (UIScriptList)this.getChildById(SCRIPTLIST_NAME);
        uiScriptList.updateGrid(this.getCBScript(), currentPage);
    }

    public List<UIScriptList.ScriptData> getCBScript() throws Exception {
        ArrayList<UIScriptList.ScriptData> scriptData = new ArrayList<UIScriptList.ScriptData>();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node cbScripts = scriptService.getCBScriptHome(WCMCoreUtils.getSystemSessionProvider());
        NodeIterator nodeList = cbScripts.getNodes();
        while (nodeList.hasNext()) {
            Node node = nodeList.nextNode();
            String version = "";
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            UIScriptList.ScriptData script = new UIScriptList.ScriptData(node.getName(), node.getPath(), version);
            scriptData.add(script);
        }
        return scriptData;
    }

    public void initFormPopup(String id) throws Exception {
        this.removeChildById(id);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 500);
        UIScriptForm uiForm = (UIScriptForm)this.createUIComponent(UIScriptForm.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }
}

