/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.exoplatform.commons.utils.SecurityHelper;

public class DefaultGroovyResourceLoader
implements GroovyResourceLoader {
    private static final String DEFAULT_SOURCE_FILE_EXTENSION = ".groovy";
    public final ConcurrentMap<String, Future<URL>> findResourceURLTasks = new ConcurrentHashMap<String, Future<URL>>();
    private int maxEntries = 512;
    protected final Map<String, URL> resources;
    protected final URL[] roots;

    public DefaultGroovyResourceLoader(URL[] roots) throws MalformedURLException {
        this.roots = new URL[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            String str = roots[i].toString();
            this.roots[i] = str.charAt(str.length() - 1) != '/' ? new URL(str + '/') : roots[i];
        }
        this.resources = Collections.synchronizedMap(new LinkedHashMap<String, URL>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, URL> eldest) {
                return this.size() > DefaultGroovyResourceLoader.this.maxEntries;
            }
        });
    }

    public DefaultGroovyResourceLoader(URL root) throws MalformedURLException {
        this(new URL[]{root});
    }

    public final URL loadGroovySource(String filename) throws MalformedURLException {
        URL resource = null;
        final String ffilename = filename.replace('.', '/') + this.getSourceFileExtension();
        try {
            resource = (URL)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return DefaultGroovyResourceLoader.this.getResource(ffilename);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            throw (MalformedURLException)cause;
        }
        return resource;
    }

    protected URL getResource(final String filename) throws MalformedURLException {
        FutureTask<URL> f;
        URL resource = this.resources.get(filename);
        if (resource != null && this.checkResource(resource)) {
            return resource;
        }
        FutureTask<URL> findResourceURLTask = (FutureTask<URL>)this.findResourceURLTasks.get(filename);
        if (findResourceURLTask == null && (findResourceURLTask = (Future)this.findResourceURLTasks.putIfAbsent(filename, f = new FutureTask<URL>(new Callable<URL>(){

            @Override
            public URL call() throws Exception {
                return DefaultGroovyResourceLoader.this.findResourceURL(filename);
            }
        }))) == null) {
            findResourceURLTask = f;
            f.run();
        }
        try {
            return (URL)findResourceURLTask.get();
        }
        catch (CancellationException e) {
            this.findResourceURLTasks.remove(filename, findResourceURLTask);
        }
        catch (ExecutionException e) {
            throw (MalformedURLException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    protected URL findResourceURL(String filename) throws MalformedURLException {
        boolean inCache;
        URL resource = this.resources.get(filename);
        boolean bl = inCache = resource != null;
        if (inCache && !this.checkResource(resource)) {
            resource = null;
        }
        for (int i = 0; i < this.roots.length && resource == null; ++i) {
            URL tmp = this.createURL(this.roots[i], filename);
            if (!this.checkResource(tmp)) continue;
            resource = tmp;
        }
        if (resource != null) {
            this.resources.put(filename, resource);
        } else if (inCache) {
            this.resources.remove(filename);
        }
        return resource;
    }

    protected URL createURL(URL root, String filename) throws MalformedURLException {
        return new URL(root, filename);
    }

    protected String getSourceFileExtension() {
        return DEFAULT_SOURCE_FILE_EXTENSION;
    }

    protected boolean checkResource(URL resource) {
        try {
            resource.openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

