/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.axiom.attachments.BoundaryDelimitedStream;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.om.OMException;

public final class MultipartAttachmentStreams
extends IncomingAttachmentStreams {
    private BoundaryDelimitedStream _delimitedStream = null;

    public MultipartAttachmentStreams(BoundaryDelimitedStream delimitedStream) throws OMException {
        this._delimitedStream = delimitedStream;
    }

    public IncomingAttachmentInputStream getNextStream() throws OMException {
        InternetHeaders headers;
        if (!this.isReadyToGetNextStream()) {
            throw new IllegalStateException("nextStreamNotReady");
        }
        try {
            this._delimitedStream = this._delimitedStream.getNextStream();
            if (this._delimitedStream == null) {
                return null;
            }
            headers = new InternetHeaders((InputStream)this._delimitedStream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OMException(ioe);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new OMException(me);
        }
        IncomingAttachmentInputStream stream = new IncomingAttachmentInputStream(this._delimitedStream, this);
        Enumeration e = headers.getAllHeaders();
        while (e != null && e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            String name = header.getName().toLowerCase();
            String value = header.getValue();
            if ("content-id".equals(name) || "content-type".equals(name) || "content-location".equals(name)) {
                value = value.trim();
            }
            stream.addHeader(name, value);
        }
        this.setReadyToGetNextStream(false);
        return stream;
    }
}

