/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.impl.DocumentType;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTypeServiceImpl
implements DocumentTypeService {
    private static final Log LOG = ExoLogger.getLogger((String)"cms.documents.DocumentTypeServiceImpl");
    private static final String OWNER = "exo:owner".intern();
    private static final String QUERY = " SELECT * FROM nt:resource WHERE";
    private static final String CONTENT_QUERY = " SELECT * FROM nt:base WHERE ";
    private static final String EXO_DATE_MODIFIED = "exo:dateModified";
    private static final String JCR_MINE_TYPE = "jcr:mimeType".intern();
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType".intern();
    private static final String SQL = "sql";
    private static final String AND = " AND ";
    private static final String CONTAINS = " contains";
    private static final String SINGLE_QUOTE = "'";
    private static final String OR = " OR ";
    private static final String BEGIN_BRANCH = " ( ";
    private static final String END_BRANCH = " ) ";
    private RepositoryService repositoryService_;
    private TemplateService templateService_;
    private InitParams params_;

    public DocumentTypeServiceImpl(RepositoryService repoService, InitParams initParams, TemplateService templateService) {
        this.repositoryService_ = repoService;
        this.templateService_ = templateService;
        this.params_ = initParams;
    }

    @Override
    public List<String> getAllSupportedType() {
        ArrayList<String> supportedType = new ArrayList<String>();
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            supportedType.add(objectParam.getName());
        }
        Collections.sort(supportedType);
        return supportedType;
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentsByDocumentType(String documentType, String workspace, String repository, SessionProvider sessionProvider) throws Exception {
        return this.getAllDocumentsByType(workspace, repository, sessionProvider, this.getMimeTypes(documentType));
    }

    public List<Node> getAllDocumentsByDocumentType(String documentType, String workspace, SessionProvider sessionProvider) throws Exception {
        return this.getAllDocumentsByType(workspace, sessionProvider, this.getMimeTypes(documentType));
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentsByType(String workspace, String repository, SessionProvider sessionProvider, String mimeType) throws Exception {
        return this.getAllDocumentsByType(workspace, repository, sessionProvider, new String[]{mimeType});
    }

    public List<Node> getAllDocumentsByType(String workspace, SessionProvider sessionProvider, String mimeType) throws Exception {
        return this.getAllDocumentsByType(workspace, sessionProvider, new String[]{mimeType});
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentsByUser(String workspace, String repository, SessionProvider sessionProvider, String[] mimeTypes, String userName) throws Exception {
        return this.getAllDocumentsByUser(workspace, sessionProvider, mimeTypes, userName);
    }

    @Override
    public List<Node> getAllDocumentsByUser(String workspace, SessionProvider sessionProvider, String[] mimeTypes, String userName) throws Exception {
        Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
        ArrayList<Node> resultList = new ArrayList<Node>();
        QueryResult results = null;
        try {
            results = this.executeQuery(session, this.buildQueryByMimeTypes(mimeTypes, userName), SQL);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        NodeIterator iterator = results.getNodes();
        Node documentNode = null;
        while (iterator.hasNext()) {
            documentNode = iterator.nextNode();
            resultList.add(documentNode.getParent());
        }
        return resultList;
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentsByType(String workspace, String repository, SessionProvider sessionProvider, String[] mimeTypes) throws Exception {
        return this.getAllDocumentsByUser(workspace, repository, sessionProvider, mimeTypes, null);
    }

    public List<Node> getAllDocumentsByType(String workspace, SessionProvider sessionProvider, String[] mimeTypes) throws Exception {
        return this.getAllDocumentsByUser(workspace, sessionProvider, mimeTypes, null);
    }

    @Override
    public String[] getMimeTypes(String documentType) {
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        List<Object> mimeTypes = new ArrayList();
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            if (!objectParam.getName().equals(documentType)) continue;
            mimeTypes = ((DocumentType)objectParam.getObject()).getMimeTypes();
            break;
        }
        return mimeTypes.toArray(new String[mimeTypes.size()]);
    }

    @Override
    public boolean isContentsType(String documentType) {
        Iterator iter = this.params_.getObjectParamIterator();
        ObjectParameter objectParam = null;
        while (iter.hasNext()) {
            objectParam = (ObjectParameter)iter.next();
            if (!objectParam.getName().equals(documentType)) continue;
            return Boolean.parseBoolean(((DocumentType)objectParam.getObject()).getContentsType());
        }
        return false;
    }

    @Override
    @Deprecated
    public List<Node> getAllDocumentByContentsType(String documentType, String workspace, String repository, SessionProvider sessionProvider, String userName) throws Exception {
        return this.getAllDocumentByContentsType(documentType, workspace, sessionProvider, userName);
    }

    @Override
    public List<Node> getAllDocumentByContentsType(String documentType, String workspace, SessionProvider sessionProvider, String userName) throws Exception {
        if (this.isContentsType(documentType)) {
            Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            ArrayList<Node> resultList = new ArrayList<Node>();
            QueryResult results = null;
            try {
                results = this.executeQuery(session, this.buildQueryByContentsType(userName), SQL);
            }
            catch (Exception e) {
                LOG.error((Object)"An unexpected exception appear", (Throwable)e);
            }
            NodeIterator iterator = results.getNodes();
            while (iterator.hasNext()) {
                resultList.add(iterator.nextNode());
            }
            return resultList;
        }
        return null;
    }

    private QueryResult executeQuery(Session session, String statement, String language) {
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement, language);
            return query.execute();
        }
        catch (Exception e) {
            LOG.error((Object)"SQL query fail", (Throwable)e);
            return null;
        }
    }

    private String buildQueryByMimeTypes(String[] mimeTypes, String userName) throws Exception {
        StringBuilder query = new StringBuilder();
        if (userName == null) {
            for (String mimeType : mimeTypes) {
                if (query.length() > 0) {
                    query.append(OR);
                }
                query.append(CONTAINS).append("(").append(JCR_MINE_TYPE).append(",").append(SINGLE_QUOTE).append(mimeType.trim()).append(SINGLE_QUOTE).append(")");
            }
        } else {
            query.append(BEGIN_BRANCH);
            for (String mimeType : mimeTypes) {
                if (query.length() > BEGIN_BRANCH.length()) {
                    query.append(OR);
                }
                query.append(CONTAINS).append("(").append(JCR_MINE_TYPE).append(",").append(SINGLE_QUOTE).append(mimeType.trim()).append(SINGLE_QUOTE).append(")");
            }
            query.append(END_BRANCH);
            query.append(AND);
            query.append("(").append(OWNER).append("=").append(SINGLE_QUOTE).append(userName).append(SINGLE_QUOTE).append(")");
        }
        query.append(" ORDER  BY exo:dateModified");
        return QUERY + query.toString();
    }

    private String buildQueryByContentsType(String userName) throws Exception {
        List<String> contentsType = this.templateService_.getAllDocumentNodeTypes();
        StringBuilder constraint = new StringBuilder();
        if (userName == null) {
            for (String contentType : contentsType) {
                if (constraint.length() > 0) {
                    constraint.append(OR);
                }
                constraint.append("(").append(JCR_PRIMARY_TYPE).append("=").append(SINGLE_QUOTE).append(contentType).append(SINGLE_QUOTE).append(")");
            }
        } else {
            constraint.append(BEGIN_BRANCH);
            for (String contentType : contentsType) {
                if (constraint.length() > BEGIN_BRANCH.length()) {
                    constraint.append(OR);
                }
                constraint.append("(").append(JCR_PRIMARY_TYPE).append("=").append(SINGLE_QUOTE).append(contentType).append(SINGLE_QUOTE).append(")");
            }
            constraint.append(END_BRANCH);
            constraint.append(AND);
            constraint.append("(").append(OWNER).append("=").append(SINGLE_QUOTE).append(userName).append(SINGLE_QUOTE).append(")");
        }
        constraint.append(" ORDER  BY exo:dateModified");
        return CONTENT_QUERY + constraint.toString();
    }
}

