/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.skin.WCMSkinResourceResolver;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class XSkinService
implements Startable {
    private static String SHARED_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and exo:sharedCSS='true' and jcr:mixinTypes <> 'exo:restoreLocation' " + "order by exo:priority ASC".intern();
    public static final String SKIN_PATH_REGEXP = "/(.*)/css/jcr/(.*)/(.*)/(.*).css".intern();
    private static final String SKIN_PATH_PATTERN = "/{docBase}/css/jcr/(.*)/(.*)/Stylesheet.css".intern();
    private static Log log = ExoLogger.getLogger((String)"wcm:XSkinService");
    private WebSchemaConfigService schemaConfigService;
    private WCMConfigurationService configurationService;
    private RepositoryService repositoryService;
    private SkinService skinService = WCMCoreUtils.getService(SkinService.class);
    private ServletContext servletContext;

    public XSkinService(LivePortalManagerService livePortalService) throws Exception {
        this.skinService.addResourceResolver((ResourceResolver)new WCMSkinResourceResolver(this.skinService, livePortalService));
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
        this.schemaConfigService = WCMCoreUtils.getService(WebSchemaConfigService.class);
        this.servletContext = WCMCoreUtils.getService(ServletContext.class);
        this.repositoryService = WCMCoreUtils.getService(RepositoryService.class);
    }

    public String getActiveStylesheet(Node webcontent) throws Exception {
        return WCMCoreUtils.getActiveStylesheet(webcontent);
    }

    public void updatePortalSkinOnModify(Node portal, Node cssFile) throws Exception {
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, cssFile, false);
        } else {
            this.addPortalSkin(portal, cssFile, false);
        }
    }

    public void updatePortalSkinOnRemove(Node portal, Node cssFile) throws Exception {
        String repository = ((ManageableRepository)portal.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal, cssFile, false);
        } else {
            this.addPortalSkin(portal, cssFile, false);
        }
    }

    private void addPortalSkin(Node portalNode, Node cssFile, boolean isStartup) throws Exception {
        String cssData = this.mergeCSSData(portalNode, cssFile, isStartup);
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        Iterator iterator = this.skinService.getAvailableSkinNames().iterator();
        if (!iterator.hasNext()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)"Default");
            this.skinService.addSkin(portalNode.getName(), "Default", skinPath, cssData);
        } else {
            while (iterator.hasNext()) {
                String skinName = (String)iterator.next();
                skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
                this.skinService.addSkin(portalNode.getName(), skinName, skinPath, cssData);
            }
        }
    }

    private void addSharedPortalSkin(Node portalNode, Node cssFile, boolean isAddNew) throws Exception {
        String cssData = this.mergeCSSData(portalNode, cssFile, isAddNew);
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.addPortalSkin(portalNode.getName(), skinName, skinPath, cssData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String mergeCSSData(Node portalNode, Node newCSSFile, boolean isStartup) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Node cssFolder = this.schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class).getCSSFolder(portalNode);
        String statement = StringUtils.replaceOnce((String)SHARED_CSS_QUERY, (String)"{path}", (String)cssFolder.getPath());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        NodeLocation portalNodeLocation = NodeLocation.getNodeLocationByNode(portalNode);
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(portalNodeLocation.getWorkspace(), repository);
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            if (isStartup) {
                while (iterator.hasNext()) {
                    Node registeredCSSFile = iterator.nextNode();
                    buffer.append(this.getActivedCSSData(registeredCSSFile));
                }
            } else if (!iterator.hasNext()) {
                buffer.append(this.getActivedCSSData(newCSSFile));
            } else {
                boolean isApplied = false;
                while (iterator.hasNext()) {
                    Node registeredCSSFile = iterator.nextNode();
                    if (newCSSFile != null) {
                        if (!isApplied && newCSSFile.getPath().equals(registeredCSSFile.getPath())) {
                            buffer.append(this.getActivedCSSData(newCSSFile));
                            isApplied = true;
                            continue;
                        }
                        long newCSSFilePriority = newCSSFile.getProperty("exo:priority").getLong();
                        long registeredCSSFilePriority = registeredCSSFile.getProperty("exo:priority").getLong();
                        if (!isApplied && newCSSFilePriority < registeredCSSFilePriority) {
                            buffer.append(this.getActivedCSSData(newCSSFile));
                            isApplied = true;
                        }
                    }
                    buffer.append(this.getActivedCSSData(registeredCSSFile));
                }
                if (!isApplied) {
                    buffer.append(this.getActivedCSSData(newCSSFile));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected problem happen when merge CSS data", (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
        return buffer.toString();
    }

    private String getActivedCSSData(Node cssFile) throws ValueFormatException, RepositoryException, PathNotFoundException {
        if (!cssFile.isNodeType("exo:restoreLocation") && cssFile.hasNode("jcr:content") && cssFile.getNode("jcr:content").hasProperty("jcr:data") && cssFile.hasProperty("exo:active") && cssFile.getProperty("exo:active").getBoolean()) {
            return cssFile.getNode("jcr:content").getProperty("jcr:data").getString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalSkin(portal, null, true);
            }
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalSkin(sharedPortal, null, true);
        }
        catch (Exception e) {
            log.error((Object)"Exception when start XSkinService", (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

