/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.itemfilters;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.ItemDataFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataNamePatternFilter
implements ItemDataFilter {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDataNamePatternFilter");
    private final SessionImpl session;
    private final List<String> expressions = new ArrayList<String>();

    public ItemDataNamePatternFilter(String namePattern, SessionImpl session) throws NamespaceException, RepositoryException {
        this.session = session;
        StringTokenizer parser = new StringTokenizer(namePattern, "|");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            this.expressions.add(token.trim());
        }
    }

    @Override
    public boolean accept(ItemData item) {
        try {
            JCRName name = this.session.getLocationFactory().createJCRName(item.getQPath().getName());
            for (String expr : this.expressions) {
                if (!this.estimate(name.getAsString(), expr)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot parse JCR name for " + item.getQPath().getAsString()), (Throwable)e);
        }
        return false;
    }

    private boolean estimate(String name, String expr) {
        if (expr.indexOf("*") == -1) {
            return name.equals(expr);
        }
        String regexp = expr.replaceAll("\\*", ".*");
        return Pattern.compile(regexp).matcher(name).matches();
    }

    @Override
    public List<? extends ItemData> accept(List<? extends ItemData> item) {
        return null;
    }
}

