/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing.explorer;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.exoplatform.swing.JExoTextEditor;
import org.exoplatform.swing.ViewPlugin;

public class OpenedFileViewPlugin
extends JDesktopPane
implements ViewPlugin {
    private Map<String, ViewFrame> frames_ = new HashMap<String, ViewFrame>();

    public OpenedFileViewPlugin() {
        this.setDragMode(1);
        this.setName("OpenFiles");
    }

    public String getTitle() {
        return "Open Files";
    }

    public void openFile(String filePath) throws Exception {
        ViewFrame frame = this.frames_.get(filePath);
        if (frame != null) {
            return;
        }
        frame = new ViewFrame(filePath);
        frame.setSize(700, 500);
        frame.setVisible(true);
        frame.setSelected(true);
        frame.toFront();
        JExoTextEditor textEditor = new JExoTextEditor();
        textEditor.opentFile(filePath);
        frame.add(textEditor);
        frame.addInternalFrameListener(new FrameEventListener());
        this.frames_.put(filePath, frame);
        this.add(frame);
    }

    public static class FrameEventListener
    implements InternalFrameListener {
        public void internalFrameActivated(InternalFrameEvent event) {
        }

        public void internalFrameClosed(InternalFrameEvent event) {
        }

        public void internalFrameClosing(InternalFrameEvent event) {
            System.out.println("Close Frame: " + event.getInternalFrame());
        }

        public void internalFrameDeactivated(InternalFrameEvent event) {
        }

        public void internalFrameDeiconified(InternalFrameEvent event) {
        }

        public void internalFrameIconified(InternalFrameEvent event) {
        }

        public void internalFrameOpened(InternalFrameEvent event) {
        }
    }

    static class ViewFrame
    extends JInternalFrame {
        public ViewFrame(String label) {
            super(label, true, true, true, true);
            this.setLocation(30, 30);
        }
    }
}

