/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.graphics.CalRGB;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.Lab;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.util.Library;

public abstract class PColorSpace
extends Dictionary {
    private static final Logger logger = Logger.getLogger(PColorSpace.class.toString());

    public abstract int getNumComponents();

    public String getDescription() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    PColorSpace(Library l, Hashtable h) {
        super(l, h);
    }

    public static PColorSpace getColorSpace(Library library, Object o) {
        if (o != null) {
            if (o instanceof Reference) {
                o = library.getObject((Reference)o);
            }
            if (o instanceof Name) {
                if (o.equals("DeviceGray") || o.equals("G")) {
                    return new DeviceGray(library, null);
                }
                if (o.equals("DeviceRGB") || o.equals("RGB")) {
                    return new DeviceRGB(library, null);
                }
                if (o.equals("DeviceCMYK") || o.equals("CMYK")) {
                    return new DeviceCMYK(library, null);
                }
                if (o.equals("Pattern")) {
                    return new PatternColor(library, null);
                }
            } else if (o instanceof Vector) {
                Vector v = (Vector)o;
                if (v.elementAt(0).equals("Indexed") || v.elementAt(0).equals("I")) {
                    return new Indexed(library, null, v);
                }
                if (v.elementAt(0).equals("CalRGB")) {
                    return new CalRGB(library, (Hashtable)v.elementAt(1));
                }
                if (v.elementAt(0).equals("Lab")) {
                    return new Lab(library, (Hashtable)v.elementAt(1));
                }
                if (v.elementAt(0).equals("Separation")) {
                    return new Separation(library, null, v.elementAt(1), v.elementAt(2), v.elementAt(3));
                }
                if (v.elementAt(0).equals("DeviceN")) {
                    return new DeviceN(library, null, v.elementAt(1), v.elementAt(2), v.elementAt(3), v.size() > 4 ? v.elementAt(4) : null);
                }
                if (v.elementAt(0).equals("ICCBased")) {
                    return library.getICCBased((Reference)v.elementAt(1));
                }
                if (v.elementAt(0).equals("DeviceRGB")) {
                    return new DeviceRGB(library, null);
                }
                if (v.elementAt(0).equals("DeviceCMYK")) {
                    return new DeviceCMYK(library, null);
                }
                if (v.elementAt(0).equals("DeviceGray")) {
                    return new DeviceRGB(library, null);
                }
                if (v.elementAt(0).equals("Pattern")) {
                    PatternColor patternColour = new PatternColor(library, null);
                    if (v.size() > 1) {
                        patternColour.setPColorSpace(PColorSpace.getColorSpace(library, v.elementAt(1)));
                    }
                    return patternColour;
                }
            } else if (o instanceof Hashtable) {
                return new PatternColor(library, (Hashtable)o);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unsupported Colorspace: " + o);
            }
        }
        return new DeviceGray(library, null);
    }

    public static PColorSpace getColorSpace(Library library, float n) {
        if (n == 3.0f) {
            return new DeviceRGB(library, null);
        }
        if (n == 4.0f) {
            return new DeviceCMYK(library, null);
        }
        return new DeviceGray(library, null);
    }

    public abstract Color getColor(float[] var1);

    public void normaliseComponentsToFloats(int[] in, float[] out, float maxval) {
        int count = this.getNumComponents();
        for (int i = 0; i < count; ++i) {
            out[i] = (float)in[i] / maxval;
        }
    }

    public static float[] reverse(float[] f) {
        float[] n = new float[f.length];
        for (int i = 0; i < f.length; ++i) {
            n[i] = f[f.length - i - 1];
        }
        return n;
    }

    public static void reverseInPlace(float[] f) {
        int num = f.length / 2;
        for (int i = 0; i < num; ++i) {
            float tmp = f[i];
            f[i] = f[f.length - 1 - i];
            f[f.length - 1 - i] = tmp;
        }
    }

    public static void reverseInPlace(int[] f) {
        int num = f.length / 2;
        for (int i = 0; i < num; ++i) {
            int tmp = f[i];
            f[i] = f[f.length - 1 - i];
            f[f.length - 1 - i] = tmp;
        }
    }
}

