/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.POIXMLPropertiesTextExtractor;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.openxml4j.util.Nullable;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DCMetaData;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class POIPropertiesReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.POIPropertiesReader");
    private final Properties props = new Properties();

    public Properties getProperties() {
        return this.props;
    }

    public Properties readDCProperties(final InputStream is) throws IOException, DocumentReadException {
        class POIRuntimeException
        extends RuntimeException {
            private Throwable ex;

            public POIRuntimeException(Throwable ex) {
                this.ex = ex;
            }

            public Throwable getException() {
                return this.ex;
            }
        }
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        POIFSReaderListener readerListener = new POIFSReaderListener(){

            public void processPOIFSReaderEvent(POIFSReaderEvent event) {
                try {
                    PropertySet ps = PropertySetFactory.create((InputStream)event.getStream());
                    if (ps instanceof SummaryInformation) {
                        SummaryInformation si = (SummaryInformation)ps;
                        if (si.getLastAuthor() != null && si.getLastAuthor().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.CONTRIBUTOR, si.getLastAuthor());
                        }
                        if (si.getComments() != null && si.getComments().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.DESCRIPTION, si.getComments());
                        }
                        if (si.getCreateDateTime() != null) {
                            POIPropertiesReader.this.props.put(DCMetaData.DATE, si.getCreateDateTime());
                        }
                        if (si.getAuthor() != null && si.getAuthor().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.CREATOR, si.getAuthor());
                        }
                        if (si.getKeywords() != null && si.getKeywords().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.SUBJECT, si.getKeywords());
                        }
                        if (si.getLastSaveDateTime() != null) {
                            POIPropertiesReader.this.props.put(DCMetaData.DATE, si.getLastSaveDateTime());
                        }
                        if (si.getSubject() != null && si.getSubject().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.SUBJECT, si.getSubject());
                        }
                        if (si.getTitle() != null && si.getTitle().length() > 0) {
                            POIPropertiesReader.this.props.put(DCMetaData.TITLE, si.getTitle());
                        }
                    }
                }
                catch (NoPropertySetStreamException e) {
                    throw new POIRuntimeException((Throwable)new DocumentReadException(e.getMessage(), e));
                }
                catch (MarkUnsupportedException e) {
                    throw new POIRuntimeException((Throwable)new DocumentReadException(e.getMessage(), e));
                }
                catch (UnsupportedEncodingException e) {
                    throw new POIRuntimeException((Throwable)new DocumentReadException(e.getMessage(), e));
                }
                catch (IOException e) {
                    throw new POIRuntimeException((Throwable)e);
                }
            }
        };
        try {
            final POIFSReader poiFSReader = new POIFSReader();
            poiFSReader.registerListener(readerListener, "\u0005SummaryInformation");
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    poiFSReader.read(is);
                    return null;
                }
            });
        }
        catch (POIRuntimeException e) {
            Throwable ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (DocumentReadException)ex;
        }
        finally {
            block13: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block13;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return this.props;
    }

    public Properties readDCProperties(POIXMLDocument document) throws IOException, DocumentReadException {
        POIXMLPropertiesTextExtractor extractor = new POIXMLPropertiesTextExtractor(document);
        POIXMLProperties.CoreProperties coreProperties = extractor.getCoreProperties();
        Nullable lastModifiedBy = coreProperties.getUnderlyingProperties().getLastModifiedByProperty();
        if (lastModifiedBy != null && lastModifiedBy.getValue() != null && ((String)lastModifiedBy.getValue()).length() > 0) {
            this.props.put(DCMetaData.CONTRIBUTOR, lastModifiedBy.getValue());
        }
        if (coreProperties.getDescription() != null && coreProperties.getDescription().length() > 0) {
            this.props.put(DCMetaData.DESCRIPTION, coreProperties.getDescription());
        }
        if (coreProperties.getCreated() != null) {
            this.props.put(DCMetaData.DATE, coreProperties.getCreated());
        }
        if (coreProperties.getCreator() != null && coreProperties.getCreator().length() > 0) {
            this.props.put(DCMetaData.CREATOR, coreProperties.getCreator());
        }
        if (coreProperties.getSubject() != null && coreProperties.getSubject().length() > 0) {
            this.props.put(DCMetaData.SUBJECT, coreProperties.getSubject());
        }
        if (coreProperties.getModified() != null) {
            this.props.put(DCMetaData.DATE, coreProperties.getModified());
        }
        if (coreProperties.getSubject() != null && coreProperties.getSubject().length() > 0) {
            this.props.put(DCMetaData.SUBJECT, coreProperties.getSubject());
        }
        if (coreProperties.getTitle() != null && coreProperties.getTitle().length() > 0) {
            this.props.put(DCMetaData.TITLE, coreProperties.getTitle());
        }
        return this.props;
    }
}

