/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractSelectingDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    protected AbstractSelectingDelegate(PostInsertIdentityPersister persister) {
        this.persister = persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Serializable performInsert(String insertSQL, SessionImplementor session, Binder binder) {
        try {
            PreparedStatement insert = session.getBatcher().prepareStatement(insertSQL, false);
            try {
                binder.bindValues(insert);
                insert.executeUpdate();
                Object var6_6 = null;
                session.getBatcher().closeStatement(insert);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                session.getBatcher().closeStatement(insert);
                throw throwable;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not insert: " + MessageHelper.infoString(this.persister), insertSQL);
        }
        String selectSQL = this.getSelectSQL();
        try {
            PreparedStatement idSelect = session.getBatcher().prepareStatement(selectSQL);
            try {
                Serializable serializable;
                this.bindParameters(session, idSelect, binder.getEntity());
                ResultSet rs = idSelect.executeQuery();
                try {
                    serializable = this.getResult(session, rs, binder.getEntity());
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var11_14 = null;
                session.getBatcher().closeStatement(idSelect);
                return serializable;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                session.getBatcher().closeStatement(idSelect);
                throw throwable;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve generated id after insert: " + MessageHelper.infoString(this.persister), insertSQL);
        }
    }

    protected abstract String getSelectSQL();

    protected void bindParameters(SessionImplementor session, PreparedStatement ps, Object entity) throws SQLException {
    }

    protected abstract Serializable getResult(SessionImplementor var1, ResultSet var2, Object var3) throws SQLException;
}

