/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class WriteValue
extends ValueFileOperation {
    protected final File file;
    protected final ValueData value;
    protected ValueFileOperation.ValueFileLock fileLock;

    public WriteValue(File file, ValueData value, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        super(resources, cleaner, tempDir);
        this.file = file;
        this.value = value;
    }

    public void execute() throws IOException {
        this.makePerformed();
        this.fileLock = new ValueFileOperation.ValueFileLock(this, this.file);
        this.fileLock.lock();
    }

    public void prepare() throws IOException {
        if (this.fileLock != null) {
            this.file.getParentFile().mkdirs();
            if (this.file.exists()) {
                this.cleaner.removeFile(this.file);
            }
            this.writeValue(this.file, this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        if (this.fileLock != null) {
            try {
                if (this.file.exists() && !this.file.delete()) {
                    this.cleaner.addFile(this.file);
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fileLock.unlock();
                throw throwable;
            }
            this.fileLock.unlock();
            {
            }
        }
    }

    public void twoPhaseCommit() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.unlock();
        }
    }
}

