/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public class UIFormRadioBoxInput
extends UIFormInputBase<String> {
    public static int VERTICAL_ALIGN = 1;
    public static int HORIZONTAL_ALIGN = 2;
    private List<SelectItemOption<String>> options_;
    private int align_;
    private int topRender_ = 0;

    public UIFormRadioBoxInput() {
    }

    public UIFormRadioBoxInput(String name, String value) {
        this(name, value, new ArrayList<SelectItemOption<String>>());
    }

    public UIFormRadioBoxInput(String name, String value, List<SelectItemOption<String>> options) {
        super(name, value, String.class);
        this.value_ = value;
        this.options_ = options;
        this.align_ = HORIZONTAL_ALIGN;
    }

    public final List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public final UIFormRadioBoxInput setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        return this;
    }

    public final UIFormRadioBoxInput setAlign(int val) {
        this.align_ = val;
        return this;
    }

    public final UIFormRadioBoxInput setRenderOneRadioBox() {
        this.topRender_ = 1;
        return this;
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (this.isDisabled()) {
            return;
        }
        if (input != null) {
            this.value_ = (String)input;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        int index;
        if (this.options_ == null) {
            return;
        }
        ResourceBundle res = context.getApplicationResourceBundle();
        Writer w = context.getWriter();
        if (this.value_ == null) {
            SelectItemOption<String> si = this.options_.get(0);
            this.value_ = si.getValue();
        }
        for (int i = index = 0; i < this.options_.size(); ++i) {
            SelectItemOption<String> si = this.options_.get(i);
            String inputId = this.getId() + "_" + si.getValue();
            String label = this.getId() + ".label." + si.getLabel();
            try {
                label = res.getString(label);
            }
            catch (MissingResourceException e) {
                label = si.getLabel();
            }
            if (this.align_ == VERTICAL_ALIGN) {
                w.write("<div>");
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("type", "radio");
            attributes.put("name", this.getName());
            attributes.put("class", "radio");
            attributes.put("value", si.getValue());
            if (si.getValue().equals(this.value_)) {
                attributes.put("checked", "checked");
            }
            if (this.readonly_) {
                attributes.put("readonly", "readonly");
            }
            if (this.isDisabled()) {
                attributes.put("disabled", "disabled");
            }
            this.renderInputBaseComponent(w, "input", inputId, attributes);
            w.write("<label for = \"" + inputId + "\">");
            w.write(label);
            w.write("</label>");
            if (this.align_ == VERTICAL_ALIGN) {
                w.write("</div>");
            }
            if (this.topRender_ != 1) continue;
            index = i + 1;
            if (index != this.options_.size()) break;
            index = 0;
            break;
        }
    }
}

