/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.chromattic.api.BuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInstantiator {
    public static <T> T newInstance(String className, Class<T> expectedClass) throws BuilderException {
        if (className == null) {
            throw new NullPointerException("No null class name expected");
        }
        if (expectedClass == null) {
            throw new NullPointerException("No null expected class provided");
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> loadedClass = classLoader.loadClass(className);
            if (expectedClass.isAssignableFrom(loadedClass)) {
                Class<T> expectedSubclass = loadedClass.asSubclass(expectedClass);
                return ObjectInstantiator.newInstance(expectedSubclass);
            }
            throw new BuilderException("Class " + className + " does not implement the " + expectedClass.getName() + " interface");
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException("Could not load class " + className, (Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> objectClass) throws BuilderException {
        if (objectClass == null) {
            throw new NullPointerException("No null object class provided");
        }
        try {
            if (!Modifier.isPublic(objectClass.getModifiers())) {
                throw new BuilderException("The class " + objectClass.getName() + " must be public");
            }
            if (Modifier.isAbstract(objectClass.getModifiers())) {
                throw new BuilderException("The class " + objectClass.getName() + " must not be abstract");
            }
            Constructor<T> ctor = objectClass.getConstructor(new Class[0]);
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new BuilderException("The class " + objectClass.getName() + " no arg constructor is not public");
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new BuilderException("Could not instanciate class " + objectClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuilderException("Could not instanciate class " + objectClass.getName(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BuilderException("The class " + objectClass.getName() + " does not have a no argument constructor", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BuilderException("The class " + objectClass.getName() + " construction threw an exception", e.getCause());
        }
    }
}

