/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={CopyActionListener.class})})
public class CopyManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)CopyManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void multipleCopy(String[] srcPaths, Event<UIComponent> event) throws Exception {
        for (int i = 0; i < srcPaths.length; ++i) {
            CopyManageComponent.processCopy(srcPaths[i], event, true);
        }
    }

    public static void processCopy(String srcPath, Event<?> event, boolean isMultiSelect) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            Node node = uiExplorer.getNodeByPath(srcPath, session, false);
            srcPath = node.getPath();
            session = node.getSession();
            wsName = session.getWorkspace().getName();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        try {
            LinkedList<ClipboardCommand> clipboards = uiExplorer.getAllClipBoard();
            for (ClipboardCommand command : clipboards) {
                if (!command.getSrcPath().equals(srcPath)) continue;
                clipboards.remove(command);
                break;
            }
            ClipboardCommand clipboard = new ClipboardCommand();
            clipboard.setType("copy");
            clipboard.setSrcPath(srcPath);
            clipboard.setWorkspace(wsName);
            uiExplorer.getAllClipBoard().add(clipboard);
            if (isMultiSelect) {
                uiWorkingArea.getVirtualClipboards().add(clipboard);
            }
            uiExplorer.getSession().save();
        }
        catch (ConstraintViolationException cons) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public static void copyManage(Event<UIComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        String srcPath = event.getRequestContext().getRequestParameter("objectId");
        uiWorkingArea.getVirtualClipboards().clear();
        if (srcPath.indexOf(";") > -1) {
            CopyManageComponent.multipleCopy(srcPath.split(";"), event);
        } else {
            CopyManageComponent.processCopy(srcPath, event, false);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyActionListener
    extends UIWorkingAreaActionListener<CopyManageComponent> {
        public void processEvent(Event<CopyManageComponent> event) throws Exception {
            Event event_ = new Event(event.getSource(), event.getName(), event.getRequestContext());
            CopyManageComponent.copyManage((Event<UIComponent>)event_);
        }
    }
}

