/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GadgetUriFetcher
implements UriFetcher {
    private final MessageContext mc;
    private final Map<? super InputSource, ? super CharSequence> originalSources;

    GadgetUriFetcher(MessageContext mc, Map<? super InputSource, ? super CharSequence> originalSources) {
        this.mc = mc;
        this.originalSources = originalSources;
    }

    @Override
    public FetchedData fetch(ExternalReference extref, String mimeType) throws UriFetcher.UriFetchException {
        FetchedData data;
        URI uri = extref.getUri();
        InputSource is = new InputSource(uri);
        try {
            data = FetchedData.fromConnection(uri.toURL().openConnection());
        }
        catch (IOException ex) {
            throw new UriFetcher.UriFetchException(extref, mimeType, ex);
        }
        try {
            CharProducer resource = data.getTextualContent();
            this.originalSources.put(is, resource.toString(resource.getOffset(), resource.getLength()));
            this.mc.addInputSource(is);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return data;
    }
}

