/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.css;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import java.io.IOException;
import java.util.Arrays;

public class CssPropertySignatureTest
extends CajaTestCase {
    public final void testParser1() {
        this.assertParseTree("<length> <length>? | inherit", "SetSignature", "  SeriesSignature", "    SymbolSignature : length", "    RepeatedSignature : [0, 1]", "      SymbolSignature : length", "  LiteralSignature : inherit");
    }

    public final void testParser2() {
        this.assertParseTree("<border-style>{1,4} | inherit", "SetSignature", "  RepeatedSignature : [1, 4]", "    SymbolSignature : border-style", "  LiteralSignature : inherit");
    }

    public final void testParser3() {
        this.assertParseTree("[ <border-width> || <border-style> || 'border-top-color' ] | inherit", "SetSignature", "  RepeatedSignature : [1, 3]", "    ExclusiveSetSignature", "      SymbolSignature : border-width", "      SymbolSignature : border-style", "      PropertyRefSignature : border-top-color", "  LiteralSignature : inherit");
    }

    public final void testParser4() {
        this.assertParseTree("[ [ <percentage> | <length> | left | center | right ] [ <percentage> | <length> | top | center | bottom ]? ] | [ [ left | center | right ] || [ top | center | bottom ] ] | inherit", "SetSignature", "  SeriesSignature", "    SetSignature", "      SymbolSignature : percentage", "      SymbolSignature : length", "      LiteralSignature : left", "      LiteralSignature : center", "      LiteralSignature : right", "    RepeatedSignature : [0, 1]", "      SetSignature", "        SymbolSignature : percentage", "        SymbolSignature : length", "        LiteralSignature : top", "        LiteralSignature : center", "        LiteralSignature : bottom", "  RepeatedSignature : [1, 2]", "    ExclusiveSetSignature", "      SetSignature", "        LiteralSignature : left", "        LiteralSignature : center", "        LiteralSignature : right", "      SetSignature", "        LiteralSignature : top", "        LiteralSignature : center", "        LiteralSignature : bottom", "  LiteralSignature : inherit");
    }

    public final void testParser5() {
        this.assertParseTree("[ [<uri> ,]* [ auto | crosshair | default | pointer | move | e-resize | ne-resize | nw-resize | n-resize | se-resize | sw-resize | s-resize | w-resize | text | wait | help | progress ] ] | inherit", "SetSignature", "  SeriesSignature", "    RepeatedSignature : [0, 2147483647]", "      SeriesSignature", "        SymbolSignature : uri", "        LiteralSignature : ,", "    SetSignature", "      LiteralSignature : auto", "      LiteralSignature : crosshair", "      LiteralSignature : default", "      LiteralSignature : pointer", "      LiteralSignature : move", "      LiteralSignature : e-resize", "      LiteralSignature : ne-resize", "      LiteralSignature : nw-resize", "      LiteralSignature : n-resize", "      LiteralSignature : se-resize", "      LiteralSignature : sw-resize", "      LiteralSignature : s-resize", "      LiteralSignature : w-resize", "      LiteralSignature : text", "      LiteralSignature : wait", "      LiteralSignature : help", "      LiteralSignature : progress", "  LiteralSignature : inherit");
    }

    public final void testParser6() {
        this.assertParseTree("rect(<top>, <right>, <bottom>, <left>)", "CallSignature", "  LiteralSignature : rect", "  SeriesSignature", "    SymbolSignature : top", "    LiteralSignature : ,", "    SymbolSignature : right", "    LiteralSignature : ,", "    SymbolSignature : bottom", "    LiteralSignature : ,", "    SymbolSignature : left");
    }

    public final void testParseProgId() {
        this.assertParseTree("progid:foo.bar(baz=<number>, enabled=[\"true\" | \"false\"])", "ProgIdSignature : foo.bar", "  ProgIdAttrSignature : baz", "    SymbolSignature : number", "  ProgIdAttrSignature : enabled", "    SetSignature", "      QuotedLiteralSignature : true", "      QuotedLiteralSignature : false");
    }

    private static CssPropertySignature sig(String sig) {
        return CssPropertySignature.Parser.parseSignature(sig);
    }

    private void assertParseTree(String sig, String ... golden) {
        StringBuilder actual = new StringBuilder();
        try {
            CssPropertySignatureTest.sig(sig).formatTree(this.mc, 0, actual);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("Unexpected assertion failure", (Throwable)ex);
        }
        MoreAsserts.assertListsEqual(Arrays.asList(golden), Arrays.asList(actual.toString().split("\n")));
    }
}

