/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.plugin.CssRewriter;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.plugin.UriPolicyHintKey;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Name;
import com.google.caja.util.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CssRewriterTest
extends CajaTestCase {
    public final void testUnknownTagsRemoved() throws Exception {
        this.runTest("bogus { display: none }", "");
        this.runTest("a, bogus, i { display: none }", "a, i {\n  display: none\n}");
    }

    public final void testBadTagsRemoved() throws Exception {
        this.runTest("script { display: none }", "");
        this.assertMessage(true, PluginMessageType.UNSAFE_TAG, MessageLevel.ERROR, ElKey.forElement(Namespaces.HTML_DEFAULT, "script"));
        this.assertNoErrors();
        this.runTest("strike, script, strong { display: none }", "strike, strong {\n  display: none\n}");
        this.assertMessage(true, PluginMessageType.UNSAFE_TAG, MessageLevel.ERROR, ElKey.forElement(Namespaces.HTML_DEFAULT, "script"));
        this.assertNoErrors();
    }

    public final void testBadAttribsRemoved() throws Exception {
        this.runTest("div[zwop] { color: blue }", "");
    }

    public final void testInvalidPropertiesRemoved() throws Exception {
        this.runTest("a { visibility: none }", "");
        this.runTest("a { visibility: hidden; }", "a {\n  visibility: hidden\n}");
        this.runTest("a { bogus: bogus }", "");
        this.runTest("a { visibility: none; font-weight: bold }", "a {\n  font-weight: bold\n}");
        this.runTest("a { font-weight: bold; visibility: none }", "a {\n  font-weight: bold\n}");
        this.runTest("a { bogus: bogus; font-weight: bold }", "a {\n  font-weight: bold\n}");
        this.runTest("a { font-weight: bold; bogus: bogus }", "a {\n  font-weight: bold\n}");
    }

    public final void testContentRemoved() throws Exception {
        this.runTest("a { color: blue; content: 'booyah'; text-decoration: underline; }", "a {\n  color: blue;\n  text-decoration: underline\n}");
    }

    public final void testAttrRemoved() throws Exception {
        this.runTest("a:attr(href) { color: blue }", "");
        this.runTest("a:attr(href) { color: blue } b { font-weight: bolder }", "b {\n  font-weight: bolder\n}");
    }

    public final void testFontNamesQuoted() throws Exception {
        this.runTest("a { font:12pt Times  New Roman, Times,\"Times Old Roman\",serif }", "a {\n  font: 12pt 'Times New Roman', 'Times', 'Times Old Roman', serif\n}");
        this.runTest("a { font:bold 12pt Arial Black }", "a {\n  font: bold 12pt 'Arial Black'\n}");
    }

    public final void testNamespacing() throws Exception {
        this.runTest("a.foo { color:blue }", "a.foo {\n  color: blue\n}");
        this.runTest("#foo { color: blue }", "#foo {\n  color: blue\n}");
        this.runTest("body.ie6 p { color: blue }", "body.ie6 p {\n  color: blue\n}");
        this.runTest("body { margin: 0; }", "");
        this.runTest("body.ie6 { margin: 0; }", "");
        this.runTest("* html p { margin: 0; }", "* html p {\n  margin: 0\n}");
        this.runTest("* html { margin: 0; }", "");
        this.runTest("* html > * > p { margin: 0; }", "");
        this.runTest("#foo > #bar { color: blue }", "#foo > #bar {\n  color: blue\n}");
        this.runTest("#foo .bar { color: blue }", "#foo .bar {\n  color: blue\n}");
    }

    public final void testUnsafeIdentifiers() throws Exception {
        this.runTest("a.foo, b#c\\2c d, .e { color:blue }", "a.foo, .e {\n  color: blue\n}");
        this.runTest("a.foo, .b_c {color: blue}", "a.foo, .b_c {\n  color: blue\n}");
        this.runTest("a.foo, ._c {color: blue}", "a.foo {\n  color: blue\n}");
        this.runTest("a._c {_color: blue; margin:0;}", "");
        this.runTest("a#_c {_color: blue; margin:0;}", "");
        this.runTest(".c__ {_color: blue; margin:0;}", "");
        this.runTest("#c__ {_color: blue; margin:0;}", "");
    }

    public final void testPseudosWhitelisted() throws Exception {
        this.runTest("a:link, a:badness { color:blue }", "a:link {\n  color: blue\n}");
        this.mq.getMessages().clear();
        this.runTest("a:visited { color:blue }", "a:visited {\n  color: blue\n}");
        this.assertNoErrors();
        this.mq.getMessages().clear();
        this.runTest("a:visited { color:blue; float:left; _float:left; *float:left }", "a:visited {\n  color: blue\n}");
        this.assertMessage(PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 25, 25, 5), Name.css("float"), FilePosition.instance(this.is, 1, 1, 1, 9));
        this.assertMessage(PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 37, 37, 6), Name.css("_float"), FilePosition.instance(this.is, 1, 1, 1, 9));
        this.assertMessage(PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 51, 51, 5), Name.css("float"), FilePosition.instance(this.is, 1, 1, 1, 9));
        this.runTest("a:visited { COLOR:blue; FLOAT:left; _FLOAT:left; *FLOAT:left }", "a:visited {\n  color: blue\n}");
        this.runTest("*:visited { color: blue; }", "a:visited {\n  color: blue\n}");
        this.runTest("#foo:visited { color: blue; }", "a#foo:visited {\n  color: blue\n}");
        this.runTest(".foo:link { color: blue; }", "a.foo:link {\n  color: blue\n}");
        this.runTest("#foo:visited, div, .bar:link, p {\n  padding: 1px;\n  color: blue;\n}", "a#foo:visited, a.bar:link {\n  color: blue\n}\ndiv, p {\n  padding: 1px;\n  color: blue\n}");
        this.runTest("a#foo-bank {  background: 'http://whitelisted-host.com/?bank=X&u=Al';  color: purple}", "a#foo-bank {\n  background: url('http://whitelisted-host.com/?bank=X&u=Al');\n  color: purple\n}");
        this.mq.getMessages().clear();
        this.runTest("a#foo-bank:visited {  background-image: 'http://whitelisted-host.com/?bank=X&u=Al';  color: purple}", "a#foo-bank:visited {\n  color: purple\n}");
    }

    public final void testNoBadUrls() throws Exception {
        this.runTest("#foo { background: url(/bar.png) }", "#foo {\n  background: url('/foo/bar.png')\n}");
        this.runTest("#foo { background: url('/bar.png') }", "#foo {\n  background: url('/foo/bar.png')\n}");
        this.runTest("#foo { background: '/bar.png' }", "#foo {\n  background: url('/foo/bar.png')\n}");
        this.runTest("#foo { background: 'http://whitelisted-host.com/blinky.gif' }", "#foo {\n  background: url('http://whitelisted-host.com/blinky.gif')\n}");
        this.runTest("#foo { background: url('http://cnn.com/bar.png') }", "");
        this.runTest("#foo { background: 'http://cnn.com/bar.png' }", "");
    }

    public final void testSubstitutions() throws Exception {
        try {
            this.runTest("#foo { left: ${x * 4}px; top: ${y * 4}px; }", "", false);
            CssRewriterTest.fail((String)"allowed substitutions when parsing of substitutions disabled");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.runTest("#foo { left: ${x * 4}px; top: ${y * 4}px; }", "#foo {\n  left: ${x * 4}px;\n  top: ${y * 4}px\n}", true);
    }

    public final void testWildcardSelectors() throws Exception {
        this.runTest("div * { margin: 0; }", "div * {\n  margin: 0\n}", false);
    }

    public final void testUnitlessLengths() throws Exception {
        this.runTest("div { padding: 10 0 5.0 4 }", "div {\n  padding: 10px 0 5.0px 4px\n}", false);
        this.runTest("div { margin: -5 5; z-index: 2 }", "div {\n  margin: -5px 5px;\n  z-index: 2\n}", false);
    }

    public final void testUserAgentHacks() throws Exception {
        this.runTest("p {\n  color: blue;\n  *color: red;\n  background-color: green;\n  *background-color: yelow;\n  font-weight: bold\n}", "p {\n  color: blue;\n  *color: red;\n  background-color: green;\n  font-weight: bold\n}");
        this.assertMessage(PluginMessageType.MALFORMED_CSS_PROPERTY_VALUE, MessageLevel.WARNING, Name.css("background-color"), MessagePart.Factory.valueOf("==>yelow<=="));
        this.runTest("a.c {_color: blue; margin:0;}", "a.c {\n  _color: blue;\n  margin: 0\n}");
        this.assertNoErrors();
    }

    public final void testNonStandardColors() throws Exception {
        this.runTest("a.c { color: LightSlateGray; background: ivory; }", "a.c {\n  color: #789;\n  background: #fffff0\n}");
        this.assertMessage(PluginMessageType.NON_STANDARD_COLOR, MessageLevel.LINT, Name.css("lightslategray"), MessagePart.Factory.valueOf("#789"));
        this.assertMessage(PluginMessageType.NON_STANDARD_COLOR, MessageLevel.LINT, Name.css("ivory"), MessagePart.Factory.valueOf("#fffff0"));
        this.assertNoErrors();
        FilePosition u = FilePosition.UNKNOWN;
        CssRewriterTest.assertNull((Object)CssRewriter.colorHash(u, Name.css("invisible")));
        CssRewriterTest.assertEquals((String)"#00f", (String)CssRewriter.colorHash(u, Name.css("blue")).getValue());
        CssRewriterTest.assertEquals((String)"#00f", (String)CssRewriter.colorHash(u, Name.css("Blue")).getValue());
        CssRewriterTest.assertEquals((String)"#00f", (String)CssRewriter.colorHash(u, Name.css("BLUE")).getValue());
        CssRewriterTest.assertEquals((String)"#000", (String)CssRewriter.colorHash(u, 0).getValue());
        CssRewriterTest.assertEquals((String)"#fff", (String)CssRewriter.colorHash(u, 0xFFFFFF).getValue());
        CssRewriterTest.assertEquals((String)"#123", (String)CssRewriter.colorHash(u, 0x112233).getValue());
        CssRewriterTest.assertEquals((String)"#022233", (String)CssRewriter.colorHash(u, 139827).getValue());
        CssRewriterTest.assertEquals((String)"#111333", (String)CssRewriter.colorHash(u, 0x111333).getValue());
        CssRewriterTest.assertEquals((String)"#112220", (String)CssRewriter.colorHash(u, 0x112220).getValue());
    }

    public final void testFixedPositioning() throws Exception {
        this.runTest("#foo { position: absolute; left: 0px; top: 0px }", "#foo {\n  position: absolute;\n  left: 0px;\n  top: 0px\n}");
        this.assertNoErrors();
        this.runTest("#foo { position: fixed; left: 0px; top: 0px }", "#foo {\n  left: 0px;\n  top: 0px\n}");
        this.assertMessage(true, PluginMessageType.MALFORMED_CSS_PROPERTY_VALUE, MessageLevel.WARNING, Name.css("position"), MessagePart.Factory.valueOf("==>fixed<=="));
        this.assertNoErrors();
    }

    public final void testUrisCalledWithProperPropertyPart() throws Exception {
        this.assertCallsUriRewriterWithPropertyPart("background: 'foo.png'", "background::bg-image::image");
        this.assertCallsUriRewriterWithPropertyPart("img.trans {  filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(      src='bar.png', sizingMethod='image');}", "filter::prog-id::prog-id-alpha-image-loader::page-url");
    }

    private void runTest(String css, String golden) throws Exception {
        this.runTest(css, golden, false);
    }

    private void runTest(String css, String golden, boolean allowSubstitutions) throws Exception {
        this.mq.getMessages().clear();
        this.mc.relevantKeys = Collections.singleton(CssValidator.INVALID);
        CssTree.StyleSheet t = this.css(this.fromString(css), allowSubstitutions);
        StringBuilder msgBuf = new StringBuilder();
        t.formatTree(this.mc, 0, msgBuf);
        String msg = msgBuf.toString();
        CssSchema cssSchema = CssSchema.getDefaultCss21Schema(this.mq);
        new CssValidator(cssSchema, HtmlSchema.getDefault(this.mq), this.mq).validateCss(AncestorChain.instance(t));
        new CssRewriter(new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference ref, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                URI uri = ref.getUri();
                if ("test".equals(uri.getScheme()) && "example.org".equals(uri.getHost()) && uri.getPath() != null && uri.getPath().startsWith("/")) {
                    try {
                        return new URI(null, null, "/foo" + uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
                if ("whitelisted-host.com".equals(uri.getHost())) {
                    return uri.toString();
                }
                return null;
            }
        }, cssSchema, this.mq).rewrite(AncestorChain.instance(t));
        StringBuilder msgBuf2 = new StringBuilder();
        t.formatTree(this.mc, 0, msgBuf2);
        msg = msg + "\n  ->\n" + msgBuf2.toString();
        CssRewriterTest.assertEquals((String)msg, (String)golden, (String)CssRewriterTest.render(t));
    }

    private void assertCallsUriRewriterWithPropertyPart(String cssCode, String ... expectedParts) throws ParseException {
        final Set propertyParts = Sets.newLinkedHashSet();
        CssTree t = cssCode.trim().endsWith("}") ? this.css(this.fromString(cssCode)) : this.cssDecls(this.fromString(cssCode));
        CssSchema cssSchema = CssSchema.getDefaultCss21Schema(this.mq);
        new CssValidator(cssSchema, HtmlSchema.getDefault(this.mq), this.mq).validateCss(AncestorChain.instance(t));
        new CssRewriter(new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference ref, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                propertyParts.add(UriPolicyHintKey.CSS_PROP.valueFrom(hints).getCanonicalForm());
                return ref.getUri().toString();
            }
        }, cssSchema, this.mq).rewrite(AncestorChain.instance(t));
        MoreAsserts.assertListsEqual(Arrays.asList(expectedParts), Lists.newArrayList(propertyParts));
    }
}

