/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.PunctuationTrie;
import com.google.caja.render.TokenClassification;
import java.util.ArrayList;
import java.util.TreeMap;

final class JsTokenAdjacencyChecker {
    private PunctuationTrie<?> trie = START_TRIE;
    private TokenClassification lastClass;
    private String lastToken;
    private static final PunctuationTrie<?> START_TRIE;

    JsTokenAdjacencyChecker() {
    }

    boolean needSpaceBefore(String text) {
        TokenClassification tClass = TokenClassification.classify(text);
        switch (tClass) {
            case LINEBREAK: 
            case SPACE: 
            case COMMENT: {
                return false;
            }
        }
        boolean spaceBefore = false;
        if (tClass == TokenClassification.PUNCTUATION) {
            if (this.lastClass == TokenClassification.PUNCTUATION) {
                if (this.trie == null) {
                    this.trie = START_TRIE.lookup(text);
                } else {
                    int n = text.length();
                    for (int i = 0; i < n; ++i) {
                        this.trie = this.trie.lookup(text.charAt(i));
                        if (this.trie == null) break;
                        if (!this.trie.isTerminal()) continue;
                        spaceBefore = true;
                        break;
                    }
                    if (spaceBefore || this.trie == null) {
                        this.trie = START_TRIE.lookup(text);
                    }
                }
            } else {
                if (this.lastClass == TokenClassification.REGEX && this.lastToken.endsWith("/") && (text.startsWith("*") || text.startsWith("/"))) {
                    spaceBefore = true;
                } else if (this.lastClass == TokenClassification.OTHER && text.startsWith(".") && Character.isDigit(this.lastToken.charAt(this.lastToken.length() - 1))) {
                    spaceBefore = true;
                }
                this.trie = START_TRIE.lookup(text);
            }
        } else if (tClass == this.lastClass) {
            spaceBefore = true;
        } else if (this.lastClass == TokenClassification.REGEX) {
            if (tClass == TokenClassification.OTHER || "/".equals(text)) {
                spaceBefore = true;
            }
        } else if (tClass == TokenClassification.REGEX && this.lastToken != null && ("/".equals(this.lastToken) || this.lastToken.endsWith("<"))) {
            spaceBefore = true;
        } else if (tClass == TokenClassification.OTHER && Character.isDigit(text.charAt(0)) && this.lastToken != null && this.lastToken.endsWith(".")) {
            spaceBefore = true;
        }
        this.lastClass = tClass;
        this.lastToken = text;
        return spaceBefore;
    }

    static {
        ArrayList<String> punctuationStrings = new ArrayList<String>();
        JsLexer.getPunctuationTrie().toStringList(punctuationStrings);
        punctuationStrings.add("<!");
        punctuationStrings.add("-->");
        punctuationStrings.add("]>");
        punctuationStrings.add("//");
        punctuationStrings.add("/*");
        TreeMap<String, Object> punctuation = new TreeMap<String, Object>();
        for (String p : punctuationStrings) {
            punctuation.put(p, null);
        }
        START_TRIE = new PunctuationTrie(punctuation);
    }
}

