/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.naming.NamingException;
import org.exoplatform.frameworks.jcr.cli.ParameterNotFoundException;
import org.exoplatform.frameworks.jcr.command.BasicAppContext;
import org.exoplatform.services.jcr.core.ManageableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliAppContext
extends BasicAppContext {
    protected final String currentItemKey = "CURRENT_ITEM";
    protected final String parametersKey;
    protected final String outputKey = "OUTPUT";

    public CliAppContext(ManageableRepository rep, String parametersKey) throws NamingException {
        super(rep);
        this.parametersKey = parametersKey;
    }

    @Deprecated
    public CliAppContext(ManageableRepository rep, String parametersKey, Credentials cred) throws NamingException {
        super(rep);
        this.parametersKey = parametersKey;
    }

    public String getUserName() {
        try {
            return this.getSession().getUserID();
        }
        catch (Exception e) {
            LOG.error((Object)("GetUserName error: " + e));
            return "Undefined";
        }
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public List<String> getParameters() {
        return (List)this.get(this.parametersKey);
    }

    public String getParameter(int index) throws ParameterNotFoundException {
        List<String> params = this.getParameters();
        if (params.size() <= index) {
            throw new ParameterNotFoundException("Not enough number of parameters expected at least: " + (index + 1) + " found: " + params.size());
        }
        return params.get(index);
    }

    public void setCurrentItem(Item item) {
        this.put("CURRENT_ITEM", item);
    }

    public Item getCurrentItem() {
        return (Item)this.get("CURRENT_ITEM");
    }

    public String getOutput() {
        return (String)this.get("OUTPUT");
    }

    public void setOutput(String output) {
        this.put("OUTPUT", output);
    }

    public void clearOutput() {
        this.put("OUTPUT", "");
    }
}

