/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.util.JAXBResult;
import javax.xml.bind.util.JAXBSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.ClosableByteArrayOutputStream;
import org.hsqldb.lib.StringConverter;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JDBCSQLXML
implements SQLXML {
    private static String domFeatures = "XML 3.0 Traversal +Events 2.0";
    private static DOMImplementation domImplementation;
    private static DOMImplementationRegistry domImplementationRegistry;
    private static ThreadPoolExecutor executorService;
    private static Transformer identityTransformer;
    private static TransformerFactory transformerFactory;
    private static final Charset utf8Charset;
    private static ArrayBlockingQueue<Runnable> workQueue;
    private SAX2DOMBuilder builder;
    private boolean closed;
    private volatile byte[] gzdata;
    private InputStream inputStream;
    private ClosableByteArrayOutputStream outputStream;
    private DOMResult domResult;
    private String publicId;
    private boolean readable;
    private String systemId;
    private boolean writable;

    protected JDBCSQLXML() {
        this.setReadable(false);
        this.setWritable(true);
    }

    protected JDBCSQLXML(byte[] byArray) throws SQLException {
        this(byArray, null);
    }

    protected JDBCSQLXML(char[] cArray) throws SQLException {
        this(cArray, 0, cArray.length, null);
    }

    protected JDBCSQLXML(Document document) throws SQLException {
        this(new DOMSource(document));
    }

    protected JDBCSQLXML(InputStream inputStream) throws SQLException {
        this(inputStream, null);
    }

    protected JDBCSQLXML(Reader reader) throws SQLException {
        this(reader, null);
    }

    public JDBCSQLXML(Source source) throws SQLException {
        this.init(source);
    }

    protected JDBCSQLXML(String string) throws SQLException {
        this(new StreamSource(new StringReader(string)));
    }

    protected JDBCSQLXML(byte[] byArray, String string) throws SQLException {
        this(new StreamSource(new ByteArrayInputStream(byArray), string));
    }

    protected JDBCSQLXML(char[] cArray, String string) throws SQLException {
        this(cArray, 0, cArray.length, string);
    }

    protected JDBCSQLXML(InputStream inputStream, String string) throws SQLException {
        this(new StreamSource(inputStream, string));
    }

    protected JDBCSQLXML(Reader reader, String string) throws SQLException {
        this(new StreamSource(reader, string));
    }

    protected JDBCSQLXML(String string, String string2) throws SQLException {
        this(new StreamSource(new StringReader(string), string2));
    }

    protected JDBCSQLXML(byte[] byArray, boolean bl, String string, String string2) throws SQLException {
        this.setGZipData(bl ? (byte[])byArray.clone() : byArray);
        this.systemId = string;
        this.publicId = string2;
    }

    protected JDBCSQLXML(char[] cArray, int n, int n2, String string) throws SQLException {
        this(new StreamSource(new CharArrayReader(cArray, n, n2), string));
    }

    @Override
    public void free() throws SQLException {
        this.close();
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkReadable();
        InputStream inputStream = this.getBinaryStreamImpl();
        this.setReadable(false);
        this.setWritable(false);
        return inputStream;
    }

    @Override
    public synchronized OutputStream setBinaryStream() throws SQLException {
        this.checkClosed();
        this.checkWritable();
        OutputStream outputStream = this.setBinaryStreamImpl();
        this.setWritable(false);
        this.setReadable(true);
        return outputStream;
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkReadable();
        Reader reader = this.getCharacterStreamImpl();
        this.setReadable(false);
        this.setWritable(false);
        return reader;
    }

    @Override
    public synchronized Writer setCharacterStream() throws SQLException {
        this.checkClosed();
        this.checkWritable();
        Writer writer = this.setCharacterStreamImpl();
        this.setReadable(true);
        this.setWritable(false);
        return writer;
    }

    @Override
    public synchronized String getString() throws SQLException {
        this.checkClosed();
        this.checkReadable();
        String string = this.getStringImpl();
        this.setReadable(false);
        this.setWritable(false);
        return string;
    }

    @Override
    public synchronized void setString(String string) throws SQLException {
        if (string == null) {
            throw Util.nullArgument("value");
        }
        this.checkWritable();
        this.setStringImpl(string);
        this.setReadable(true);
        this.setWritable(false);
    }

    @Override
    public synchronized <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkReadable();
        T t = this.getSourceImpl(clazz);
        this.setReadable(false);
        this.setWritable(false);
        return t;
    }

    @Override
    public synchronized <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        this.checkClosed();
        this.checkWritable();
        T t = this.createResult(clazz);
        this.setReadable(true);
        this.setWritable(false);
        return t;
    }

    protected static ExecutorService getExecutorService() {
        if (executorService == null) {
            int n = 1;
            int n2 = 10;
            long l = 1L;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            workQueue = new ArrayBlockingQueue(10);
            executorService = new ThreadPoolExecutor(n, n2, l, timeUnit, workQueue);
        }
        return executorService;
    }

    protected static TransformerFactory getTransformerFactory() throws SQLException {
        if (transformerFactory == null) {
            try {
                transformerFactory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw Exceptions.transformFailed(transformerFactoryConfigurationError);
            }
        }
        return transformerFactory;
    }

    protected static Transformer getIdentityTransformer() throws SQLException {
        if (identityTransformer == null) {
            try {
                identityTransformer = JDBCSQLXML.getTransformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw Exceptions.transformFailed(transformerConfigurationException);
            }
        }
        return identityTransformer;
    }

    protected static DOMImplementationRegistry getDOMImplementationRegistry() throws SQLException {
        if (domImplementationRegistry == null) {
            try {
                domImplementationRegistry = DOMImplementationRegistry.newInstance();
            }
            catch (ClassCastException classCastException) {
                throw Exceptions.domInstantiation(classCastException);
            }
            catch (InstantiationException instantiationException) {
                throw Exceptions.domInstantiation(instantiationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw Exceptions.domInstantiation(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Exceptions.domInstantiation(illegalAccessException);
            }
        }
        return domImplementationRegistry;
    }

    protected static DOMImplementation getDOMImplementation() throws SQLException {
        if (domImplementation == null) {
            domImplementation = JDBCSQLXML.getDOMImplementationRegistry().getDOMImplementation(domFeatures);
        }
        if (domImplementation == null) {
            RuntimeException runtimeException = new RuntimeException("Not supported: " + domFeatures);
            throw Exceptions.domInstantiation(runtimeException);
        }
        return domImplementation;
    }

    protected static Document createDocument(String string, String string2, DocumentType documentType) throws SQLException {
        try {
            return JDBCSQLXML.getDOMImplementation().createDocument(string, string2, documentType);
        }
        catch (DOMException dOMException) {
            throw Exceptions.domInstantiation(dOMException);
        }
    }

    protected static Document createDocument() throws SQLException {
        return JDBCSQLXML.createDocument(null, null, null);
    }

    protected void init(Source source) throws SQLException {
        GZIPOutputStream gZIPOutputStream;
        if (source == null) {
            throw Util.nullArgument("source");
        }
        Transformer transformer = JDBCSQLXML.getIdentityTransformer();
        StreamResult streamResult = new StreamResult();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw Exceptions.transformFailed(iOException);
        }
        streamResult.setOutputStream(gZIPOutputStream);
        try {
            transformer.transform(source, streamResult);
        }
        catch (TransformerException transformerException) {
            throw Exceptions.transformFailed(transformerException);
        }
        try {
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            throw Exceptions.transformFailed(iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.setGZipData(byArray);
        this.setReadable(true);
        this.setWritable(false);
    }

    protected void setGZipData(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw Util.nullArgument("data");
        }
        this.gzdata = byArray;
    }

    protected byte[] gZipData() {
        return this.gzdata;
    }

    protected byte[] getGZipData() throws SQLException {
        Object object;
        byte[] byArray = this.gZipData();
        if (byArray != null) {
            return byArray;
        }
        if (this.domResult != null) {
            object = new DOMSource(this.domResult.getNode(), this.domResult.getSystemId());
            OutputStream outputStream = this.setBinaryStreamImpl();
            StreamResult streamResult = new StreamResult(outputStream);
            try {
                identityTransformer.transform((Source)object, streamResult);
            }
            catch (TransformerException transformerException) {
                throw Exceptions.transformFailed(transformerException);
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw Exceptions.transformFailed(iOException);
            }
        }
        if (this.outputStream == null) {
            throw Exceptions.notReadable("No Data.");
        }
        if (!this.outputStream.isClosed()) {
            throw Exceptions.notReadable("Stream used for writing must be closed but is still open.");
        }
        if (this.outputStream.isFreed()) {
            throw Exceptions.notReadable("Stream used for writing was freed and is no longer valid.");
        }
        try {
            this.setGZipData(this.outputStream.toByteArray());
            object = this.gZipData();
            return object;
        }
        catch (IOException iOException) {
            throw Exceptions.notReadable();
        }
        finally {
            this.freeOutputStream();
        }
    }

    protected synchronized void close() {
        this.closed = true;
        this.setReadable(false);
        this.setWritable(false);
        this.freeOutputStream();
        this.freeInputStream();
        this.freeDomResult();
        this.gzdata = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeInputStream() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inputStream = null;
            }
        }
    }

    protected void freeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.free();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.closed) {
            throw Exceptions.inFreedState();
        }
    }

    protected synchronized void checkReadable() throws SQLException {
        if (!this.isReadable()) {
            throw Exceptions.notReadable();
        }
    }

    protected synchronized void setReadable(boolean bl) {
        this.readable = bl;
    }

    protected synchronized void checkWritable() throws SQLException {
        if (!this.isWritable()) {
            throw Exceptions.notWritable();
        }
    }

    protected synchronized void setWritable(boolean bl) {
        this.writable = bl;
    }

    public synchronized boolean isReadable() {
        return this.readable;
    }

    public synchronized boolean isWritable() {
        return this.writable;
    }

    protected InputStream getBinaryStreamImpl() throws SQLException {
        try {
            byte[] byArray = this.getGZipData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return new GZIPInputStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw Exceptions.transformFailed(iOException);
        }
    }

    protected Reader getCharacterStreamImpl() throws SQLException {
        return new InputStreamReader(this.getBinaryStreamImpl());
    }

    protected String getStringImpl() throws SQLException {
        try {
            return StringConverter.inputStreamToString(this.getBinaryStreamImpl(), "US-ASCII");
        }
        catch (IOException iOException) {
            throw Exceptions.transformFailed(iOException);
        }
    }

    protected OutputStream setBinaryStreamImpl() throws SQLException {
        this.outputStream = new ClosableByteArrayOutputStream();
        try {
            return new GZIPOutputStream(this.outputStream);
        }
        catch (IOException iOException) {
            this.outputStream = null;
            throw Exceptions.resultInstantiation(iOException);
        }
    }

    protected Writer setCharacterStreamImpl() throws SQLException {
        return new OutputStreamWriter(this.setBinaryStreamImpl());
    }

    protected void setStringImpl(String string) throws SQLException {
        this.init(new StreamSource(new StringReader(string)));
    }

    protected <T extends Source> T getSourceImpl(Class<T> clazz) throws SQLException {
        if (!JAXBSource.class.isAssignableFrom(clazz)) {
            if (StreamSource.class.isAssignableFrom(clazz)) {
                return this.createStreamSource(clazz);
            }
            if (clazz == null || DOMSource.class.isAssignableFrom(clazz)) {
                return this.createDOMSource(clazz);
            }
            if (SAXSource.class.isAssignableFrom(clazz)) {
                return this.createSAXSource(clazz);
            }
            if (StAXSource.class.isAssignableFrom(clazz)) {
                return this.createStAXSource(clazz);
            }
        }
        throw Util.invalidArgument("sourceClass: " + clazz);
    }

    protected <T extends Source> T createStreamSource(Class<T> clazz) throws SQLException {
        StreamSource streamSource = null;
        try {
            streamSource = clazz == null ? new StreamSource() : (StreamSource)clazz.newInstance();
        }
        catch (SecurityException securityException) {
            throw Exceptions.sourceInstantiation(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.sourceInstantiation(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.sourceInstantiation(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.sourceInstantiation(classCastException);
        }
        Reader reader = this.getCharacterStreamImpl();
        streamSource.setReader(reader);
        return (T)streamSource;
    }

    protected <T extends Source> T createDOMSource(Class<T> clazz) throws SQLException {
        DOMSource dOMSource = null;
        try {
            dOMSource = clazz == null ? new DOMSource() : (DOMSource)clazz.newInstance();
        }
        catch (SecurityException securityException) {
            throw Exceptions.sourceInstantiation(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.sourceInstantiation(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.sourceInstantiation(instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.sourceInstantiation(classCastException);
        }
        Transformer transformer = JDBCSQLXML.getIdentityTransformer();
        InputStream inputStream = this.getBinaryStreamImpl();
        StreamSource streamSource = new StreamSource();
        DOMResult dOMResult = new DOMResult();
        streamSource.setInputStream(inputStream);
        try {
            transformer.transform(streamSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw Exceptions.transformFailed(transformerException);
        }
        dOMSource.setNode(dOMResult.getNode());
        dOMSource.setSystemId(dOMResult.getSystemId());
        return (T)dOMSource;
    }

    protected <T extends Source> T createSAXSource(Class<T> clazz) throws SQLException {
        SAXSource sAXSource = null;
        try {
            sAXSource = clazz == null ? new SAXSource() : (SAXSource)clazz.newInstance();
        }
        catch (SecurityException securityException) {
            throw Exceptions.sourceInstantiation(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.sourceInstantiation(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.sourceInstantiation(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.sourceInstantiation(classCastException);
        }
        Reader reader = this.getCharacterStreamImpl();
        InputSource inputSource = new InputSource(reader);
        sAXSource.setInputSource(inputSource);
        return (T)sAXSource;
    }

    protected <T extends Source> T createStAXSource(Class<T> clazz) throws SQLException {
        StAXSource stAXSource = null;
        Constructor constructor = null;
        Reader reader = null;
        XMLInputFactory xMLInputFactory = null;
        XMLEventReader xMLEventReader = null;
        try {
            xMLInputFactory = XMLInputFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw Exceptions.sourceInstantiation(factoryConfigurationError);
        }
        try {
            constructor = clazz == null ? StAXSource.class.getConstructor(XMLEventReader.class) : clazz.getConstructor(XMLEventReader.class);
        }
        catch (SecurityException securityException) {
            throw Exceptions.sourceInstantiation(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Exceptions.sourceInstantiation(noSuchMethodException);
        }
        reader = this.getCharacterStreamImpl();
        try {
            xMLEventReader = xMLInputFactory.createXMLEventReader(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw Exceptions.sourceInstantiation(xMLStreamException);
        }
        try {
            stAXSource = (StAXSource)constructor.newInstance(xMLEventReader);
        }
        catch (SecurityException securityException) {
            throw Exceptions.sourceInstantiation(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Exceptions.sourceInstantiation(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.sourceInstantiation(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.sourceInstantiation(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Exceptions.sourceInstantiation(invocationTargetException.getTargetException());
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.sourceInstantiation(classCastException);
        }
        return (T)stAXSource;
    }

    protected <T extends Result> T createResult(Class<T> clazz) throws SQLException {
        this.checkWritable();
        this.setWritable(false);
        this.setReadable(true);
        if (!JAXBResult.class.isAssignableFrom(clazz)) {
            if (clazz == null || StreamResult.class.isAssignableFrom(clazz)) {
                return this.createStreamResult(clazz);
            }
            if (DOMResult.class.isAssignableFrom(clazz)) {
                return this.createDOMResult(clazz);
            }
            if (SAXResult.class.isAssignableFrom(clazz)) {
                return this.createSAXResult(clazz);
            }
            if (StAXResult.class.isAssignableFrom(clazz)) {
                return this.createStAXResult(clazz);
            }
        }
        throw Util.invalidArgument("resultClass: " + clazz);
    }

    protected <T extends Result> T createStreamResult(Class<T> clazz) throws SQLException {
        StreamResult streamResult = null;
        try {
            streamResult = clazz == null ? new StreamResult() : (StreamResult)clazz.newInstance();
        }
        catch (SecurityException securityException) {
            throw Exceptions.resultInstantiation(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.resultInstantiation(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.resultInstantiation(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.resultInstantiation(classCastException);
        }
        OutputStream outputStream = this.setBinaryStreamImpl();
        streamResult.setOutputStream(outputStream);
        return (T)streamResult;
    }

    protected <T extends Result> T createDOMResult(Class<T> clazz) throws SQLException {
        try {
            Result result;
            this.domResult = result = clazz == null ? new DOMResult() : (Result)clazz.newInstance();
            return (T)result;
        }
        catch (SecurityException securityException) {
            throw Exceptions.resultInstantiation(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.resultInstantiation(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.resultInstantiation(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.resultInstantiation(classCastException);
        }
    }

    protected <T extends Result> T createSAXResult(Class<T> clazz) throws SQLException {
        SAXResult sAXResult = null;
        try {
            sAXResult = clazz == null ? new SAXResult() : (SAXResult)clazz.newInstance();
        }
        catch (SecurityException securityException) {
            throw Exceptions.resultInstantiation(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.resultInstantiation(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.resultInstantiation(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw Exceptions.resultInstantiation(classCastException);
        }
        SAX2DOMBuilder sAX2DOMBuilder = null;
        try {
            sAX2DOMBuilder = new SAX2DOMBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw Exceptions.resultInstantiation(parserConfigurationException);
        }
        this.domResult = new DOMResult();
        sAXResult.setHandler(sAX2DOMBuilder);
        this.domResult.setNode(sAX2DOMBuilder.getDocument());
        return (T)sAXResult;
    }

    protected <T extends Result> T createStAXResult(Class<T> clazz) throws SQLException {
        StAXResult stAXResult = null;
        try {
            this.domResult = new DOMResult(new SAX2DOMBuilder().getDocument());
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(this.domResult);
            if (clazz == null || clazz == StAXResult.class) {
                stAXResult = new StAXResult(xMLStreamWriter);
            } else {
                Constructor<T> constructor = clazz.getConstructor(XMLStreamWriter.class);
                stAXResult = (StAXResult)constructor.newInstance(xMLStreamWriter);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw Exceptions.resultInstantiation(parserConfigurationException);
        }
        catch (SecurityException securityException) {
            throw Exceptions.resultInstantiation(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Exceptions.resultInstantiation(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Exceptions.resultInstantiation(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Exceptions.resultInstantiation(invocationTargetException.getTargetException());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw Exceptions.resultInstantiation(factoryConfigurationError);
        }
        catch (InstantiationException instantiationException) {
            throw Exceptions.resultInstantiation(instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Exceptions.resultInstantiation(noSuchMethodException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw Exceptions.resultInstantiation(xMLStreamException);
        }
        return (T)stAXResult;
    }

    protected void freeDomResult() {
        this.domResult = null;
    }

    static {
        Charset charset = null;
        try {
            charset = Charset.forName("UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        utf8Charset = charset;
    }

    public static class SAX2XMLStreamWriter
    implements ContentHandler,
    Closeable {
        private List<QualifiedName> namespaces = new ArrayList<QualifiedName>();
        private boolean closed;
        private Locator locator;
        private XMLStreamWriter writer;

        public SAX2XMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
            if (xMLStreamWriter == null) {
                throw new NullPointerException("writer");
            }
            this.writer = xMLStreamWriter;
        }

        @Override
        public void startDocument() throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeStartDocument();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeCharacters(cArray, n, n2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.checkClosed();
            try {
                int n;
                int n2 = string3.indexOf(58);
                String string4 = n2 > 0 ? string3.substring(0, n2) : "";
                this.writer.writeStartElement(string4, string2, string);
                int n3 = this.namespaces.size();
                for (n = 0; n < n3; ++n) {
                    QualifiedName qualifiedName = this.namespaces.get(n);
                    this.writer.writeNamespace(qualifiedName.prefix, qualifiedName.namespaceName);
                }
                this.namespaces.clear();
                n3 = attributes.getLength();
                for (n = 0; n < n3; ++n) {
                    this.writer.writeAttribute(attributes.getURI(n), attributes.getLocalName(n), attributes.getValue(n));
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.checkClosed();
            try {
                this.writer.setPrefix(string, string2);
                this.namespaces.add(new QualifiedName(string, string2));
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            this.checkClosed();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeProcessingInstruction(string, string2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public Locator getDocumentLocator() {
            return this.locator;
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.checkClosed();
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.checkClosed();
            try {
                this.writer.writeComment(new String(cArray, n, n2));
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }

        public XMLStreamWriter getWriter() {
            return this.writer;
        }

        protected List<QualifiedName> getNamespaces() {
            return this.namespaces;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                try {
                    this.writer.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new IOException(xMLStreamException);
                }
                finally {
                    this.writer = null;
                    this.locator = null;
                    this.namespaces = null;
                }
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        protected void checkClosed() throws SAXException {
            if (this.isClosed()) {
                throw new SAXException("content handler is closed.");
            }
        }

        protected class QualifiedName {
            public final String namespaceName;
            public final String prefix;

            public QualifiedName(String string, String string2) {
                this.prefix = string;
                this.namespaceName = string2;
            }
        }
    }

    protected static class SAX2DOMBuilder
    implements ContentHandler,
    Closeable {
        private boolean closed;
        private Element currentElement;
        private Node currentNode;
        private Document document;
        private Locator locator;

        public SAX2DOMBuilder() throws ParserConfigurationException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.currentNode = this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public Locator getDocumentLocator() {
            return this.locator;
        }

        @Override
        public void startDocument() throws SAXException {
            this.checkClosed();
        }

        @Override
        public void endDocument() throws SAXException {
            this.checkClosed();
            this.close();
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.checkClosed();
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            this.checkClosed();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.checkClosed();
            Element element = string == null || string.length() == 0 ? this.getDocument().createElement(string3) : this.getDocument().createElementNS(string, string3);
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getURI(i);
                    String string5 = attributes.getQName(i);
                    String string6 = attributes.getValue(i);
                    if (string4 == null || string4.length() == 0) {
                        element.setAttribute(string5, string6);
                        continue;
                    }
                    element.setAttributeNS(string4, string5, string6);
                }
            }
            this.getCurrentNode().appendChild(element);
            this.setCurrentNode(element);
            if (this.getCurrentElement() == null) {
                this.setCurrentElement(element);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.checkClosed();
            this.setCurrentNode(this.getCurrentNode().getParentNode());
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.checkClosed();
            Node node = this.getCurrentNode().getLastChild();
            String string = new String(cArray, n, n2);
            if (node != null && node.getNodeType() == 3) {
                ((Text)node).appendData(string);
            } else {
                Text text = this.getDocument().createTextNode(string);
                this.getCurrentNode().appendChild(text);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.checkClosed();
            ProcessingInstruction processingInstruction = this.getDocument().createProcessingInstruction(string, string2);
            this.getCurrentNode().appendChild(processingInstruction);
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.checkClosed();
            EntityReference entityReference = this.getDocument().createEntityReference(string);
            this.getCurrentNode().appendChild(entityReference);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public void free() {
            this.close();
            this.document = null;
            this.currentElement = null;
            this.currentNode = null;
            this.locator = null;
        }

        public boolean isClosed() {
            return this.closed;
        }

        protected void checkClosed() throws SAXException {
            if (this.isClosed()) {
                throw new SAXException("content handler is closed.");
            }
        }

        public Document getDocument() {
            return this.document;
        }

        protected Element getCurrentElement() {
            return this.currentElement;
        }

        protected void setCurrentElement(Element element) {
            this.currentElement = element;
        }

        protected Node getCurrentNode() {
            return this.currentNode;
        }

        protected void setCurrentNode(Node node) {
            this.currentNode = node;
        }
    }

    protected static class Exceptions {
        private Exceptions() {
        }

        static SQLException domInstantiation(Throwable throwable) {
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            return Util.sqlException(458, "SQLXML DOM instantiation failed: " + throwable, exception);
        }

        static SQLException sourceInstantiation(Throwable throwable) {
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            return Util.sqlException(458, "SQLXML Source instantiation failed: " + throwable, exception);
        }

        static SQLException resultInstantiation(Throwable throwable) {
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            return Util.sqlException(458, "SQLXML Result instantiation failed: " + throwable, exception);
        }

        static SQLException parseFailed(Throwable throwable) {
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            return Util.sqlException(458, "parse failed: " + throwable, exception);
        }

        static SQLException transformFailed(Throwable throwable) {
            Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
            return Util.sqlException(458, "transform failed: " + throwable, exception);
        }

        static SQLException notReadable() {
            return Util.sqlException(467, "SQLXML in not readable state");
        }

        static SQLException notReadable(String string) {
            return Util.sqlException(467, "SQLXML in not readable state: " + string);
        }

        static SQLException notWritable() {
            return Util.sqlException(467, "SQLXML in not writable state");
        }

        static SQLException directUpdateByLocatorNotSupported() {
            return Util.sqlException(1500, "SQLXML direct update by locator");
        }

        static SQLException inFreedState() {
            return Util.sqlException(458, "SQLXML in freed state");
        }
    }
}

