/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UILockedNodePageList
extends PageList<NodeLocation> {
    private static final Log LOG = ExoLogger.getLogger(UILockedNodePageList.class);
    private static final int QUERY_SIZE = 200;
    private String query;
    private Map<String, Integer> workspaceNodeMap;
    private String[] workspaceNameList;
    private List<NodeLocation> buffer;

    public UILockedNodePageList(int pageSize) {
        super(pageSize);
    }

    public UILockedNodePageList(String query, int pageSize, int currentPage) {
        super(pageSize);
        this.query = query;
        this.workspaceNameList = this.getWorkSpaceNameList();
        this.workspaceNodeMap = new HashMap<String, Integer>();
        this.buffer = this.getData(0, Math.max(200, (currentPage + 10) * pageSize));
        this.setAvailablePage(this.buffer.size());
    }

    private String[] getWorkSpaceNameList() {
        String[] ret;
        block2: {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ret = new String[]{};
            try {
                ret = repoService.getCurrentRepository().getWorkspaceNames();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e);
            }
        }
        return ret;
    }

    protected void populateCurrentPage(int page) throws Exception {
        this.currentListPage_ = this.buffer.subList(this.getFrom(), this.getTo());
    }

    protected void checkAndSetPage(int page) throws Exception {
        if (page + 10 > this.availablePage_) {
            this.buffer.addAll(this.getData(this.buffer.size(), (page + 10) * this.getPageSize() - this.availablePage_ + 200));
            this.setAvailablePage(this.buffer.size());
        }
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.currentPage_ = page;
    }

    private List<NodeLocation> getData(int from, int count) {
        int delta = from;
        List<NodeLocation> ret = new ArrayList<NodeLocation>();
        for (String workspace : this.workspaceNameList) {
            Integer lockedNodeCount = this.workspaceNodeMap.get(workspace);
            if (lockedNodeCount != null) {
                if (lockedNodeCount <= delta) {
                    delta -= lockedNodeCount.intValue();
                } else if (delta < lockedNodeCount && lockedNodeCount <= delta + count) {
                    ret.addAll(this.queryNodes(workspace, delta, lockedNodeCount - delta));
                    delta = 0;
                    count -= lockedNodeCount - delta;
                } else if (delta + count < lockedNodeCount) {
                    ret = this.queryNodes(workspace, delta, count);
                    break;
                }
            } else {
                List<NodeLocation> queryNodeData = this.queryNodes(workspace, delta, count);
                if (queryNodeData.size() == 0) {
                    lockedNodeCount = this.queryNodes(workspace, 0, count).size();
                    delta -= lockedNodeCount.intValue();
                    this.workspaceNodeMap.put(workspace, lockedNodeCount);
                } else if (0 < queryNodeData.size() && queryNodeData.size() < count) {
                    ret.addAll(queryNodeData);
                    delta = 0;
                    count -= queryNodeData.size();
                } else if (queryNodeData.size() == count) {
                    ret = queryNodeData;
                    break;
                }
            }
            if (count == 0) break;
        }
        return ret;
    }

    private List<NodeLocation> queryNodes(String workspace, int offset, int limit) {
        ArrayList<NodeLocation> ret;
        block3: {
            ret = new ArrayList<NodeLocation>();
            try {
                ManageableRepository repo = ((RepositoryService)WCMCoreUtils.getService(RepositoryService.class)).getCurrentRepository();
                Session session = WCMCoreUtils.getSystemSessionProvider().getSession(workspace, repo);
                Query query = session.getWorkspace().getQueryManager().createQuery(this.query, "sql");
                ((QueryImpl)query).setOffset((long)offset);
                ((QueryImpl)query).setLimit((long)limit);
                NodeIterator iter = query.execute().getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isLocked()) continue;
                    ret.add(NodeLocation.getNodeLocationByNode((Node)node));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e);
            }
        }
        return ret;
    }

    public List getAll() throws Exception {
        return this.buffer;
    }
}

