/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class DomWalker {
    private DomWalker() {
    }

    public static Gadget makeGadget(GadgetContext context) {
        try {
            GadgetSpec spec = new GadgetSpec(context.getUrl(), "<Module><ModulePrefs author=\"a\" title=\"t\"></ModulePrefs><Content></Content></Module>");
            return new Gadget().setSpec(spec).setContext(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected boilerplate parse failure");
        }
    }

    public static Gadget makeGadget(final HttpRequest request) {
        return DomWalker.makeGadget(new GadgetContext(){

            public Uri getUrl() {
                return request.getUri();
            }

            public String getParameter(String key) {
                return request.getParam(key);
            }

            public boolean getIgnoreCache() {
                return request.getIgnoreCache();
            }

            public String getContainer() {
                return request.getContainer();
            }

            public boolean getDebug() {
                return "1".equalsIgnoreCase(this.getParameter(UriCommon.Param.DEBUG.getKey()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rewriter
    implements GadgetRewriter,
    ResponseRewriter {
        private final List<Visitor> visitors;

        public Rewriter(List<Visitor> visitors) {
            this.visitors = visitors;
        }

        public Rewriter(Visitor ... visitors) {
            this.visitors = Arrays.asList(visitors);
        }

        public Rewriter() {
            this.visitors = null;
        }

        protected List<Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
            return this.visitors;
        }

        @Override
        public void rewrite(Gadget gadget, MutableContent content) throws RewritingException {
            this.rewrite(this.makeVisitors(gadget, gadget.getSpec().getUrl()), gadget, content);
        }

        @Override
        public void rewrite(HttpRequest request, HttpResponseBuilder builder) throws RewritingException {
            if (RewriterUtils.isHtml(request, builder)) {
                Gadget context = DomWalker.makeGadget(request);
                this.rewrite(this.makeVisitors(context, request.getGadget()), context, builder);
            }
        }

        private boolean rewrite(List<Visitor> visitors, Gadget gadget, MutableContent content) throws RewritingException {
            HashMap reservations = Maps.newHashMap();
            LinkedList toVisit = Lists.newLinkedList();
            Document doc = content.getDocument();
            if (doc == null) {
                throw new RewritingException("content.getDocument is null. Content: " + content.getContent(), 500);
            }
            toVisit.add(doc.getDocumentElement());
            boolean mutated = false;
            while (!toVisit.isEmpty()) {
                Node visiting = (Node)toVisit.removeFirst();
                boolean treeReserved = false;
                boolean nodeReserved = false;
                for (Visitor visitor : visitors) {
                    switch (visitor.visit(gadget, visiting)) {
                        case MODIFY: {
                            content.documentChanged();
                            mutated = true;
                            break;
                        }
                        case RESERVE_NODE: {
                            nodeReserved = true;
                            break;
                        }
                        case RESERVE_TREE: {
                            treeReserved = true;
                            break;
                        }
                    }
                    if (!nodeReserved && !treeReserved) continue;
                    if (!reservations.containsKey(visitor)) {
                        reservations.put(visitor, Lists.newLinkedList());
                    }
                    ((List)reservations.get(visitor)).add(visiting);
                    break;
                }
                if (treeReserved || !visiting.hasChildNodes()) continue;
                for (Node child = visiting.getLastChild(); child != null; child = child.getPreviousSibling()) {
                    toVisit.addFirst(child);
                }
            }
            for (Visitor visitor : visitors) {
                List nodesReserved = (List)reservations.get(visitor);
                if (nodesReserved == null || !visitor.revisit(gadget, nodesReserved)) continue;
                content.documentChanged();
                mutated = true;
            }
            return mutated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor {
        public VisitStatus visit(Gadget var1, Node var2) throws RewritingException;

        public boolean revisit(Gadget var1, List<Node> var2) throws RewritingException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum VisitStatus {
            BYPASS,
            MODIFY,
            RESERVE_NODE,
            RESERVE_TREE;

        }
    }
}

