/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.exoplatform.wsqa.httpclient.HttpPostFormRequestBody;
import org.exoplatform.wsqa.httpclient.HttpRequestBody;
import org.exoplatform.wsqa.httpclient.HttpRequestHeader;

public class HttpRequest {
    private HttpRequestHeader header_;
    private HttpRequestBody body_;

    public HttpRequest(HttpRequestHeader headers, HttpRequestBody body) {
        this.header_ = headers;
        this.body_ = body;
    }

    public HttpRequest(InputStream is) throws Exception {
        this.header_ = new HttpRequestHeader(is);
        if ("POST".equals(this.header_.getMethod())) {
            String contentType = (String)this.header_.get("Content-Type");
            String contentLengthHeader = (String)this.header_.get("Content-Length");
            int contentLength = -1;
            if (contentLengthHeader != null) {
                contentLength = Integer.parseInt(contentLengthHeader);
            }
            this.body_ = HttpPostFormRequestBody.isFormRequest(contentType) ? new HttpPostFormRequestBody(contentType, contentLength, is) : new HttpRequestBody(contentType, contentLength, is);
        }
    }

    public boolean isGETMethod() {
        return "GET".equals(this.header_.getMethod());
    }

    public boolean isPOSTMethod() {
        return "POST".equals(this.header_.getMethod());
    }

    public HttpRequestHeader getHeaders() {
        return this.header_;
    }

    public HttpRequestBody getRequestBody() {
        return this.body_;
    }

    public byte[] getOriginalRequestData() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (this.header_.getOriginalData() != null) {
            os.write(this.header_.getOriginalData());
        }
        if (this.body_ != null && this.body_.getOrgininalData() != null) {
            os.write(this.body_.getOrgininalData());
        }
        return os.toByteArray();
    }

    public byte[] getRequestData() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.header_.toBytes());
        if (this.body_ != null) {
            os.write(this.body_.toBytes());
        }
        return os.toByteArray();
    }

    public String getRequestDataAsText() throws Exception {
        return new String(this.getRequestData());
    }

    public void forward(OutputStream os) throws Exception {
        byte[] bodyData = null;
        if (this.body_ != null) {
            bodyData = this.body_.toBytes();
            this.header_.setContentLength(bodyData.length);
        }
        os.write(this.header_.toBytes());
        if (bodyData != null) {
            os.write(this.body_.toBytes());
        }
    }
}

