/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.util.Debug;

public class JpegImageMetadata
implements IImageMetadata {
    private final JpegPhotoshopMetadata photoshop;
    private final TiffImageMetadata exif;
    private static final String newline = System.getProperty("line.separator");

    public JpegImageMetadata(JpegPhotoshopMetadata photoshop, TiffImageMetadata exif) {
        this.photoshop = photoshop;
        this.exif = exif;
    }

    public TiffImageMetadata getExif() {
        return this.exif;
    }

    public JpegPhotoshopMetadata getPhotoshop() {
        return this.photoshop;
    }

    public TiffField findEXIFValue(TagInfo tagInfo) {
        ArrayList items = this.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Object o = items.get(i);
            if (!(o instanceof TiffImageMetadata.Item)) continue;
            TiffImageMetadata.Item item = (TiffImageMetadata.Item)o;
            TiffField field = item.getTiffField();
            if (field.tag != tagInfo.tag) continue;
            return field;
        }
        return null;
    }

    public BufferedImage getEXIFThumbnail() throws ImageReadException, IOException {
        ArrayList dirs = this.exif.getDirectories();
        for (int i = 0; i < dirs.size(); ++i) {
            TiffImageMetadata.Directory dir = (TiffImageMetadata.Directory)dirs.get(i);
            BufferedImage image = dir.getThumbnail();
            if (null == image) continue;
            return image;
        }
        return null;
    }

    public TiffImageData getRawImageData() {
        ArrayList dirs = this.exif.getDirectories();
        for (int i = 0; i < dirs.size(); ++i) {
            TiffImageMetadata.Directory dir = (TiffImageMetadata.Directory)dirs.get(i);
            TiffImageData rawImageData = dir.getTiffImageData();
            if (null == rawImageData) continue;
            return rawImageData;
        }
        return null;
    }

    public ArrayList getItems() {
        ArrayList result = new ArrayList();
        if (null != this.exif) {
            result.addAll(this.exif.getItems());
        }
        if (null != this.photoshop) {
            result.addAll(this.photoshop.getItems());
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer result = new StringBuffer();
        result.append(prefix);
        if (null == this.exif) {
            result.append("No Exif metadata.");
        } else {
            result.append("Exif metadata:");
            result.append(newline);
            result.append(this.exif.toString("\t"));
        }
        result.append(newline);
        result.append(prefix);
        if (null == this.photoshop) {
            result.append("No Photoshop (IPTC) metadata.");
        } else {
            result.append("Photoshop (IPTC) metadata:");
            result.append(newline);
            result.append(this.photoshop.toString("\t"));
        }
        return result.toString();
    }

    public void dump() {
        Debug.debug(this.toString());
    }
}

