/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.QuotedExpression;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.parser.quasiliteral.SyntheticRuleSet;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import java.util.List;
import java.util.Map;

@RulesetDescription(name="Valija-to-Cajita Transformation Rules", synopsis="Default set of transformations used by Valija")
public class DefaultValijaRewriter
extends Rewriter {
    private int tempVarCount = 1;
    private final String tempVarPrefix = "$caja$";
    private final Rule[] valijaRules = new Rule[]{new Rule(){

        @RuleDescription(name="cajitaUseSubset", synopsis="Skip subtrees with a 'use strict,cajita' declaration", reason="Valija rules should not be applied to embedded cajita code", matches="'use cajita'; @stmt*", substitutes="{ @stmt* }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings;
            if (node instanceof Block && (bindings = this.match(node)) != null) {
                return this.substV("stmt", DefaultValijaRewriter.this.noexpandAll(bindings.get("stmt")));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="cajitaUseSubsetFnDecl", synopsis="Skip functions with a 'use strict,cajita' declaration", reason="Valija rules should not be applied to embedded cajita code", matches="/*outer*/function @name(@actuals*) { 'use cajita'; @body* }", substitutes="$v.so('@name', function @name(@actuals*) { @body* })")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier fname;
            Map<String, ParseTreeNode> bindings;
            if (node instanceof FunctionDeclaration && (bindings = this.match(((FunctionDeclaration)node).getInitializer())) != null && scope.isOuter((fname = (Identifier)bindings.get("name")).getName())) {
                Expression initScope = (Expression)QuasiBuilder.substV("$v.initOuter('@name');", "name", fname);
                ParseTreeNodeContainer actuals = (ParseTreeNodeContainer)bindings.get("actuals");
                Expression initBlock = (Expression)this.substV("name", fname, "actuals", DefaultValijaRewriter.this.noexpandParams(actuals), "body", DefaultValijaRewriter.this.noexpandAll(bindings.get("body")));
                scope.addStartOfScopeStatement(2.newExprStmt(initScope));
                scope.addStartStatement(2.newExprStmt(initBlock));
                return new Noop(node.getFilePosition());
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="cajitaUseSubsetFn", synopsis="Skip functions with a 'use strict,cajita' declaration", reason="Valija rules should not be applied to embedded cajita code", matches="function @i?(@actuals*) { 'use cajita'; @stmt* }", substitutes="function @i?(@actuals*) { @stmt* }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            FunctionConstructor ctor;
            if (node instanceof FunctionDeclaration) {
                ctor = ((FunctionDeclaration)node).getInitializer();
            } else if (node instanceof FunctionConstructor) {
                ctor = (FunctionConstructor)node;
            } else {
                return NONE;
            }
            Map<String, ParseTreeNode> bindings = this.match(ctor);
            if (bindings != null) {
                Identifier iOpt = (Identifier)bindings.get("i");
                ParseTreeNodeContainer actuals = (ParseTreeNodeContainer)bindings.get("actuals");
                FunctionConstructor newCtor = (FunctionConstructor)this.substV("i", null == iOpt ? null : DefaultValijaRewriter.this.noexpand(iOpt), "actuals", DefaultValijaRewriter.this.noexpandParams(actuals), "stmt", DefaultValijaRewriter.this.noexpandAll(bindings.get("stmt")));
                if (node instanceof FunctionDeclaration) {
                    return new FunctionDeclaration(newCtor);
                }
                return newCtor;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="staticModuleIncluding", synopsis="Replaced with the Cajita module loading", reason="", matches="includeScript(@arg)", substitutes="load(@arg)({$v: $v})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isOuter("includeScript")) {
                ParseTreeNode arg = bindings.get("arg");
                if (arg instanceof StringLiteral) {
                    return this.substV("arg", DefaultValijaRewriter.this.noexpand((StringLiteral)arg));
                }
                DefaultValijaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_VALIJA_MODULE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="staticCommonJsModuleLoading", synopsis="based on the Cajita module loading", reason="", matches="require(@arg)", substitutes="$v.cf($v.ro('require'), [load(@arg)])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isOuter("includeScript")) {
                ParseTreeNode arg = bindings.get("arg");
                if (arg instanceof StringLiteral) {
                    return this.substV("arg", DefaultValijaRewriter.this.noexpand((StringLiteral)arg));
                }
                DefaultValijaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_SERVERJS_MODULE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="dynamicCommonJsModuleLoading", synopsis="based on the Cajita module loading", reason="", matches="require.async(@arg)", substitutes="$v.cm($v.ro('require'), 'async', [load.async(@arg)])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isOuter("includeScript")) {
                ParseTreeNode arg = bindings.get("arg");
                if (arg instanceof StringLiteral) {
                    return this.substV("arg", DefaultValijaRewriter.this.noexpand((StringLiteral)arg));
                }
                DefaultValijaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_SERVERJS_MODULE, node.getFilePosition());
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="moduleEnvelope", synopsis="Expand to a Caja module using an isolated scope.", reason="The 'module' rule should fire on the body of the module.", matches="<a Valija UncajoledModule>", substitutes="<a Caja UncajoledModule>")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof UncajoledModule) {
                return this.expandAll(node, null);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="module", synopsis="Assume an imported \"$v\" that knows our shared outers. Name it $dis so top level uses of \"this\" in Valija work.", reason="", matches="@ss*;", substitutes="@startStmts*; @ss*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block && scope == null) {
                Scope s2 = Scope.fromProgram((Block)node, DefaultValijaRewriter.this.mq);
                s2.addStartStatement((Declaration)QuasiBuilder.substV("var $dis = $v.getOuters();", new Object[0]));
                s2.addStartStatement(8.newExprStmt((Expression)QuasiBuilder.substV("$v.initOuter('onerror');", new Object[0])));
                List<ParseTreeNode> expanded = Lists.newArrayList();
                for (ParseTreeNode parseTreeNode : node.children()) {
                    expanded.add(DefaultValijaRewriter.this.expand(parseTreeNode, s2));
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "ss", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="block", synopsis="Initialize named functions at the beginning of their enclosing block.", reason="Nested named function declarations are illegal in ES3 but are universally supported by all JavaScript implementations, though in different ways. The compromise semantics currently supported by Caja is to hoist the declaration of a variable with the function's name to the beginning of the enclosing function body or module top level, and to initialize this variable to a new anonymous function every time control re-enters the enclosing block.\nNote that ES-Harmony will specify a better and safer semantics -- block level lexical scoping -- that we'd like to adopt into Caja eventually. However, it so challenging to implement this semantics by translation to currently-implemented JavaScript that we provide something quicker and dirtier for now.", matches="{@ss*;}", substitutes="@startStmts*; @ss*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block) {
                List<ParseTreeNode> expanded = Lists.newArrayList();
                Scope s2 = Scope.fromPlainBlock(scope);
                for (ParseTreeNode parseTreeNode : node.children()) {
                    expanded.add(DefaultValijaRewriter.this.expand(parseTreeNode, s2));
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "ss", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="foreachExpr", synopsis="Get the keys, then iterate over them.", reason="", matches="for (@k in @o) @ss;", substitutes="@t1 = $v.keys(@o);\nfor (@t2 = 0; @t2 < @t1.length; ++@t2) {\n  @assign;\n  @ss;\n}\n/* where @assign is the expansion of\n@k = QuotedExpression( @t1[@t2] ); */")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("k") instanceof ExpressionStmt) {
                ExpressionStmt es = (ExpressionStmt)bindings.get("k");
                bindings.put("k", es.getExpression());
                Reference rt1 = DefaultValijaRewriter.this.newTempVar(scope);
                Reference rt2 = DefaultValijaRewriter.this.newTempVar(scope);
                ParseTreeNode assignment = QuasiBuilder.substV("@k = @t3;", "k", bindings.get("k"), "t3", new QuotedExpression((Expression)QuasiBuilder.substV("@t1[@t2]", "t1", rt1, "t2", rt2)));
                assignment.getAttributes().set(ParseTreeNode.TAINTED, true);
                Expression assign = (Expression)DefaultValijaRewriter.this.expand(assignment, scope);
                return this.substV("t1", rt1, "o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "t2", rt2, "assign", SyntheticNodes.s(10.newExprStmt(assign)), "ss", DefaultValijaRewriter.this.expand(bindings.get("ss"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="foreach", synopsis="Get the keys, then iterate over them.", reason="", matches="for (var @k in @o) @ss;", substitutes="@t1 = $v.keys(@o);\nfor (@t2 = 0; @t2 < @t1.length; ++@t2) {\n  @assign\n  @ss;\n}\n/* where @assign is the expansion of\nvar @k = QuotedExpression( @t1[@t2] ); */")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference rt1 = DefaultValijaRewriter.this.newTempVar(scope);
                Reference rt2 = DefaultValijaRewriter.this.newTempVar(scope);
                ParseTreeNode assignment = QuasiBuilder.substV("var @k = @t3;", "k", bindings.get("k"), "t3", new QuotedExpression((Expression)QuasiBuilder.substV("@t1[@t2]", "t1", rt1, "t2", rt2)));
                assignment.getAttributes().set(ParseTreeNode.TAINTED, true);
                return this.substV("t1", rt1, "o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "t2", rt2, "assign", SyntheticNodes.s(DefaultValijaRewriter.this.expand(assignment, scope)), "ss", DefaultValijaRewriter.this.expand(bindings.get("ss"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatch", synopsis="", reason="", matches="try { @s0*; } catch (@x) { @s1*; }", substitutes="try { @s0*; } catch (@x) { @rx = $v.tr(@rx); @s1*; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier x = (Identifier)bindings.get("x");
                return this.substV("s0", this.expandAll(bindings.get("s0"), scope), "x", DefaultValijaRewriter.this.noexpand(x), "rx", new Reference(x), "s1", this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause())));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryCatchFinally", synopsis="", reason="", matches="try { @s0*; } catch (@x) { @s1*; } finally { @s2*; }", substitutes="try { @s0*; } catch (@x) { @rx = $v.tr(@rx); @s1*; } finally { @s2*; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                TryStmt t = (TryStmt)node;
                Identifier x = (Identifier)bindings.get("x");
                return this.substV("s0", this.expandAll(bindings.get("s0"), scope), "x", DefaultValijaRewriter.this.noexpand(x), "rx", new Reference(x), "s1", this.expandAll(bindings.get("s1"), Scope.fromCatchStmt(scope, t.getCatchClause())), "s2", this.expandAll(bindings.get("s2"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="tryFinally", synopsis="", reason="", matches="try { @s0*; } finally { @s1*; }", substitutes="try { @s0*; } finally { @s1*; }")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("s0", this.expandAll(bindings.get("s0"), scope), "s1", this.expandAll(bindings.get("s1"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="throw", synopsis="", reason="", matches="throw @ex", substitutes="throw $v.ts(@ex)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.transform(node, scope);
        }
    }, new Rule(){

        @RuleDescription(name="this", synopsis="Replace all occurrences of \"this\" with $dis.", reason="", matches="this", substitutes="$dis")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return 16.newReference(node.getFilePosition(), "$dis");
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="initGlobalVar", synopsis="", reason="", matches="/* in outer scope */ var @v = @r", substitutes="$v.so('@v', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier v;
            String vname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && scope.isOuter(vname = (v = (Identifier)bindings.get("v")).getName())) {
                ParseTreeNode r = bindings.get("r");
                return 17.newExprStmt((Expression)this.substV("v", v, "r", DefaultValijaRewriter.this.expand(this.nymize(r, vname, "var"), scope)));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setGlobalVar", synopsis="", reason="", matches="/* declared in outer scope */ @v = @r", substitutes="$v.so('@v', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String vname;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && scope.isOuter(vname = ((Reference)v).getIdentifierName())) {
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", v, "r", DefaultValijaRewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="declGlobalVar", synopsis="", reason="", matches="/* in outer scope */ var @v", substitutes="$v.initOuter('@v')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("v") instanceof Identifier && scope.isOuter(((Identifier)bindings.get("v")).getName())) {
                ExpressionStmt es = 19.newExprStmt((Expression)this.substV("v", bindings.get("v")));
                Scope.markForSideEffect(es);
                return es;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readArguments", synopsis="Translate reference to 'arguments'", reason="", matches="arguments", substitutes="$caja$args")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV(new Object[0]);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readGlobalVar", synopsis="", reason="", matches="/* declared in outer scope */ @v", substitutes="$v.ro('@v')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && bindings.get("v") instanceof Reference && scope.isOuter((v = (Reference)bindings.get("v")).getIdentifierName())) {
                return this.substV("v", DefaultValijaRewriter.this.noexpand(v));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="initLocalVar", synopsis="", reason="", matches="/* not in outer scope */ var @v = @r", substitutes="var @v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Identifier v;
            String vname;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && !scope.isOuter(vname = (v = (Identifier)bindings.get("v")).getName())) {
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", v, "r", DefaultValijaRewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setLocalVar", synopsis="", reason="", matches="/* not in outer scope */ @v = @r", substitutes="@v = @r")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            String vname;
            ParseTreeNode v;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (v = bindings.get("v")) instanceof Reference && !scope.isOuter(vname = ((Reference)v).getIdentifierName())) {
                ParseTreeNode r = bindings.get("r");
                return this.substV("v", v, "r", DefaultValijaRewriter.this.expand(this.nymize(r, vname, "var"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readPublic", synopsis="Read @'p' from @o or @o's POE table", reason="", matches="@o.@p", substitutes="$v.r(@o, '@p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference p = (Reference)bindings.get("p");
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", p);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="readIndexPublic", synopsis="Read @p from @o or @o's POE table", reason="", matches="@o[@p]", substitutes="$v.r(@o, @p)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", DefaultValijaRewriter.this.expand(bindings.get("p"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setPublic", synopsis="Set @'p' on @o or @o's POE table", reason="", matches="@o.@p = @r", substitutes="$v.s(@o, '@p', @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                ParseTreeNode o = bindings.get("o");
                Reference p = (Reference)bindings.get("p");
                ParseTreeNode r = bindings.get("r");
                return this.substV("o", DefaultValijaRewriter.this.expand(o, scope), "p", p, "r", DefaultValijaRewriter.this.expand(this.nymize(r, p.getIdentifierName(), "meth"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIndexPublic", synopsis="Set @p on @o or @o's POE table", reason="", matches="@o[@p] = @r", substitutes="$v.s(@o, @p, @r)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", DefaultValijaRewriter.this.expand(bindings.get("p"), scope), "r", DefaultValijaRewriter.this.expand(bindings.get("r"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setReadModifyWriteLocalVar", synopsis="", reason="", matches="<approx> @x @op= @y", substitutes="<approx> @x = @x @op @y")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof AssignOperation) {
                AssignOperation aNode = (AssignOperation)node;
                Operator op = aNode.getOperator();
                if (op.getAssignmentDelegate() == null) {
                    return NONE;
                }
                Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(aNode.children().get(0), scope, false);
                if (ops == null) {
                    return node;
                }
                Operation rhs = Operation.create(aNode.children().get(0).getFilePosition(), op.getAssignmentDelegate(), ops.getUncajoledLValue(), aNode.children().get(1));
                Operation assignment = ops.makeAssignment(rhs);
                if (ops.getTemporaries().isEmpty()) {
                    return DefaultValijaRewriter.this.expand(assignment, scope);
                }
                return QuasiBuilder.substV("@tmps, @assignment", "tmps", this.newCommaOperation(ops.getTemporaries()), "assignment", DefaultValijaRewriter.this.expand(assignment, scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="setIncrDecr", synopsis="Handle pre and post ++ and --.", matches="<approx> ++@x but any {pre,post}{in,de}crement will do", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (!(node instanceof AssignOperation)) {
                return NONE;
            }
            AssignOperation op = (AssignOperation)node;
            Expression v = op.children().get(0);
            Rule.ReadAssignOperands ops = this.deconstructReadAssignOperand(v, scope, false);
            if (ops == null) {
                return node;
            }
            switch (op.getOperator()) {
                case POST_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v ++", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal + 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_INCREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("++@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - -1", "rvalue", ops.getUncajoledLValue())), scope));
                }
                case POST_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("@v--", "v", ops.getCajoledLValue());
                    }
                    Reference tmpVal = new Reference(scope.declareStartOfScopeTempVariable());
                    Expression assign = (Expression)DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@tmpVal - 1", "tmpVal", tmpVal)), scope);
                    return QuasiBuilder.substV("  @tmps,@tmpVal = +@rvalue,@assign,@tmpVal;", "tmps", this.newCommaOperation(ops.getTemporaries()), "tmpVal", tmpVal, "rvalue", ops.getCajoledLValue(), "assign", assign);
                }
                case PRE_DECREMENT: {
                    if (ops.isSimpleLValue()) {
                        return QuasiBuilder.substV("--@v", "v", ops.getCajoledLValue());
                    }
                    if (ops.getTemporaries().isEmpty()) {
                        return DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope);
                    }
                    return QuasiBuilder.substV("  @tmps,@assign", "tmps", this.newCommaOperation(ops.getTemporaries()), "assign", DefaultValijaRewriter.this.expand(ops.makeAssignment((Expression)QuasiBuilder.substV("@rvalue - 1", "rvalue", ops.getUncajoledLValue())), scope));
                }
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="constructNoArgs", synopsis="Construct a new object and supply the missing empty argument list.", reason="", matches="new @c", substitutes="$v.construct(@c, [])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("c", DefaultValijaRewriter.this.expand(bindings.get("c"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="construct", synopsis="Construct a new object.", reason="", matches="new @c(@as*)", substitutes="$v.construct(@c, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("c", DefaultValijaRewriter.this.expand(bindings.get("c"), scope), "as", DefaultValijaRewriter.this.expand(bindings.get("as"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deletePublic", synopsis="Delete a statically known property of an object.", reason="", matches="delete @o.@p", substitutes="$v.remove(@o, '@p')")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference p = (Reference)bindings.get("p");
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", p);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="deleteIndexPublic", synopsis="Delete a dynamically chosen property of an object.", reason="", matches="delete @o[@p]", substitutes="$v.remove(@o, @p)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", DefaultValijaRewriter.this.expand(bindings.get("p"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callNamed", synopsis="Call a property with a statically known name.", reason="", matches="@o.@p(@as*)", substitutes="$v.cm(@o, '@p', [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Reference p = (Reference)bindings.get("p");
                List<ParseTreeNode> expanded = Lists.newArrayList();
                ParseTreeNodeContainer args = (ParseTreeNodeContainer)bindings.get("as");
                for (ParseTreeNode parseTreeNode : args.children()) {
                    expanded.add(DefaultValijaRewriter.this.expand(parseTreeNode, scope));
                }
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", p, "as", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callMethod", synopsis="Call a property with a computed name.", reason="", matches="@o[@p](@as*)", substitutes="$v.cm(@o, @p, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                List<ParseTreeNode> expanded = Lists.newArrayList();
                ParseTreeNodeContainer args = (ParseTreeNodeContainer)bindings.get("as");
                for (ParseTreeNode parseTreeNode : args.children()) {
                    expanded.add(DefaultValijaRewriter.this.expand(parseTreeNode, scope));
                }
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "p", DefaultValijaRewriter.this.expand(bindings.get("p"), scope), "as", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="callFunc", synopsis="Call a function.", reason="", matches="@f(@as*)", substitutes="$v.cf(@f, [@as*])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                List<ParseTreeNode> expanded = Lists.newArrayList();
                ParseTreeNodeContainer args = (ParseTreeNodeContainer)bindings.get("as");
                for (ParseTreeNode parseTreeNode : args.children()) {
                    expanded.add(DefaultValijaRewriter.this.expand(parseTreeNode, scope));
                }
                return this.substV("f", DefaultValijaRewriter.this.expand(bindings.get("f"), scope), "as", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="disfuncAnon", synopsis="Transmutes functions into disfunctions.", reason="", matches="function (@ps*) {@bs*;}", substitutes="$v.dis(function ($dis, @ps*) {  @fh*;  @stmts*;   @bs*;})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                return this.substV("ps", bindings.get("ps"), "bs", DefaultValijaRewriter.this.expand(bindings.get("bs"), s2), "fh", DefaultValijaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="disfuncNamedGlobalDecl", synopsis="Transmutes functions into disfunctions and hoists them.", reason="", matches="/* at top level */ function @f(@ps*) {@bs*;}", substitutes="$v.so('@f', (function () {  var @f;  function @fcaller($dis, @ps*) {    @fh*;    @stmts*;    @bs*;  }  @rf = $v.dis(@rfcaller, '@f');  return @rf;})());")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            FunctionConstructor c;
            Map<String, ParseTreeNode> bindings;
            if (node instanceof FunctionDeclaration && (bindings = this.match(c = ((FunctionDeclaration)node).getInitializer())) != null && scope.isOuter(((Identifier)bindings.get("f")).getName())) {
                Scope s2 = Scope.fromFunctionConstructor(scope, c);
                this.checkFormals(bindings.get("ps"));
                Identifier f = (Identifier)bindings.get("f");
                Identifier fcaller = new Identifier(f.getFilePosition(), this.nym(node, f.getName(), "caller"));
                Expression expr = (Expression)this.substV("f", f, "rf", new Reference(f), "fcaller", fcaller, "rfcaller", new Reference(fcaller), "ps", bindings.get("ps"), "bs", DefaultValijaRewriter.this.expand(bindings.get("bs"), s2), "fh", DefaultValijaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                scope.addStartStatement(38.newExprStmt(expr));
                return QuasiBuilder.substV(";", new Object[0]);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="disfuncNamedDecl", synopsis="Transmutes functions into disfunctions.", reason="", matches="function @fname(@ps*) {@bs*;}", substitutes="function @fcaller($dis, @ps*) {    @fh*;    @stmts*;    @bs*;}@fname = $v.dis(@rfcaller, '@fname');")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = 39.makeBindings();
            if (node instanceof FunctionDeclaration && QuasiBuilder.match("function @fname(@ps*) { @bs*; }", ((FunctionDeclaration)node).getInitializer(), bindings)) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node.children().get(1));
                this.checkFormals(bindings.get("ps"));
                Identifier fname = (Identifier)bindings.get("fname");
                Identifier fcaller = new Identifier(FilePosition.UNKNOWN, this.nym(node, fname.getName(), "caller"));
                scope.declareStartOfScopeVariable(fname);
                Block block = (Block)this.substV("fname", new Reference(fname), "fcaller", fcaller, "rfcaller", new Reference(fcaller), "ps", bindings.get("ps"), "bs", DefaultValijaRewriter.this.expand(bindings.get("bs"), s2), "fh", DefaultValijaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
                for (Statement statement : block.children()) {
                    scope.addStartStatement(statement);
                }
                return QuasiBuilder.substV(";", new Object[0]);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="disfuncNamedValue", synopsis="", reason="", matches="function @fname(@ps*) { @bs*; }", substitutes="(function() {  function @fcaller($dis, @ps*) {    @fh*;    @stmts*;    @bs*;  }  var @fname = $v.dis(@rfcaller, '@fname');  return @fRef;})();")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                this.checkFormals(bindings.get("ps"));
                Identifier fname = (Identifier)bindings.get("fname");
                Identifier fcaller = new Identifier(FilePosition.UNKNOWN, this.nym(node, fname.getName(), "caller"));
                return this.substV("fname", fname, "fRef", new Reference(fname), "fcaller", fcaller, "rfcaller", new Reference(fcaller), "ps", bindings.get("ps"), "bs", DefaultValijaRewriter.this.expand(bindings.get("bs"), s2), "fh", DefaultValijaRewriter.getFunctionHeadDeclarations(s2), "stmts", new ParseTreeNodeContainer(s2.getStartStatements()));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="multiDeclaration", synopsis="Convert a MultiDeclaration into a comma expression", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof MultiDeclaration && scope.isOuter()) {
                List<Expression> newChildren = Lists.newArrayList();
                int len = node.children().size();
                for (int i = 0; i < len; ++i) {
                    ExpressionStmt result = (ExpressionStmt)DefaultValijaRewriter.this.expand(node.children().get(i), scope);
                    newChildren.add(i, result.getExpression());
                }
                return 41.newExprStmt(this.newCommaOperation(newChildren));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="oneprop", synopsis="", reason="", matches="\"@key\": @val", substitutes="\"@key\": @val")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjProperty) {
                if (node instanceof ValueProperty) {
                    ValueProperty prop = (ValueProperty)node;
                    StringLiteral key = prop.getPropertyNameNode();
                    Expression val = prop.getValueExpr();
                    return new ValueProperty(DefaultValijaRewriter.this.noexpand(key), (Expression)DefaultValijaRewriter.this.expand(this.nymize(val, key.getUnquotedValue(), "lit"), scope));
                }
                DefaultValijaRewriter.this.mq.addMessage((MessageTypeInt)RewriterMessageType.GETTERS_SETTERS_NOT_SUPPORTED, node.getFilePosition(), this);
                return node;
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="map", synopsis="", reason="", matches="({@keys*: @val*})", substitutes="({@keys*: @vals*})")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof ObjectConstructor) {
                List<? extends ObjProperty> props = ((ObjectConstructor)node).children();
                List<ObjProperty> outProps = Lists.newArrayList();
                for (ObjProperty objProperty : props) {
                    ObjProperty expandedProp = (ObjProperty)DefaultValijaRewriter.this.expand(objProperty, scope);
                    outProps.add(expandedProp);
                }
                return new ObjectConstructor(FilePosition.UNKNOWN, outProps);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="outerTypeof", synopsis="typeof of a global reference.", reason="Typeof should not throw an error for undefined outers", matches="typeof /* global reference */ @f", substitutes="$v.typeOf($v.ros('@f'))")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Reference fRef;
            ParseTreeNode f;
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null && (f = bindings.get("f")) instanceof Reference && scope.isOuter((fRef = (Reference)f).getIdentifierName())) {
                return this.substV("f", DefaultValijaRewriter.this.noexpand(fRef));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="otherTypeof", synopsis="Rewrites typeof.", reason="Both typeof function and typeof disfunction need to return \"function\".", matches="typeof @f", substitutes="$v.typeOf(@f)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("f", DefaultValijaRewriter.this.expand(bindings.get("f"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="otherInstanceof", synopsis="Rewrites instanceof.", reason="Need to check both the shadow prototype chain and the real one.", matches="@o instanceof @f", substitutes="$v.instanceOf(@o, @f)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope), "f", DefaultValijaRewriter.this.expand(bindings.get("f"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="inPublic", synopsis="", reason="", matches="@i in @o", substitutes="$v.canReadRev(@i, @o)")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                return this.substV("i", DefaultValijaRewriter.this.expand(bindings.get("i"), scope), "o", DefaultValijaRewriter.this.expand(bindings.get("o"), scope));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="regexLiteral", synopsis="Use the regular expression constructor", reason="So that every use of a regex literal creates a new instance to prevent state from leaking via interned literals.  This is consistent with the way ES4 treates regex literals.", substitutes="$v.construct(RegExp, [@pattern, @modifiers?])")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof RegexpLiteral) {
                RegexpLiteral.RegexpWrapper re = ((RegexpLiteral)node).getValue();
                FilePosition pos = node.getFilePosition();
                StringLiteral pattern = StringLiteral.valueOf(pos, re.getMatchText());
                StringLiteral modifiers = !"".equals(re.getModifiers()) ? StringLiteral.valueOf(pos, re.getModifiers()) : null;
                return this.substV("pattern", pattern, "modifiers", modifiers);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="unquote", synopsis="Removes a QuotedExpression wrapper.", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof QuotedExpression) {
                return ((QuotedExpression)node).unquote();
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="recurse", synopsis="Automatically recurse into any remaining structures", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.expandAll(node, scope);
        }
    }};

    public static ParseTreeNode getFunctionHeadDeclarations(Scope scope) {
        List<ParseTreeNode> stmts = Lists.newArrayList();
        if (scope.hasFreeArguments()) {
            stmts.add(QuasiBuilder.substV("var $caja$args = $v.disArgs(arguments);", new Object[0]));
        }
        return new ParseTreeNodeContainer(stmts);
    }

    Reference newTempVar(Scope scope) {
        Identifier t = new Identifier(FilePosition.UNKNOWN, "$caja$" + this.tempVarCount++);
        scope.declareStartOfScopeVariable(t);
        return new Reference(t);
    }

    protected ParseTreeNode noexpandAll(ParseTreeNode node) {
        return node;
    }

    public DefaultValijaRewriter(MessageQueue mq) {
        this(mq, false);
    }

    public DefaultValijaRewriter(MessageQueue mq, boolean logging) {
        super(mq, false, logging);
        this.addRules(SyntheticRuleSet.syntheticRules(this));
        this.addRules(this.valijaRules);
    }
}

