/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee.websphere;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.DefaultLoginModule;
import org.exoplatform.services.security.jaas.RolePrincipal;
import org.exoplatform.services.security.jaas.UserPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsphereJAASLoginModule
extends DefaultLoginModule {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.ExoWebsphereJAASLoginModule");
    public static final String WSCREDENTIAL_PROPERTIES_KEY = "com.ibm.wsspi.security.cred.propertiesObject";
    public static final String WSCREDENTIAL_UNIQUEID = "com.ibm.wsspi.security.cred.uniqueId";
    public static final String WSCREDENTIAL_SECURITYNAME = "com.ibm.wsspi.security.cred.securityName";
    public static final String WSCREDENTIAL_GROUPS = "com.ibm.wsspi.security.cred.groups";
    public static final String WSCREDENTIAL_CACHE_KEY = "com.ibm.wsspi.security.cred.cacheKey";

    @Override
    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"In login of WebsphereJAASLoginModule");
        }
        if (super.login()) {
            ArrayList<String> roleGroupList = new ArrayList<String>();
            for (String role : this.identity.getRoles()) {
                roleGroupList.add(role);
            }
            this.websphereLogin(this.identity.getUserId(), roleGroupList);
            return true;
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (super.commit()) {
            Set<Principal> principals = this.subject.getPrincipals();
            for (String role : this.identity.getRoles()) {
                principals.add(new RolePrincipal(role));
            }
            principals.add(new UserPrincipal(this.identity.getUserId()));
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"In abort of WebsphereJAASLoginModule");
        }
        return super.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"In logout of WebsphereJAASLoginModule");
        }
        return super.logout();
    }

    private void websphereLogin(String user, ArrayList<String> roleGroupList) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String uniqueid = user;
        hashtable.put(WSCREDENTIAL_UNIQUEID, uniqueid);
        hashtable.put(WSCREDENTIAL_SECURITYNAME, user);
        hashtable.put(WSCREDENTIAL_GROUPS, roleGroupList);
        hashtable.put(WSCREDENTIAL_CACHE_KEY, uniqueid + "WebsphereJAASLoginModule");
        this.subject.getPublicCredentials().add(hashtable);
    }
}

