/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.xcmis.spi.utils.Logger;

public class CaseInsensitiveTermQuery
extends MultiTermQuery {
    private static final long serialVersionUID = 8733959357848332771L;
    private static final Logger log = Logger.getLogger(CaseInsensitiveTermQuery.class);

    public CaseInsensitiveTermQuery(Term term) {
        super(term);
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new CaseInsensitiveTermEnum(reader, this.getTerm());
    }

    private class CaseInsensitiveTermEnum
    extends FilteredTermEnum {
        private String field;
        private String text;
        private boolean endEnum;

        public CaseInsensitiveTermEnum(IndexReader reader, Term term) throws IOException {
            this.field = term.field();
            this.text = term.text().toLowerCase();
            this.setEnum(reader.terms(new Term(term.field(), term.text().toUpperCase())));
        }

        public void close() throws IOException {
            super.close();
            this.field = null;
            this.text = null;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return this.endEnum;
        }

        protected boolean termCompare(Term term) {
            if (this.field == term.field()) {
                String searchText = term.text();
                return this.text.equals(searchText.toLowerCase());
            }
            this.endEnum = true;
            return false;
        }
    }
}

