/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.portlet.impl.info.ContainerTypeInfo;

public class ContainerEventInfo
implements EventInfo {
    private final QName name;
    private final ContainerTypeInfo type;
    private final LocalizedString displayName;
    private final LocalizedString description;
    private final List<QName> aliases;

    public ContainerEventInfo(QName name, ContainerTypeInfo type, LocalizedString displayName, LocalizedString description, List<QName> aliases) {
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.description = description;
        this.aliases = ParameterValidation.existsAndIsNotEmpty(aliases) ? aliases : new ArrayList<QName>();
    }

    public LocalizedString getDisplayName() {
        return this.displayName;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public QName getName() {
        return this.name;
    }

    public ContainerTypeInfo getType() {
        return this.type;
    }

    public Collection<QName> getAliases() {
        return Collections.unmodifiableCollection(this.aliases);
    }
}

