/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedStringsTable
extends POIXMLDocumentPart {
    private final List<CTRst> strings = new ArrayList<CTRst>();
    private final Map<String, Integer> stmap = new HashMap<String, Integer>();
    private int count;
    private int uniqueCount;
    private SstDocument _sstDoc;

    public SharedStringsTable() {
        this._sstDoc = SstDocument.Factory.newInstance();
        this._sstDoc.addNewSst();
    }

    public SharedStringsTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            int cnt = 0;
            this._sstDoc = SstDocument.Factory.parse((InputStream)is);
            CTSst sst = this._sstDoc.getSst();
            this.count = (int)sst.getCount();
            this.uniqueCount = (int)sst.getUniqueCount();
            for (CTRst st : sst.getSiArray()) {
                this.stmap.put(st.toString(), cnt);
                this.strings.add(st);
                ++cnt;
            }
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public CTRst getEntryAt(int idx) {
        return this.strings.get(idx);
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public int addEntry(CTRst st) {
        String s = st.toString();
        ++this.count;
        if (this.stmap.containsKey(s)) {
            return this.stmap.get(s);
        }
        ++this.uniqueCount;
        CTRst newSt = this._sstDoc.getSst().addNewSi();
        newSt.set((XmlObject)st);
        int idx = this.strings.size();
        this.stmap.put(s, idx);
        this.strings.add(newSt);
        return idx;
    }

    public List<CTRst> getItems() {
        return this.strings;
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(DEFAULT_XML_OPTIONS);
        CTSst sst = this._sstDoc.getSst();
        sst.setCount((long)this.count);
        sst.setUniqueCount((long)this.uniqueCount);
        this._sstDoc.save(out, options);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }
}

