/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.management.ManagementFactory;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.PARTITION;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PrimaryPartitionTest {
    public static void main(String[] args) throws Exception {
        final JChannel ch = new JChannel("/home/bela/udp.xml");
        ch.getProtocolStack().insertProtocol((Protocol)new PARTITION(), 1, "UDP");
        ch.setReceiver(new ExtendedReceiverAdapter(){

            @Override
            public void viewAccepted(View new_view) {
                PrimaryPartitionTest.handleView(ch, new_view);
            }
        });
        ch.connect("x");
        JmxConfigurator.registerChannel(ch, ManagementFactory.getPlatformMBeanServer(), "demo", ch.getClusterName(), true);
        while (ch.isConnected()) {
            Util.sleep(5000L);
        }
    }

    private static void handleView(JChannel ch, View new_view) {
        System.out.println("VIEW: " + new_view);
        if (new_view instanceof MergeView) {
            ViewHandler handler = new ViewHandler(ch, (MergeView)new_view);
            handler.start();
        }
    }

    private static class ViewHandler
    extends Thread {
        JChannel ch;
        MergeView view;

        private ViewHandler(JChannel ch, MergeView view) {
            this.ch = ch;
            this.view = view;
        }

        @Override
        public void run() {
            Vector<View> subgroups = this.view.getSubgroups();
            View tmp_view = ViewHandler.getPrimaryView(subgroups);
            Address local_addr = this.ch.getLocalAddress();
            if (!tmp_view.getMembers().contains(local_addr)) {
                System.out.println("I (" + local_addr + ") am not member of the new primary partition (" + tmp_view + "), will re-acquire the state");
                try {
                    this.ch.getState(null, 30000L);
                }
                catch (Exception ex) {}
            } else {
                System.out.println("I (" + local_addr + ") am member of the new primary partition (" + tmp_view + "), will do nothing");
            }
        }

        private static View getPrimaryView(Vector<View> subgroups) {
            return subgroups.firstElement();
        }
    }
}

