/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.QueryManager;
import javax.naming.NameNotFoundException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.RepositoryCreationSynchronizer;
import org.exoplatform.services.jcr.impl.RepositorySuspendController;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.checker.RepositoryCheckController;
import org.exoplatform.services.jcr.impl.core.AddNamespacePluginHolder;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.ScratchWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.access.DefaultAccessManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.JCRNodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryManagerFactory;
import org.exoplatform.services.jcr.impl.core.query.RepositoryIndexSearcherHolder;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManager;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LinkedWorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.impl.storage.value.StandaloneStoragePluginProvider;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="repository", value="{Name}")})
@NamingContext(value={@Property(key="repository", value="{Name}")})
public class RepositoryContainer
extends ExoContainer {
    private final RepositoryEntry config;
    private final String name;
    private LocalWorkspaceDataManagerStub systemDataManager = null;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryContainer");
    private List<ComponentPlugin> addNamespacePlugins;

    public RepositoryContainer(final ExoContainer parent, RepositoryEntry config, List<ComponentPlugin> addNamespacePlugins) throws RepositoryException, RepositoryConfigurationException {
        super((ComponentAdapterFactory)new MX4JComponentAdapterFactory(), (PicoContainer)parent);
        if (config.getAccessControl() == null) {
            config.setAccessControl("optional");
        }
        this.config = config;
        this.addNamespacePlugins = addNamespacePlugins;
        this.name = config.getName();
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryConfigurationException {
                    RepositoryContainer.this.context.setName(parent.getContext().getName() + "-" + RepositoryContainer.this.name);
                    try {
                        parent.registerComponentInstance((Object)RepositoryContainer.this.name, (Object)RepositoryContainer.this);
                        RepositoryContainer.this.registerComponents();
                    }
                    catch (Throwable t) {
                        RepositoryContainer.this.unregisterAllComponents();
                        parent.unregisterComponent((Object)RepositoryContainer.this.name);
                        throw new RepositoryConfigurationException("Can not register repository container " + RepositoryContainer.this.name + " in parent container.", t);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof RepositoryConfigurationException) {
                throw (RepositoryConfigurationException)ex;
            }
            throw new RepositoryConfigurationException(ex.getMessage(), ex);
        }
    }

    public RepositoryContainer(ExoContainer parent, RepositoryEntry config) throws RepositoryException, RepositoryConfigurationException {
        this(parent, config, new ArrayList<ComponentPlugin>());
    }

    public LocationFactory getLocationFactory() {
        return (LocationFactory)this.getComponentInstanceOfType(LocationFactory.class);
    }

    @Managed
    @ManagedDescription(value="The repository container name")
    public String getName() {
        return this.name;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return (NamespaceRegistry)this.getComponentInstanceOfType(NamespaceRegistry.class);
    }

    public ExtendedNodeTypeManager getNodeTypeManager() {
        return (ExtendedNodeTypeManager)this.getComponentInstanceOfType(NodeTypeManager.class);
    }

    public WorkspaceContainer getWorkspaceContainer(String workspaceName) {
        Object comp = this.getComponentInstance(workspaceName);
        return comp != null && comp instanceof WorkspaceContainer ? (WorkspaceContainer)((Object)comp) : null;
    }

    public WorkspaceEntry getWorkspaceEntry(String wsName) {
        for (WorkspaceEntry entry : this.config.getWorkspaceEntries()) {
            if (!entry.getName().equals(wsName)) continue;
            return entry;
        }
        return null;
    }

    public void registerWorkspace(final WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryException, RepositoryConfigurationException {
                    Class initilizerType;
                    boolean isSystem = RepositoryContainer.this.config.getSystemWorkspaceName().equals(wsConfig.getName());
                    if (RepositoryContainer.this.getWorkspaceContainer(wsConfig.getName()) != null) {
                        throw new RepositoryException("Workspace " + wsConfig.getName() + " already registered");
                    }
                    WorkspaceContainer workspaceContainer = new WorkspaceContainer(RepositoryContainer.this, wsConfig);
                    RepositoryContainer.this.registerComponentInstance(wsConfig.getName(), (Object)workspaceContainer);
                    wsConfig.setUniqueName(RepositoryContainer.this.getName() + "_" + wsConfig.getName());
                    workspaceContainer.registerComponentInstance(wsConfig);
                    workspaceContainer.registerComponentImplementation(StandaloneStoragePluginProvider.class);
                    try {
                        Class<?> containerType = Class.forName(wsConfig.getContainer().getType());
                        workspaceContainer.registerComponentImplementation(containerType);
                        if (isSystem) {
                            RepositoryContainer.this.registerComponentInstance(new SystemDataContainerHolder((WorkspaceDataContainer)workspaceContainer.getComponentInstanceOfType(WorkspaceDataContainer.class)));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RepositoryConfigurationException("Class not found for workspace data container " + wsConfig.getUniqueName() + " : " + e);
                    }
                    try {
                        String className = wsConfig.getCache().getType();
                        if (className != null && className.length() > 0) {
                            workspaceContainer.registerComponentImplementation(Class.forName(className));
                        } else {
                            workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        RepositoryContainer.this.log.warn((Object)("Workspace cache class not found " + wsConfig.getCache().getType() + ", will use default. Error : " + e));
                        workspaceContainer.registerComponentImplementation(LinkedWorkspaceStorageCacheImpl.class);
                    }
                    workspaceContainer.registerComponentImplementation(CacheableWorkspaceDataManager.class);
                    workspaceContainer.registerComponentImplementation(LocalWorkspaceDataManagerStub.class);
                    workspaceContainer.registerComponentImplementation(ObservationManagerRegistry.class);
                    if (wsConfig.getLockManager() != null && wsConfig.getLockManager().getPersister() != null) {
                        try {
                            Class<?> lockPersister = Class.forName(wsConfig.getLockManager().getPersister().getType());
                            workspaceContainer.registerComponentImplementation(lockPersister);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RepositoryConfigurationException("Class not found for workspace lock persister " + wsConfig.getLockManager().getPersister().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                        }
                    }
                    if (wsConfig.getLockManager() != null && wsConfig.getLockManager().getType() != null) {
                        try {
                            Class<?> lockManagerType = Class.forName(wsConfig.getLockManager().getType());
                            workspaceContainer.registerComponentImplementation(lockManagerType);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RepositoryConfigurationException("Class not found for workspace lock manager " + wsConfig.getLockManager().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                        }
                    } else {
                        workspaceContainer.registerComponentImplementation(LockManagerImpl.class);
                    }
                    if (wsConfig.getQueryHandler() != null) {
                        workspaceContainer.registerComponentImplementation(SearchManager.class);
                        workspaceContainer.registerComponentImplementation(QueryManager.class);
                        workspaceContainer.registerComponentImplementation(QueryManagerFactory.class);
                        workspaceContainer.registerComponentInstance(wsConfig.getQueryHandler());
                        if (isSystem) {
                            workspaceContainer.registerComponentImplementation(SystemSearchManager.class);
                        }
                    }
                    if (wsConfig.getAccessManager() != null && wsConfig.getAccessManager().getType() != null) {
                        try {
                            Class<?> am = Class.forName(wsConfig.getAccessManager().getType());
                            workspaceContainer.registerComponentImplementation(am);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RepositoryConfigurationException("Class not found for workspace access manager " + wsConfig.getAccessManager().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                        }
                    }
                    if (wsConfig.getInitializer() != null && wsConfig.getInitializer().getType() != null) {
                        try {
                            initilizerType = Class.forName(wsConfig.getInitializer().getType());
                        }
                        catch (ClassNotFoundException e) {
                            throw new RepositoryConfigurationException("Class not found for workspace initializer " + wsConfig.getInitializer().getType() + ", container " + wsConfig.getUniqueName() + " : " + e);
                        }
                    } else {
                        initilizerType = ScratchWorkspaceInitializer.class;
                    }
                    workspaceContainer.registerComponentImplementation(initilizerType);
                    workspaceContainer.registerComponentImplementation(TransactionableResourceManager.class);
                    workspaceContainer.registerComponentImplementation(SessionFactory.class);
                    LocalWorkspaceDataManagerStub wsDataManager = (LocalWorkspaceDataManagerStub)workspaceContainer.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
                    if (isSystem) {
                        RepositoryContainer.this.systemDataManager = wsDataManager;
                        RepositoryContainer.this.registerComponentInstance(RepositoryContainer.this.systemDataManager);
                    }
                    wsDataManager.setSystemDataManager(RepositoryContainer.this.systemDataManager);
                    if (!RepositoryContainer.this.config.getWorkspaceEntries().contains(wsConfig)) {
                        RepositoryContainer.this.config.getWorkspaceEntries().add(wsConfig);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof RepositoryConfigurationException) {
                throw (RepositoryConfigurationException)cause;
            }
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            if (cause instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)cause;
                Throwable retval = e;
                for (int depth = 0; retval.getCause() != null && depth < 100; ++depth) {
                    if ((retval = retval.getCause()) instanceof RepositoryException) {
                        throw new RepositoryException(retval.getMessage(), (Throwable)e);
                    }
                    if (retval instanceof RepositoryConfigurationException) {
                        throw new RepositoryConfigurationException(retval.getMessage(), e);
                    }
                    if (!(retval instanceof NameNotFoundException)) continue;
                    throw new RepositoryException(retval.getMessage(), (Throwable)e);
                }
                throw e;
            }
            throw new RepositoryException(cause);
        }
    }

    public void start() {
        try {
            this.init();
            this.load();
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Repository error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            this.log.error((Object)"Configuration error", (Throwable)e);
            throw new RuntimeException(e);
        }
        super.start();
    }

    public synchronized void stop() {
        RepositoryImpl repository = (RepositoryImpl)this.getComponentInstanceOfType(RepositoryImpl.class);
        try {
            repository.setState(0);
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Can not switch repository to OFFLINE", (Throwable)e);
        }
        super.stop();
        super.unregisterAllComponents();
    }

    private void init() throws RepositoryException, RepositoryConfigurationException {
        ArrayList<WorkspaceEntry> wsEntries = this.config.getWorkspaceEntries();
        NodeTypeDataManager typeManager = (NodeTypeDataManager)this.getComponentInstanceOfType(NodeTypeDataManager.class);
        NamespaceRegistryImpl namespaceRegistry = (NamespaceRegistryImpl)this.getComponentInstanceOfType(NamespaceRegistry.class);
        for (WorkspaceEntry ws : wsEntries) {
            this.initWorkspace(ws);
            WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(ws.getName());
            SearchManager searchManager = (SearchManager)workspaceContainer.getComponentInstanceOfType(SearchManager.class);
        }
        SystemSearchManagerHolder searchManager = (SystemSearchManagerHolder)this.getComponentInstanceOfType(SystemSearchManagerHolder.class);
    }

    private void initWorkspace(WorkspaceEntry wsConfig) throws RepositoryException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer(wsConfig.getName());
        workspaceContainer.getComponentInstanceOfType(IdGenerator.class);
        WorkspaceInitializer wsInitializer = (WorkspaceInitializer)workspaceContainer.getComponentInstanceOfType(WorkspaceInitializer.class);
        RepositoryCreationSynchronizer synchronizer = (RepositoryCreationSynchronizer)this.getComponentInstanceOfType(RepositoryCreationSynchronizer.class);
        synchronizer.waitForApproval(wsInitializer.isWorkspaceInitialized());
        wsInitializer.initWorkspace();
    }

    private void registerComponents() throws RepositoryConfigurationException, RepositoryException {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RepositoryContainer.this.registerComponentInstance(RepositoryContainer.this.config);
                RepositoryContainer.this.registerComponentImplementation(FileCleanerHolder.class);
                RepositoryContainer.this.registerComponentImplementation(LockRemoverHolder.class);
                return null;
            }
        });
        this.registerWorkspacesComponents();
        this.registerRepositoryComponents();
    }

    private void registerRepositoryComponents() throws RepositoryConfigurationException, RepositoryException {
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryConfigurationException, RepositoryException {
                    RepositoryContainer.this.registerComponentImplementation(RepositorySuspendController.class);
                    RepositoryContainer.this.registerComponentImplementation(RepositoryCheckController.class);
                    RepositoryContainer.this.registerComponentImplementation(IdGenerator.class);
                    RepositoryContainer.this.registerComponentImplementation(RepositoryIndexSearcherHolder.class);
                    RepositoryContainer.this.registerComponentImplementation(LocationFactory.class);
                    RepositoryContainer.this.registerComponentImplementation(ValueFactoryImpl.class);
                    RepositoryContainer.this.registerComponentInstance(new AddNamespacePluginHolder(RepositoryContainer.this.addNamespacePlugins));
                    RepositoryContainer.this.registerComponentImplementation(JCRNodeTypeDataPersister.class);
                    RepositoryContainer.this.registerComponentImplementation(NamespaceDataPersister.class);
                    RepositoryContainer.this.registerComponentImplementation(NamespaceRegistryImpl.class);
                    RepositoryContainer.this.registerComponentImplementation(NodeTypeManagerImpl.class);
                    RepositoryContainer.this.registerComponentImplementation(NodeTypeDataManagerImpl.class);
                    RepositoryContainer.this.registerComponentImplementation(DefaultAccessManagerImpl.class);
                    RepositoryContainer.this.registerComponentImplementation(SessionRegistry.class);
                    String systemWsname = RepositoryContainer.this.config.getSystemWorkspaceName();
                    WorkspaceEntry systemWsEntry = RepositoryContainer.this.getWorkspaceEntry(systemWsname);
                    if (systemWsEntry != null && systemWsEntry.getQueryHandler() != null) {
                        SystemSearchManager systemSearchManager = (SystemSearchManager)RepositoryContainer.this.getWorkspaceContainer(systemWsname).getComponentInstanceOfType(SystemSearchManager.class);
                        RepositoryContainer.this.registerComponentInstance(new SystemSearchManagerHolder(systemSearchManager));
                    }
                    try {
                        Class<?> authenticationPolicyClass = Class.forName(RepositoryContainer.this.config.getAuthenticationPolicy());
                        RepositoryContainer.this.registerComponentImplementation(authenticationPolicyClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RepositoryConfigurationException("Class not found for repository authentication policy: " + e);
                    }
                    RepositoryImpl repository = new RepositoryImpl(RepositoryContainer.this);
                    RepositoryContainer.this.registerComponentInstance(repository);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof RepositoryConfigurationException) {
                throw (RepositoryConfigurationException)cause;
            }
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            throw new RepositoryException(cause);
        }
    }

    private void registerWorkspacesComponents() throws RepositoryException, RepositoryConfigurationException {
        for (WorkspaceEntry we : this.config.getWorkspaceEntries()) {
            if (!we.getName().equals(this.config.getSystemWorkspaceName())) continue;
            this.registerWorkspace(we);
        }
        for (WorkspaceEntry we : this.config.getWorkspaceEntries()) {
            if (we.getName().equals(this.config.getSystemWorkspaceName())) continue;
            this.registerWorkspace(we);
        }
    }

    private void load() throws RepositoryException {
        NamespaceDataPersister namespacePersister = (NamespaceDataPersister)this.getComponentInstanceOfType(NamespaceDataPersister.class);
        NamespaceRegistryImpl nsRegistry = (NamespaceRegistryImpl)this.getNamespaceRegistry();
        namespacePersister.start();
        nsRegistry.start();
        JCRNodeTypeDataPersister nodeTypePersister = (JCRNodeTypeDataPersister)this.getComponentInstanceOfType(JCRNodeTypeDataPersister.class);
        NodeTypeDataManagerImpl ntManager = (NodeTypeDataManagerImpl)this.getComponentInstanceOfType(NodeTypeDataManagerImpl.class);
        nodeTypePersister.start();
        ntManager.start();
    }
}

