/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryRestore
implements DataRestore {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DirectoryRestorer");
    protected final List<File> dataDirs = new ArrayList<File>();
    protected final List<File> zipFiles = new ArrayList<File>();
    private final List<File> tmpDirs = new ArrayList<File>();
    protected final File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
    private static final String PREFIX = "dr";

    public DirectoryRestore(List<File> dataDirs, List<File> zipFiles) {
        this.dataDirs.addAll(dataDirs);
        this.zipFiles.addAll(zipFiles);
    }

    public DirectoryRestore(File dataDir, File zipFile) {
        this.dataDirs.add(dataDir);
        this.zipFiles.add(zipFile);
    }

    @Override
    public void clean() throws BackupException {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    for (int i = 0; i < DirectoryRestore.this.dataDirs.size(); ++i) {
                        File dataDir = DirectoryRestore.this.dataDirs.get(i);
                        File tmpDir = new File(DirectoryRestore.this.tempDir, DirectoryRestore.PREFIX + IdGenerator.generate());
                        tmpDir.mkdirs();
                        DirectoryRestore.this.tmpDirs.add(tmpDir);
                        if (!dataDir.exists()) continue;
                        DirectoryHelper.copyDirectory(dataDir, tmpDir);
                        DirectoryHelper.removeDirectory(dataDir);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void restore() throws BackupException {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    for (int i = 0; i < DirectoryRestore.this.zipFiles.size(); ++i) {
                        File zipFile = DirectoryRestore.this.zipFiles.get(i);
                        File dataDir = DirectoryRestore.this.dataDirs.get(i);
                        if (zipFile.isDirectory()) {
                            DirectoryHelper.uncompressEveryFileFromDirectory(zipFile, dataDir);
                            continue;
                        }
                        DirectoryHelper.uncompressDirectory(zipFile, dataDir);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void commit() throws BackupException {
    }

    @Override
    public void rollback() throws BackupException {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    for (int i = 0; i < DirectoryRestore.this.tmpDirs.size(); ++i) {
                        File tmpDir = (File)DirectoryRestore.this.tmpDirs.get(i);
                        File dataDir = DirectoryRestore.this.dataDirs.get(i);
                        if (dataDir.exists()) {
                            DirectoryHelper.removeDirectory(dataDir);
                        }
                        DirectoryHelper.copyDirectory(tmpDir, dataDir);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void close() throws BackupException {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    for (File tmpDir : DirectoryRestore.this.tmpDirs) {
                        DirectoryHelper.removeDirectory(tmpDir);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        this.dataDirs.clear();
        this.zipFiles.clear();
        this.tmpDirs.clear();
    }
}

