/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class EarlierVersionsRemover
extends AbstractInconsistencyRepair {
    public EarlierVersionsRemover(WorkspaceStorageConnectionFactory connFactory) {
        super(connFactory);
    }

    protected void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            PropertyData data = (PropertyData)conn.getItemData(this.exctractId(resultSet, "ID"));
            int maxVersion = conn.getMaxPropertyVersion(data);
            if (resultSet.getInt("VERSION") < maxVersion) {
                conn.delete(data);
            }
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }
}

