/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cache.future;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.cache.future.Retrieval;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FutureCache<K, V, C> {
    final Loader<K, V, C> loader;
    private final ConcurrentMap<K, Retrieval<K, V, C>> futureEntries;
    private final Logger log = LoggerFactory.getLogger(FutureCache.class);

    public FutureCache(Loader<K, V, C> loader) {
        this.loader = loader;
        this.futureEntries = new ConcurrentHashMap<K, Retrieval<K, V, C>>();
    }

    protected abstract V get(K var1);

    protected abstract void put(K var1, V var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(C context, K key) {
        V value = this.get(key);
        if (value == null) {
            Retrieval retrieval = new Retrieval(context, key, this);
            boolean inserted = true;
            try {
                Retrieval phantom = this.futureEntries.putIfAbsent(key, retrieval);
                if (phantom != null) {
                    retrieval = phantom;
                    inserted = false;
                } else {
                    try {
                        retrieval.current = Thread.currentThread();
                        retrieval.future.run();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Retrieval of resource " + key + " threw an exception"), (Throwable)e);
                    }
                    finally {
                        retrieval.current = null;
                    }
                }
                if (retrieval.current == Thread.currentThread()) {
                    throw new IllegalStateException("Reentrancy detected when obtaining key " + key + " with context " + context + " detected");
                }
                try {
                    value = retrieval.future.get();
                }
                catch (ExecutionException e) {
                    this.log.error((Object)("Computing of resource " + key + " threw an exception"), e.getCause());
                }
                catch (InterruptedException e) {
                    this.log.error((Object)("Retrieval of resource " + key + " threw an exception"), (Throwable)e);
                }
            }
            finally {
                if (inserted) {
                    this.futureEntries.remove(key, retrieval);
                }
            }
        }
        return value;
    }
}

