/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Locale;

public class I18N {
    public static String toJavaIdentifier(Locale locale) throws NullPointerException {
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        return locale.toString();
    }

    private static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static Locale parseJavaIdentifier(String s) throws NullPointerException, IllegalArgumentException {
        if (s.length() == 0) {
            throw new IllegalArgumentException("Empty locale");
        }
        char c0 = s.charAt(0);
        if (c0 == '_') {
            return I18N.parseCountry("", s, 0);
        }
        if (!I18N.isLetter(c0) || s.length() < 2 || !I18N.isLetter(s.charAt(1))) {
            throw new IllegalArgumentException();
        }
        return I18N.parseCountry(s.substring(0, 2), s, 2);
    }

    private static Locale parseCountry(String lang, String s, int index) throws IllegalArgumentException {
        if (s.length() == index) {
            return new Locale(lang);
        }
        if (s.charAt(index) != '_' || s.length() < index + 3) {
            throw new IllegalArgumentException();
        }
        char c0 = s.charAt(index + 1);
        if (c0 == '_') {
            if (lang.length() == 0) {
                throw new IllegalArgumentException();
            }
            return I18N.parseVariant(lang, "", s, index + 1);
        }
        if (!I18N.isLetter(c0) || !I18N.isLetter(s.charAt(index + 2))) {
            throw new IllegalArgumentException();
        }
        return I18N.parseVariant(lang, s.substring(index + 1, index + 3), s, index + 3);
    }

    private static Locale parseVariant(String lang, String country, String s, int index) throws IllegalArgumentException {
        if (s.length() == index) {
            return new Locale(lang, country);
        }
        if (s.charAt(index) != '_' || s.length() < index + 2) {
            throw new IllegalArgumentException();
        }
        for (int i = index + 1; i < s.length(); ++i) {
            if (I18N.isLetter(s.charAt(i))) continue;
            throw new IllegalArgumentException();
        }
        String variant = s.substring(index + 1);
        return new Locale(lang, country, variant);
    }

    public static String toTagIdentifier(Locale locale) throws NullPointerException {
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        String country = locale.getCountry();
        String lang = locale.getLanguage();
        if (country != null && country.length() > 0) {
            return lang + "-" + country;
        }
        return lang;
    }

    public static Locale parseTagIdentifier(String s) throws NullPointerException, IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("No null string accepted");
        }
        if (s.length() == 2) {
            return new Locale(s.substring(0, 2));
        }
        if (s.length() == 5 && s.charAt(2) == '-') {
            String lang = s.substring(0, 2);
            String country = s.substring(3, 5);
            return new Locale(lang, country);
        }
        throw new IllegalArgumentException("Locale " + s + " cannot be parsed");
    }
}

